/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.upgrade;

import io.gravitee.common.data.domain.Page;
import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.PageType;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.common.Pageable;
import io.gravitee.management.model.common.PageableImpl;
import io.gravitee.management.model.documentation.PageQuery;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.PageService;
import io.gravitee.management.service.Upgrader;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.search.SearchEngineService;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.UserStatus;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class SearchIndexUpgrader
implements Upgrader,
Ordered {
    @Autowired
    private ApiService apiService;
    @Autowired
    private PageService pageService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchEngineService searchEngineService;

    @Override
    public boolean upgrade() {
        Set<ApiEntity> apis = this.apiService.findAll();
        apis.forEach(apiEntity -> {
            this.searchEngineService.index((Indexable)apiEntity);
            List<PageEntity> apiPages = this.pageService.search(new PageQuery.Builder().api(apiEntity.getId()).published(Boolean.valueOf(true)).build());
            apiPages.forEach(page -> {
                try {
                    if (!PageType.FOLDER.name().equals(page.getType()) && !PageType.ROOT.name().equals(page.getType())) {
                        this.pageService.transformSwagger((PageEntity)page, apiEntity.getId());
                        this.searchEngineService.index((Indexable)page);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        });
        Page<UserEntity> users = this.userService.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ACTIVE}).build(), (Pageable)new PageableImpl(1, Integer.MAX_VALUE));
        users.getContent().forEach(userEntity -> this.searchEngineService.index((Indexable)userEntity));
        return true;
    }

    @Override
    public int getOrder() {
        return 250;
    }
}

