/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.transformer;

import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.lucene.DocumentTransformer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Component;

@Component
public class UserDocumentTransformer
implements DocumentTransformer {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_TYPE_VALUE = "user";
    private static final String FIELD_FIRSTNAME = "firstname";
    private static final String FIELD_LASTNAME = "lastname";
    private static final String FIELD_DISPLAYNAME = "displayname";
    private static final String FIELD_DISPLAYNAME_SPLIT = "displayname_split";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_REFERENCE = "reference";

    @Override
    public Document transform(Indexable indexable) {
        Document doc = new Document();
        UserEntity user = (UserEntity)indexable;
        doc.add((IndexableField)new StringField(FIELD_ID, user.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_TYPE, FIELD_TYPE_VALUE, Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_SOURCE, user.getSource(), Field.Store.NO));
        doc.add((IndexableField)new StringField(FIELD_REFERENCE, user.getSourceId(), Field.Store.NO));
        if (user.getDisplayName() != null) {
            doc.add((IndexableField)new StringField(FIELD_DISPLAYNAME, user.getDisplayName(), Field.Store.NO));
            doc.add((IndexableField)new TextField(FIELD_DISPLAYNAME_SPLIT, user.getDisplayName(), Field.Store.NO));
        }
        if (user.getFirstname() != null) {
            doc.add((IndexableField)new StringField(FIELD_FIRSTNAME, user.getFirstname(), Field.Store.NO));
        }
        if (user.getLastname() != null) {
            doc.add((IndexableField)new StringField(FIELD_LASTNAME, user.getLastname(), Field.Store.NO));
        }
        if (user.getEmail() != null) {
            doc.add((IndexableField)new StringField(FIELD_EMAIL, user.getEmail(), Field.Store.NO));
        }
        return doc;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return UserEntity.class.isAssignableFrom(source);
    }
}

