/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.searcher;

import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.repository.exceptions.TechnicalException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.springframework.stereotype.Component;

@Component
public class PageDocumentSearcher
extends AbstractDocumentSearcher {
    protected static final String FIELD_TYPE_VALUE = "page";

    @Override
    public SearchResult search(io.gravitee.management.service.search.query.Query query) throws TechnicalException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"name", "content"}, this.analyzer);
        parser.setFuzzyMinSim(0.6f);
        try {
            Query parse = parser.parse(QueryParserBase.escape((String)query.getQuery()));
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add(parse, BooleanClause.Occur.MUST);
            bq.add((Query)new TermQuery(new Term("type", FIELD_TYPE_VALUE)), BooleanClause.Occur.MUST);
            return this.search((Query)bq.build());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for page documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for page documents", (Throwable)pe);
        }
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(PageEntity.class);
    }
}

