/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search.lucene.searcher;

import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.repository.exceptions.TechnicalException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class ApiDocumentSearcher
extends AbstractDocumentSearcher {
    private static final String FIELD_API_TYPE_VALUE = "api";
    private static final String FIELD_PAGE_TYPE_VALUE = "page";
    private static final Map<String, Float> API_FIELD_BOOST = new HashMap<String, Float>(){
        {
            this.put("name", Float.valueOf(12.0f));
            this.put("name_lowercase", Float.valueOf(12.0f));
            this.put("name_split", Float.valueOf(10.0f));
            this.put("path", Float.valueOf(10.0f));
            this.put("labels", Float.valueOf(8.0f));
            this.put("description", Float.valueOf(6.0f));
        }
    };
    private static final Map<String, Float> PAGE_FIELD_BOOST = new HashMap<String, Float>(){
        {
            this.put("name", Float.valueOf(1.0f));
            this.put("content", Float.valueOf(1.0f));
        }
    };

    @Override
    public SearchResult search(io.gravitee.management.service.search.query.Query query) throws TechnicalException {
        MultiFieldQueryParser apiParser = new MultiFieldQueryParser(new String[]{"id", "name", "name_lowercase", "name_split", "description", "ownerName", "ownerMail", "labels", "tags", "views", "path", "path_split"}, this.analyzer, API_FIELD_BOOST);
        apiParser.setFuzzyMinSim(0.6f);
        apiParser.setAllowLeadingWildcard(true);
        MultiFieldQueryParser pageParser = new MultiFieldQueryParser(new String[]{"name", "content"}, this.analyzer, PAGE_FIELD_BOOST);
        pageParser.setFuzzyMinSim(0.6f);
        pageParser.setAllowLeadingWildcard(true);
        try {
            String inputQuery = QueryParserBase.escape((String)query.getQuery());
            Query parse = apiParser.parse(inputQuery);
            Query parsePage = pageParser.parse(inputQuery);
            Query apisFilter = this.getApisFilter("id", query.getFilters());
            BooleanQuery.Builder apiQuery = new BooleanQuery.Builder();
            BooleanQuery.Builder apiFieldsQuery = new BooleanQuery.Builder();
            apiFieldsQuery.add(parse, BooleanClause.Occur.SHOULD);
            apiFieldsQuery.add((Query)new WildcardQuery(new Term("name", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            apiFieldsQuery.add((Query)new WildcardQuery(new Term("name_lowercase", '*' + query.getQuery().toLowerCase() + '*')), BooleanClause.Occur.SHOULD);
            apiFieldsQuery.add((Query)new WildcardQuery(new Term("path", '*' + query.getQuery() + '*')), BooleanClause.Occur.SHOULD);
            apiQuery.add((Query)apiFieldsQuery.build(), BooleanClause.Occur.MUST);
            apiQuery.add((Query)new TermQuery(new Term("type", FIELD_API_TYPE_VALUE)), BooleanClause.Occur.MUST);
            if (apisFilter != null) {
                apiQuery.add(apisFilter, BooleanClause.Occur.MUST);
            }
            BooleanQuery.Builder pageQuery = new BooleanQuery.Builder();
            pageQuery.add(parsePage, BooleanClause.Occur.MUST);
            pageQuery.add((Query)new TermQuery(new Term("type", FIELD_PAGE_TYPE_VALUE)), BooleanClause.Occur.MUST);
            apisFilter = this.getApisFilter(FIELD_API_TYPE_VALUE, query.getFilters());
            if (apisFilter != null) {
                pageQuery.add(apisFilter, BooleanClause.Occur.MUST);
            } else {
                pageQuery.add((Query)new DocValuesFieldExistsQuery(FIELD_API_TYPE_VALUE), BooleanClause.Occur.MUST);
            }
            BooleanQuery.Builder mainQuery = new BooleanQuery.Builder();
            mainQuery.add((Query)new BoostQuery((Query)apiQuery.build(), 2.0f), BooleanClause.Occur.SHOULD);
            mainQuery.add((Query)pageQuery.build(), BooleanClause.Occur.SHOULD);
            if (query.getFilters() != null) {
                final BooleanQuery.Builder filtersQuery = new BooleanQuery.Builder();
                final boolean[] hasClause = new boolean[]{false};
                query.getFilters().forEach(new BiConsumer<String, Object>(){

                    @Override
                    public void accept(String field, Object value) {
                        if (!Collection.class.isAssignableFrom(value.getClass())) {
                            filtersQuery.add((Query)new TermQuery(new Term(field, QueryParserBase.escape((String)((String)value)))), BooleanClause.Occur.MUST);
                            hasClause[0] = true;
                        }
                    }
                });
                if (hasClause[0]) {
                    mainQuery.add((Query)filtersQuery.build(), BooleanClause.Occur.MUST);
                }
            }
            return this.search((Query)mainQuery.build());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for API documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for API documents", (Throwable)pe);
        }
    }

    private Query getApisFilter(String field, Map<String, Object> filters) {
        Object filter = filters.get(FIELD_API_TYPE_VALUE);
        if (filter != null) {
            BooleanQuery.Builder filterApisQuery = new BooleanQuery.Builder();
            ((Collection)filter).stream().forEach(value1 -> filterApisQuery.add((Query)new TermQuery(new Term(field, (String)value1)), BooleanClause.Occur.SHOULD));
            return filterApisQuery.build();
        }
        return null;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(ApiEntity.class);
    }

    @Override
    protected String getReference(Document document) {
        String type = document.get("type");
        if (FIELD_API_TYPE_VALUE.equals(type)) {
            return document.get("id");
        }
        if (FIELD_PAGE_TYPE_VALUE.equals(type)) {
            return document.get(FIELD_API_TYPE_VALUE);
        }
        return null;
    }
}

