/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.search;

import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.impl.search.lucene.DocumentSearcher;
import io.gravitee.management.service.impl.search.lucene.DocumentTransformer;
import io.gravitee.management.service.impl.search.lucene.SearchEngineIndexer;
import io.gravitee.management.service.search.SearchEngineService;
import io.gravitee.management.service.search.query.Query;
import io.gravitee.repository.exceptions.TechnicalException;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SearchEngineServiceImpl
implements SearchEngineService {
    private final Logger logger = LoggerFactory.getLogger(SearchEngineServiceImpl.class);
    @Autowired
    private SearchEngineIndexer indexer;
    @Autowired
    private Collection<DocumentTransformer> transformers;
    @Autowired
    private Collection<DocumentSearcher> searchers;

    @Override
    @Async
    public void index(Indexable source) {
        this.transformers.stream().filter(transformer -> transformer.handle(source.getClass())).findFirst().ifPresent(transformer -> {
            try {
                this.indexer.index(transformer.transform(source));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while indexing a document", (Throwable)te);
            }
        });
    }

    @Override
    @Async
    public void delete(Indexable source) {
        this.transformers.stream().filter(transformer -> transformer.handle(source.getClass())).findFirst().ifPresent(transformer -> {
            try {
                this.indexer.remove(transformer.transform(source));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while deleting a document", (Throwable)te);
            }
        });
    }

    @Override
    public SearchResult search(Query<? extends Indexable> query) {
        Optional results = this.searchers.stream().filter(searcher -> searcher.handle(query.getRoot())).findFirst().flatMap(searcher -> {
            try {
                return Optional.of(searcher.search(query));
            }
            catch (TechnicalException te) {
                this.logger.error("Unexpected error while deleting a document", (Throwable)te);
                return Optional.empty();
            }
        });
        return (SearchResult)results.get();
    }
}

