/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl.configuration.application.registration.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.management.service.impl.configuration.application.registration.client.DynamicClientRegistrationException;
import io.gravitee.management.service.impl.configuration.application.registration.client.OIDCClient;
import io.gravitee.management.service.impl.configuration.application.registration.client.register.ClientRegistrationRequest;
import io.gravitee.management.service.impl.configuration.application.registration.client.register.ClientRegistrationResponse;
import io.gravitee.management.service.impl.configuration.application.registration.client.token.TokenResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicClientRegistrationProviderClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper mapper = new ObjectMapper();
    private final OIDCClient client;
    protected CloseableHttpClient httpClient;
    protected String registrationEndpoint;
    protected String tokenEndpoint;

    public DynamicClientRegistrationProviderClient(OIDCClient client) {
        this.client = client;
    }

    public String generateToken() {
        HttpPost tokenRequest = new HttpPost(this.tokenEndpoint);
        ArrayList<BasicNameValuePair> tokenRequestParams = new ArrayList<BasicNameValuePair>();
        tokenRequestParams.add(new BasicNameValuePair("grant_type", "client_credentials"));
        if (this.client.getScopes() != null && !this.client.getScopes().isEmpty()) {
            tokenRequestParams.add(new BasicNameValuePair("scope", String.join((CharSequence)" ", this.client.getScopes())));
        }
        tokenRequest.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.client.getClientId() + ':' + this.client.getClientSecret()).getBytes()));
        tokenRequest.setHeader("Accept", "application/json");
        try {
            tokenRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(tokenRequestParams));
            return (String)this.httpClient.execute((HttpUriRequest)tokenRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        TokenResponse token = (TokenResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), TokenResponse.class);
                        return token.getAccessToken();
                    }
                    throw new DynamicClientRegistrationException("Token response does not contain any body");
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        this.logger.error("Unexpected response from OIDC Token endpoint: error[{}] description[{}]", (Object)error, (Object)description);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Token endpoint: error[" + error + "] description[" + description + "]");
                    }
                    catch (JsonProcessingException ex) {
                        this.logger.error("Unexpected response from OIDC Token endpoint: status[{}] message[{}]", (Object)status, (Object)responsePayload);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Token endpoint: status[" + status + "] message[" + responsePayload + "]");
                    }
                }
                this.logger.error("Unexpected response from OIDC Token endpoint: status[{}]", (Object)status);
                throw new DynamicClientRegistrationException("Unexpected response from OIDC Token endpoint: status[" + status + "]");
            });
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while generating an access_token: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while generating an access_token: " + ex.getMessage(), ex);
        }
    }

    protected ClientRegistrationResponse register(String accessToken, ClientRegistrationRequest request) {
        HttpPost registerRequest = new HttpPost(this.registrationEndpoint);
        registerRequest.setHeader("Authorization", "Bearer " + accessToken);
        registerRequest.setHeader("Accept", "application/json");
        try {
            registerRequest.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)request), ContentType.create((String)"application/json", (Charset)Charset.defaultCharset())));
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)registerRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return (ClientRegistrationResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), ClientRegistrationResponse.class);
                    }
                    throw new DynamicClientRegistrationException("Client registration response does not contain any body");
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        this.logger.error("Unexpected response from OIDC Registration endpoint: error[{}] description[{}]", (Object)error, (Object)description);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: error[" + error + "] description[" + description + "]");
                    }
                    catch (JsonProcessingException ex) {
                        this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}] message[{}]", (Object)status, (Object)responsePayload);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "] message[" + responsePayload + "]");
                    }
                }
                this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}]", (Object)status);
                throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "]");
            });
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while registering client: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while registering client: " + ex.getMessage(), ex);
        }
    }

    public ClientRegistrationResponse update(String registrationAccessToken, String registrationClientUri, ClientRegistrationRequest request) {
        HttpPut updateRequest = new HttpPut(registrationClientUri);
        updateRequest.setHeader("Authorization", "Bearer " + registrationAccessToken);
        updateRequest.setHeader("Accept", "application/json");
        try {
            JsonNode reqNode = this.mapper.readTree(this.mapper.writeValueAsString((Object)request));
            ((ObjectNode)reqNode).put("scope", String.join((CharSequence)" ", request.getScope()));
            updateRequest.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)reqNode), ContentType.create((String)"application/json", (Charset)Charset.defaultCharset())));
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)updateRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return (ClientRegistrationResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), ClientRegistrationResponse.class);
                    }
                    throw new DynamicClientRegistrationException("Client registration response does not contain any body");
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        this.logger.error("Unexpected response from OIDC Registration endpoint: error[{}] description[{}]", (Object)error, (Object)description);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: error[" + error + "] description[" + description + "]");
                    }
                    catch (JsonProcessingException ex) {
                        this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}] message[{}]", (Object)status, (Object)responsePayload);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "] message[" + responsePayload + "]");
                    }
                }
                this.logger.error("Unexpected response from OIDC Registration endpoint: status[{}]", (Object)status);
                throw new DynamicClientRegistrationException("Unexpected response from OIDC Registration endpoint: status[" + status + "]");
            });
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while registering client: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while registering client: " + ex.getMessage(), ex);
        }
    }

    public ClientRegistrationResponse register(ClientRegistrationRequest request) {
        String accessToken = this.generateToken();
        return this.register(accessToken, request);
    }
}

