/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTVerifier;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.utils.UUID;
import io.gravitee.management.model.InlinePictureEntity;
import io.gravitee.management.model.InvitationEntity;
import io.gravitee.management.model.NewApplicationEntity;
import io.gravitee.management.model.NewExternalUserEntity;
import io.gravitee.management.model.PictureEntity;
import io.gravitee.management.model.RegisterUserEntity;
import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.UpdateUserEntity;
import io.gravitee.management.model.UrlPictureEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.UserRoleEntity;
import io.gravitee.management.model.application.ApplicationSettings;
import io.gravitee.management.model.application.SimpleApplicationSettings;
import io.gravitee.management.model.common.Pageable;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.InvitationService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.NotifierService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.builder.EmailNotificationBuilder;
import io.gravitee.management.service.common.JWTHelper;
import io.gravitee.management.service.exceptions.DefaultRoleNotFoundException;
import io.gravitee.management.service.exceptions.EmailFormatInvalidException;
import io.gravitee.management.service.exceptions.StillPrimaryOwnerException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UserAlreadyExistsException;
import io.gravitee.management.service.exceptions.UserNotFoundException;
import io.gravitee.management.service.exceptions.UserNotInternallyManagedException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.notification.NotificationParamsBuilder;
import io.gravitee.management.service.notification.PortalHook;
import io.gravitee.management.service.search.SearchEngineService;
import io.gravitee.management.service.search.query.Query;
import io.gravitee.management.service.search.query.QueryBuilder;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.MembershipDefaultReferenceId;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.UserStatus;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class UserServiceImpl
extends AbstractService
implements UserService {
    private final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final String IDP_SOURCE_GRAVITEE = "gravitee";
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private EmailService emailService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private InvitationService invitationService;
    @Value(value="${user.avatar:${gravitee.home}/assets/default_user_avatar.png}")
    private String defaultAvatar;
    @Value(value="${user.login.defaultApplication:true}")
    private boolean defaultApplicationForFirstConnection;
    @Value(value="${user.anonymize-on-delete.enabled:false}")
    private boolean anonymizeOnDelete;
    private PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    @Override
    public UserEntity connect(String userId) {
        try {
            this.LOGGER.debug("Connection of {}", (Object)userId);
            Optional checkUser = this.userRepository.findById((Object)userId);
            if (!checkUser.isPresent()) {
                throw new UserNotFoundException(userId);
            }
            User user = (User)checkUser.get();
            User previousUser = new User(user);
            if (user.getLastConnectionAt() == null) {
                this.notifierService.trigger(PortalHook.USER_FIRST_LOGIN, new NotificationParamsBuilder().user(this.convert(user, false)).build());
                if (this.defaultApplicationForFirstConnection) {
                    this.LOGGER.debug("Create a default application for {}", (Object)userId);
                    NewApplicationEntity defaultApp = new NewApplicationEntity();
                    defaultApp.setName("Default application");
                    defaultApp.setDescription("My default application");
                    ApplicationSettings settings = new ApplicationSettings();
                    SimpleApplicationSettings simpleAppSettings = new SimpleApplicationSettings();
                    settings.setApp(simpleAppSettings);
                    defaultApp.setSettings(settings);
                    this.applicationService.create(defaultApp, userId);
                }
            }
            user.setLastConnectionAt(new Date());
            user.setUpdatedAt(user.getLastConnectionAt());
            User updatedUser = (User)this.userRepository.update((Object)user);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, userId), (Audit.AuditEvent)User.AuditEvent.USER_CONNECTED, user.getUpdatedAt(), previousUser, user);
            UserEntity userEntity = this.convert(updatedUser, true);
            this.searchEngineService.index((Indexable)userEntity);
            return userEntity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to connect {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to connect " + userId, ex);
        }
    }

    @Override
    public UserEntity findById(String id) {
        try {
            this.LOGGER.debug("Find user by ID: {}", (Object)id);
            Optional optionalUser = this.userRepository.findById((Object)id);
            if (optionalUser.isPresent()) {
                return this.convert((User)optionalUser.get(), false);
            }
            throw new UserNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find user using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find user using its ID " + id, ex);
        }
    }

    @Override
    public UserEntity findByIdWithRoles(String id) {
        try {
            this.LOGGER.debug("Find user by ID: {}", (Object)id);
            Optional optionalUser = this.userRepository.findById((Object)id);
            if (optionalUser.isPresent()) {
                return this.convert((User)optionalUser.get(), true);
            }
            throw new UserNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find user using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find user using its ID " + id, ex);
        }
    }

    @Override
    public UserEntity findBySource(String source, String sourceId, boolean loadRoles) {
        try {
            this.LOGGER.debug("Find user by source[{}] user[{}]", (Object)source, (Object)sourceId);
            Optional optionalUser = this.userRepository.findBySource(source, sourceId);
            if (optionalUser.isPresent()) {
                return this.convert((User)optionalUser.get(), loadRoles);
            }
            throw new UserNotFoundException(sourceId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find user using source[{}], user[{}]", new Object[]{source, sourceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to find user using source " + source + ':' + sourceId, ex);
        }
    }

    @Override
    public Set<UserEntity> findByIds(List<String> ids) {
        try {
            this.LOGGER.debug("Find users by ID: {}", ids);
            Set users = this.userRepository.findByIds(ids);
            if (!users.isEmpty()) {
                return users.stream().map(u -> this.convert((User)u, false)).collect(Collectors.toSet());
            }
            Optional idsAsString = ids.stream().reduce((a, b) -> a + '/' + b);
            if (idsAsString.isPresent()) {
                throw new UserNotFoundException((String)idsAsString.get());
            }
            throw new UserNotFoundException("?");
        }
        catch (TechnicalException ex) {
            Optional idsAsString = ids.stream().reduce((a, b) -> a + '/' + b);
            this.LOGGER.error("An error occurs while trying to find users using their ID {}", idsAsString, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find users using their ID " + idsAsString, ex);
        }
    }

    private void checkUserRegistrationEnabled() {
        if (!this.parameterService.findAsBoolean(Key.PORTAL_USERCREATION_ENABLED)) {
            throw new IllegalStateException("The user registration is disabled");
        }
    }

    @Override
    public UserEntity finalizeRegistration(RegisterUserEntity registerUserEntity) {
        try {
            User user;
            String jwtSecret = this.environment.getProperty("jwt.secret");
            if (jwtSecret == null || jwtSecret.isEmpty()) {
                throw new IllegalStateException("JWT secret is mandatory");
            }
            Map claims = new JWTVerifier(jwtSecret).verify(registerUserEntity.getToken());
            String action = claims.get("action").toString();
            if (JWTHelper.ACTION.USER_REGISTRATION.name().equals(action)) {
                this.checkUserRegistrationEnabled();
            } else if (JWTHelper.ACTION.GROUP_INVITATION.name().equals(action)) {
                String email = claims.get("email").toString();
                List<InvitationEntity> invitations = this.invitationService.findAll();
                List userInvitations = invitations.stream().filter(invitation -> invitation.getEmail().equals(email)).collect(Collectors.toList());
                if (userInvitations.isEmpty()) {
                    throw new IllegalStateException("Invitation has been canceled");
                }
            }
            Object subject = claims.get("sub");
            if (subject == null) {
                NewExternalUserEntity externalUser = new NewExternalUserEntity();
                String email = claims.get("email").toString();
                externalUser.setSource(IDP_SOURCE_GRAVITEE);
                externalUser.setSourceId(email);
                externalUser.setFirstname(registerUserEntity.getFirstname());
                externalUser.setLastname(registerUserEntity.getLastname());
                externalUser.setEmail(email);
                user = this.convert(this.create(externalUser, true));
            } else {
                String username = subject.toString();
                this.LOGGER.debug("Create an internal user {}", (Object)username);
                Optional checkUser = this.userRepository.findById((Object)username);
                user = (User)checkUser.orElseThrow(() -> new UserNotFoundException(username));
                if (StringUtils.isNotBlank((CharSequence)user.getPassword())) {
                    throw new UserAlreadyExistsException(IDP_SOURCE_GRAVITEE, username);
                }
            }
            if (JWTHelper.ACTION.GROUP_INVITATION.name().equals(action)) {
                String email = user.getEmail();
                String userId = user.getId();
                List<InvitationEntity> invitations = this.invitationService.findAll();
                invitations.stream().filter(invitation -> invitation.getEmail().equals(email)).forEach(invitation -> {
                    this.invitationService.addMember(invitation.getReferenceType().name(), invitation.getReferenceId(), userId, invitation.getApiRole(), invitation.getApplicationRole());
                    this.invitationService.delete(invitation.getId(), invitation.getReferenceId());
                });
            }
            user.setUpdatedAt(new Date());
            if (registerUserEntity.getPassword() != null) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)registerUserEntity.getPassword()));
            }
            user = (User)this.userRepository.update((Object)user);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.USER_CREATED, user.getUpdatedAt(), null, user);
            UserEntity userEntity = this.convert(user, true);
            this.searchEngineService.index((Indexable)userEntity);
            return userEntity;
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to create an internal user with the token {}", (Object)registerUserEntity.getToken(), (Object)ex);
            throw new TechnicalManagementException(ex.getMessage(), ex);
        }
    }

    @Override
    public PictureEntity getPicture(String id) {
        UserEntity user = this.findById(id);
        if (user.getPicture() != null) {
            String picture = user.getPicture();
            if (picture.matches("^(http|https)://.*$")) {
                return new UrlPictureEntity(picture);
            }
            try {
                InlinePictureEntity imageEntity = new InlinePictureEntity();
                String[] parts = picture.split(";", 2);
                imageEntity.setType(parts[0].split(":")[1]);
                String base64Content = picture.split(",", 2)[1];
                imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
                return imageEntity;
            }
            catch (Exception ex) {
                this.LOGGER.warn("Unable to get user picture for id[{}]", (Object)id);
            }
        }
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        imageEntity.setType("image/png");
        try {
            imageEntity.setContent(IOUtils.toByteArray((InputStream)new FileInputStream(this.defaultAvatar)));
        }
        catch (IOException ioe) {
            this.LOGGER.error("Default icon for API does not exist", (Throwable)ioe);
        }
        return imageEntity;
    }

    @Override
    public UserEntity create(NewExternalUserEntity newExternalUserEntity, boolean addDefaultRole) {
        try {
            this.LOGGER.debug("Create an external user {}", (Object)newExternalUserEntity);
            Optional checkUser = this.userRepository.findBySource(newExternalUserEntity.getSource(), newExternalUserEntity.getSourceId());
            if (checkUser.isPresent()) {
                throw new UserAlreadyExistsException(newExternalUserEntity.getSource(), newExternalUserEntity.getSourceId());
            }
            User user = this.convert(newExternalUserEntity);
            user.setId(UUID.toString((java.util.UUID)UUID.random()));
            user.setStatus(UserStatus.ACTIVE);
            user.setCreatedAt(new Date());
            user.setUpdatedAt(user.getCreatedAt());
            User createdUser = (User)this.userRepository.create((Object)user);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.USER_CREATED, user.getCreatedAt(), null, user);
            if (addDefaultRole) {
                this.addDefaultMembership(createdUser);
            }
            UserEntity userEntity = this.convert(createdUser, true);
            this.searchEngineService.index((Indexable)userEntity);
            return userEntity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create an external user {}", (Object)newExternalUserEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create an external user" + newExternalUserEntity, ex);
        }
    }

    private void addDefaultMembership(User user) {
        RoleScope[] scopes = new RoleScope[]{RoleScope.MANAGEMENT, RoleScope.PORTAL};
        List<RoleEntity> defaultRoleByScopes = this.roleService.findDefaultRoleByScopes(scopes);
        if (defaultRoleByScopes == null || defaultRoleByScopes.isEmpty()) {
            throw new DefaultRoleNotFoundException(scopes);
        }
        for (RoleEntity defaultRoleByScope : defaultRoleByScopes) {
            switch (defaultRoleByScope.getScope()) {
                case MANAGEMENT: {
                    this.membershipService.addOrUpdateMember(new MembershipService.MembershipReference(MembershipReferenceType.MANAGEMENT, MembershipDefaultReferenceId.DEFAULT.name()), new MembershipService.MembershipUser(user.getId(), null), new MembershipService.MembershipRole(RoleScope.MANAGEMENT, defaultRoleByScope.getName()));
                    break;
                }
                case PORTAL: {
                    this.membershipService.addOrUpdateMember(new MembershipService.MembershipReference(MembershipReferenceType.PORTAL, MembershipDefaultReferenceId.DEFAULT.name()), new MembershipService.MembershipUser(user.getId(), null), new MembershipService.MembershipRole(RoleScope.PORTAL, defaultRoleByScope.getName()));
                    break;
                }
            }
        }
    }

    @Override
    public UserEntity register(NewExternalUserEntity newExternalUserEntity) {
        this.checkUserRegistrationEnabled();
        return this.createAndSendEmail(newExternalUserEntity, JWTHelper.ACTION.USER_REGISTRATION);
    }

    @Override
    public UserEntity create(NewExternalUserEntity newExternalUserEntity) {
        return this.createAndSendEmail(newExternalUserEntity, JWTHelper.ACTION.USER_CREATION);
    }

    private UserEntity createAndSendEmail(NewExternalUserEntity newExternalUserEntity, JWTHelper.ACTION action) {
        try {
            new InternetAddress(newExternalUserEntity.getEmail()).validate();
        }
        catch (AddressException ex) {
            throw new EmailFormatInvalidException(newExternalUserEntity.getEmail());
        }
        try {
            Optional optionalUser = this.userRepository.findBySource(IDP_SOURCE_GRAVITEE, newExternalUserEntity.getEmail());
            if (optionalUser.isPresent()) {
                throw new UserAlreadyExistsException(IDP_SOURCE_GRAVITEE, newExternalUserEntity.getEmail());
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to create user {}", (Object)newExternalUserEntity.getEmail(), (Object)e);
            throw new TechnicalManagementException(e.getMessage(), e);
        }
        newExternalUserEntity.setSource(IDP_SOURCE_GRAVITEE);
        newExternalUserEntity.setSourceId(newExternalUserEntity.getEmail());
        UserEntity userEntity = this.create(newExternalUserEntity, true);
        Map<String, Object> params = this.getTokenRegistrationParams(userEntity, "/#!/registration/confirm/", action);
        this.notifierService.trigger(JWTHelper.ACTION.USER_REGISTRATION.equals((Object)action) ? PortalHook.USER_REGISTERED : PortalHook.USER_CREATED, params);
        this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(userEntity.getEmail()).subject(String.format("User %s - %s", JWTHelper.ACTION.USER_REGISTRATION.equals((Object)action) ? "registration" : "creation", userEntity.getDisplayName())).template(EmailNotificationBuilder.EmailTemplate.USER_REGISTRATION).params(params).build());
        return userEntity;
    }

    @Override
    public Map<String, Object> getTokenRegistrationParams(UserEntity userEntity, String portalUri, JWTHelper.ACTION action) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("iss", this.environment.getProperty("jwt.issuer", "gravitee-management-auth"));
        claims.put("sub", userEntity.getId());
        claims.put("email", userEntity.getEmail());
        claims.put("firstname", userEntity.getFirstname());
        claims.put("lastname", userEntity.getLastname());
        claims.put("action", (Object)action);
        JWTSigner.Options options = new JWTSigner.Options();
        options.setExpirySeconds((Integer)this.environment.getProperty("user.creation.token.expire-after", Integer.class, (Object)86400));
        options.setIssuedAt(true);
        options.setJwtId(true);
        String jwtSecret = this.environment.getProperty("jwt.secret");
        if (jwtSecret == null || jwtSecret.isEmpty()) {
            throw new IllegalStateException("JWT secret is mandatory");
        }
        String token = new JWTSigner(jwtSecret).sign(claims, options);
        String portalUrl = this.environment.getProperty("portalURL");
        if (portalUrl != null && portalUrl.endsWith("/")) {
            portalUrl = portalUrl.substring(0, portalUrl.length() - 1);
        }
        String registrationUrl = portalUrl + portalUri + token;
        return new NotificationParamsBuilder().user(userEntity).token(token).registrationUrl(registrationUrl).build();
    }

    @Override
    public UserEntity update(String id, UpdateUserEntity updateUserEntity) {
        try {
            this.LOGGER.debug("Updating {}", (Object)updateUserEntity);
            Optional checkUser = this.userRepository.findById((Object)id);
            if (!checkUser.isPresent()) {
                throw new UserNotFoundException(id);
            }
            User user = (User)checkUser.get();
            User previousUser = new User(user);
            user.setUpdatedAt(new Date());
            if (updateUserEntity.getPicture() != null) {
                user.setPicture(updateUserEntity.getPicture());
            }
            if (updateUserEntity.getFirstname() != null) {
                user.setFirstname(updateUserEntity.getFirstname());
            }
            if (updateUserEntity.getLastname() != null) {
                user.setLastname(updateUserEntity.getLastname());
            }
            if (updateUserEntity.getEmail() != null) {
                user.setEmail(updateUserEntity.getEmail());
            }
            if (updateUserEntity.getStatus() != null) {
                user.setStatus(UserStatus.valueOf((String)updateUserEntity.getStatus()));
            }
            User updatedUser = (User)this.userRepository.update((Object)user);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.USER_UPDATED, user.getUpdatedAt(), previousUser, user);
            return this.convert(updatedUser, true);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update {}", (Object)updateUserEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying update " + updateUserEntity, ex);
        }
    }

    @Override
    public Page<UserEntity> search(String query, Pageable pageable) {
        this.LOGGER.debug("search users");
        if (query == null || query.isEmpty()) {
            return this.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ACTIVE}).build(), pageable);
        }
        Query<UserEntity> userQuery = QueryBuilder.create(UserEntity.class).setQuery(query).setPage(pageable).build();
        SearchResult results = this.searchEngineService.search(userQuery);
        if (results.hasResults()) {
            ArrayList<UserEntity> users = new ArrayList<UserEntity>(this.findByIds(results.getDocuments()));
            return new Page(users, pageable.getPageNumber(), pageable.getPageSize(), results.getHits());
        }
        return new Page(Collections.emptyList(), 1, 0, 0L);
    }

    @Override
    public Page<UserEntity> search(UserCriteria criteria, Pageable pageable) {
        try {
            this.LOGGER.debug("search users");
            Page users = this.userRepository.search(criteria, new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build());
            List entities = users.getContent().stream().map(u -> this.convert((User)u, false)).collect(Collectors.toList());
            return new Page(entities, users.getPageNumber() + 1, (int)users.getPageElements(), users.getTotalElements());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to search users", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search users", ex);
        }
    }

    @Override
    public void delete(String id) {
        try {
            long apiCount = this.apiService.findByUser(id, null).stream().filter(entity -> entity.getPrimaryOwner().getId().equals(id)).count();
            long applicationCount = this.applicationService.findByUser(id).stream().filter(app -> app.getPrimaryOwner() != null).filter(app -> app.getPrimaryOwner().getId().equals(id)).count();
            if (apiCount > 0L || applicationCount > 0L) {
                throw new StillPrimaryOwnerException(apiCount, applicationCount);
            }
            Optional optionalUser = this.userRepository.findById((Object)id);
            if (!optionalUser.isPresent()) {
                throw new UserNotFoundException(id);
            }
            this.membershipService.removeUser(id);
            User user = (User)optionalUser.get();
            user.setSourceId("deleted-" + user.getSourceId());
            user.setStatus(UserStatus.ARCHIVED);
            user.setUpdatedAt(new Date());
            if (this.anonymizeOnDelete) {
                user.setFirstname("Unknown");
                user.setLastname("");
                user.setEmail("");
            }
            this.userRepository.update((Object)user);
            UserEntity userEntity = this.convert((User)optionalUser.get(), false);
            this.searchEngineService.delete((Indexable)userEntity);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete user", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete user", ex);
        }
    }

    @Override
    public void resetPassword(String id) {
        try {
            this.LOGGER.debug("Resetting password of user id {}", (Object)id);
            Optional optionalUser = this.userRepository.findById((Object)id);
            if (!optionalUser.isPresent()) {
                throw new UserNotFoundException(id);
            }
            User user = (User)optionalUser.get();
            if (!IDP_SOURCE_GRAVITEE.equals(user.getSource())) {
                throw new UserNotInternallyManagedException(id);
            }
            user.setPassword(null);
            user.setUpdatedAt(new Date());
            this.userRepository.update((Object)user);
            Map<String, Object> params = this.getTokenRegistrationParams(this.convert(user, false), "/#!/resetPassword/", JWTHelper.ACTION.RESET_PASSWORD);
            this.notifierService.trigger(PortalHook.PASSWORD_RESET, params);
            this.auditService.createPortalAuditLog(Collections.singletonMap(Audit.AuditProperties.USER, user.getId()), (Audit.AuditEvent)User.AuditEvent.PASSWORD_RESET, user.getUpdatedAt(), null, null);
            this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(user.getEmail()).subject("Password reset - " + this.convert(user, false).getDisplayName()).template(EmailNotificationBuilder.EmailTemplate.PASSWORD_RESET).params(params).build());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to reset password for user " + id;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private User convert(NewExternalUserEntity newExternalUserEntity) {
        if (newExternalUserEntity == null) {
            return null;
        }
        User user = new User();
        user.setEmail(newExternalUserEntity.getEmail());
        user.setFirstname(newExternalUserEntity.getFirstname());
        user.setLastname(newExternalUserEntity.getLastname());
        user.setSource(newExternalUserEntity.getSource());
        user.setSourceId(newExternalUserEntity.getSourceId());
        user.setStatus(UserStatus.ACTIVE);
        return user;
    }

    private User convert(UserEntity userEntity) {
        if (userEntity == null) {
            return null;
        }
        User user = new User();
        user.setId(userEntity.getId());
        user.setEmail(userEntity.getEmail());
        user.setFirstname(userEntity.getFirstname());
        user.setLastname(userEntity.getLastname());
        user.setSource(userEntity.getSource());
        user.setSourceId(userEntity.getSourceId());
        if (userEntity.getStatus() != null) {
            user.setStatus(UserStatus.valueOf((String)userEntity.getStatus()));
        }
        return user;
    }

    private UserEntity convert(User user, boolean loadRoles) {
        if (user == null) {
            return null;
        }
        UserEntity userEntity = new UserEntity();
        userEntity.setId(user.getId());
        userEntity.setSource(user.getSource());
        userEntity.setSourceId(user.getSourceId());
        userEntity.setEmail(user.getEmail());
        userEntity.setFirstname(user.getFirstname());
        userEntity.setLastname(user.getLastname());
        userEntity.setPassword(user.getPassword());
        userEntity.setCreatedAt(user.getCreatedAt());
        userEntity.setUpdatedAt(user.getUpdatedAt());
        userEntity.setLastConnectionAt(user.getLastConnectionAt());
        userEntity.setPicture(user.getPicture());
        if (user.getStatus() != null) {
            userEntity.setStatus(user.getStatus().name());
        }
        if (loadRoles) {
            HashSet<UserRoleEntity> roles = new HashSet<UserRoleEntity>();
            RoleEntity roleEntity = this.membershipService.getRole(MembershipReferenceType.PORTAL, MembershipDefaultReferenceId.DEFAULT.name(), user.getId(), RoleScope.PORTAL);
            if (roleEntity != null) {
                roles.add(this.convert(roleEntity));
            }
            if ((roleEntity = this.membershipService.getRole(MembershipReferenceType.MANAGEMENT, MembershipDefaultReferenceId.DEFAULT.name(), user.getId(), RoleScope.MANAGEMENT)) != null) {
                roles.add(this.convert(roleEntity));
            }
            userEntity.setRoles(roles);
        }
        return userEntity;
    }

    private UserRoleEntity convert(RoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        UserRoleEntity userRoleEntity = new UserRoleEntity();
        userRoleEntity.setScope(roleEntity.getScope());
        userRoleEntity.setName(roleEntity.getName());
        userRoleEntity.setPermissions(roleEntity.getPermissions());
        return userRoleEntity;
    }
}

