/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApiModelEntity;
import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.MetadataEntity;
import io.gravitee.management.model.NewTicketEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.MetadataService;
import io.gravitee.management.service.NotifierService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.TicketService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.builder.EmailNotificationBuilder;
import io.gravitee.management.service.exceptions.EmailRequiredException;
import io.gravitee.management.service.exceptions.SupportUnavailableException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.management.service.notification.ApiHook;
import io.gravitee.management.service.notification.ApplicationHook;
import io.gravitee.management.service.notification.NotificationParamsBuilder;
import io.gravitee.management.service.notification.PortalHook;
import java.util.HashMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TicketServiceImpl
extends TransactionalService
implements TicketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketServiceImpl.class);
    @Inject
    private UserService userService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private ApiService apiService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private EmailService emailService;
    @Inject
    private ParameterService parameterService;
    @Inject
    private NotifierService notifierService;

    private boolean isEnabled() {
        return this.parameterService.findAsBoolean(Key.PORTAL_SUPPORT_ENABLED);
    }

    @Override
    public void create(String userId, NewTicketEntity ticketEntity) {
        ApplicationEntity applicationEntity;
        String emailTo;
        ApiModelEntity api;
        if (!this.isEnabled()) {
            throw new SupportUnavailableException();
        }
        LOGGER.info("Creating a support ticket: {}", (Object)ticketEntity);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        UserEntity user = this.userService.findById(userId);
        if (user.getEmail() == null) {
            throw new EmailRequiredException(userId);
        }
        parameters.put("user", user);
        if (ticketEntity.getApi() == null) {
            api = null;
            MetadataEntity emailMetadata = this.metadataService.findDefaultByKey("email-support");
            if (emailMetadata == null) {
                throw new IllegalStateException("The support email metadata has not been found");
            }
            emailTo = emailMetadata.getValue();
        } else {
            api = this.apiService.findByIdForTemplates(ticketEntity.getApi());
            String apiMetadataEmailSupport = (String)api.getMetadata().get("email-support");
            if (apiMetadataEmailSupport == null) {
                throw new IllegalStateException("The support email API metadata has not been found");
            }
            emailTo = apiMetadataEmailSupport;
            parameters.put("api", api);
        }
        if ("support@change.me".equals(emailTo)) {
            throw new IllegalStateException("The support email API metadata has not been changed");
        }
        if (ticketEntity.getApplication() != null) {
            applicationEntity = this.applicationService.findById(ticketEntity.getApplication());
            parameters.put("application", applicationEntity);
        } else {
            applicationEntity = null;
        }
        parameters.put("content", ticketEntity.getContent().replaceAll("(\r\n|\n)", "<br />"));
        String fromName = user.getFirstname() == null ? user.getEmail() : user.getFirstname() + ' ' + user.getLastname();
        this.emailService.sendEmailNotification(new EmailNotificationBuilder().from(user.getEmail()).fromName(fromName).to(emailTo).subject(ticketEntity.getSubject()).copyToSender(ticketEntity.isCopyToSender()).template(EmailNotificationBuilder.EmailTemplate.SUPPORT_TICKET).params(parameters).build());
        this.sendUserNotification(user, api, applicationEntity);
    }

    private void sendUserNotification(UserEntity user, ApiModelEntity api, ApplicationEntity application) {
        this.notifierService.trigger(PortalHook.NEW_SUPPORT_TICKET, new NotificationParamsBuilder().user(user).api(api).application(application).build());
        if (api != null) {
            this.notifierService.trigger(ApiHook.NEW_SUPPORT_TICKET, api.getId(), new NotificationParamsBuilder().user(user).api(api).application(application).build());
        }
        if (application != null) {
            this.notifierService.trigger(ApplicationHook.NEW_SUPPORT_TICKET, application.getId(), new NotificationParamsBuilder().user(user).api(api).application(application).build());
        }
    }
}

