/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.management.model.ImportSwaggerDescriptorEntity;
import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.api.NewSwaggerApiEntity;
import io.gravitee.management.model.api.SwaggerPath;
import io.gravitee.management.model.api.SwaggerVerb;
import io.gravitee.management.service.SwaggerService;
import io.gravitee.management.service.exceptions.SwaggerDescriptorException;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.parser.SwaggerCompatConverter;
import io.swagger.parser.SwaggerParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SwaggerServiceImpl
implements SwaggerService {
    private final Logger logger = LoggerFactory.getLogger(SwaggerServiceImpl.class);
    @Value(value="${swagger.scheme:https}")
    private String defaultScheme;
    @Inject
    private ObjectMapper mapper;

    @Override
    public NewSwaggerApiEntity prepare(ImportSwaggerDescriptorEntity swaggerDescriptor) {
        NewSwaggerApiEntity apiEntity = this.prepareV2(swaggerDescriptor);
        if (apiEntity == null) {
            apiEntity = this.prepareV3(swaggerDescriptor);
        }
        if (apiEntity == null) {
            apiEntity = this.prepareV1(swaggerDescriptor);
        }
        if (apiEntity == null) {
            throw new SwaggerDescriptorException();
        }
        return apiEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NewSwaggerApiEntity prepareV1(ImportSwaggerDescriptorEntity swaggerDescriptor) {
        NewSwaggerApiEntity apiEntity;
        block7: {
            try {
                this.logger.info("Loading an old Swagger descriptor from {}", (Object)swaggerDescriptor.getPayload());
                if (swaggerDescriptor.getType() == ImportSwaggerDescriptorEntity.Type.INLINE) {
                    File temp = null;
                    try {
                        temp = this.createTmpSwagger1File(swaggerDescriptor.getPayload());
                        apiEntity = this.mapSwagger12ToNewApi(new SwaggerCompatConverter().read(temp.getAbsolutePath()), swaggerDescriptor.isWithPolicyMocks());
                        break block7;
                    }
                    finally {
                        if (temp != null) {
                            temp.delete();
                        }
                    }
                }
                apiEntity = this.mapSwagger12ToNewApi(new SwaggerCompatConverter().read(swaggerDescriptor.getPayload()), swaggerDescriptor.isWithPolicyMocks());
            }
            catch (IOException ioe) {
                this.logger.error("Can not read old Swagger specification", (Throwable)ioe);
                throw new SwaggerDescriptorException();
            }
        }
        return apiEntity;
    }

    private NewSwaggerApiEntity prepareV2(ImportSwaggerDescriptorEntity swaggerDescriptor) {
        this.logger.info("Trying to loading a Swagger descriptor in v2");
        NewSwaggerApiEntity apiEntity = swaggerDescriptor.getType() == ImportSwaggerDescriptorEntity.Type.INLINE ? this.mapSwagger12ToNewApi(new SwaggerParser().parse(swaggerDescriptor.getPayload()), swaggerDescriptor.isWithPolicyMocks()) : this.mapSwagger12ToNewApi(new SwaggerParser().read(swaggerDescriptor.getPayload()), swaggerDescriptor.isWithPolicyMocks());
        return apiEntity;
    }

    private NewSwaggerApiEntity prepareV3(ImportSwaggerDescriptorEntity swaggerDescriptor) {
        this.logger.info("Trying to loading an OpenAPI descriptor");
        NewSwaggerApiEntity apiEntity = swaggerDescriptor.getType() == ImportSwaggerDescriptorEntity.Type.INLINE ? this.mapOpenApiToNewApi(new OpenAPIV3Parser().readContents(swaggerDescriptor.getPayload()), swaggerDescriptor.isWithPolicyMocks()) : this.mapOpenApiToNewApi(new OpenAPIV3Parser().readWithInfo(swaggerDescriptor.getPayload(), (List)null), swaggerDescriptor.isWithPolicyMocks());
        return apiEntity;
    }

    @Override
    public void transform(PageEntity page) {
        if (page.getContent() != null && page.getConfiguration() != null && page.getConfiguration().get("tryItURL") != null && !((String)page.getConfiguration().get("tryItURL")).isEmpty()) {
            Swagger swagger = this.transformV2(page.getContent(), page.getConfiguration());
            if (swagger == null) {
                swagger = this.transformV1(page.getContent(), page.getConfiguration());
            }
            if (swagger == null) {
                swagger = this.transformV3(page.getContent(), page.getConfiguration());
            }
            if (swagger == null) {
                throw new SwaggerDescriptorException();
            }
            if (page.getContentType().equalsIgnoreCase("application/json")) {
                try {
                    page.setContent(Json.pretty().writeValueAsString((Object)swagger));
                }
                catch (JsonProcessingException e) {
                    this.logger.error("Unexpected error", (Throwable)e);
                }
            } else {
                try {
                    page.setContent(Yaml.pretty().writeValueAsString((Object)swagger));
                }
                catch (JsonProcessingException e) {
                    this.logger.error("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTmpSwagger1File(String content) {
        File temp = null;
        String fileName = "gio_swagger_" + System.currentTimeMillis();
        BufferedWriter bw = null;
        FileWriter out = null;
        Object swagger = null;
        try {
            temp = File.createTempFile(fileName, ".tmp");
            out = new FileWriter(temp);
            bw = new BufferedWriter(out);
            bw.write(content);
            bw.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Swagger transformV1(String content, Map<String, String> config) {
        File temp = null;
        Swagger swagger = null;
        try {
            temp = this.createTmpSwagger1File(content);
            swagger = new SwaggerCompatConverter().read(temp.getAbsolutePath());
            if (swagger != null && config != null && config.get("tryItURL") != null) {
                URI newURI = URI.create(config.get("tryItURL"));
                swagger.setSchemes(Collections.singletonList(Scheme.forValue((String)newURI.getScheme())));
                swagger.setHost(newURI.getPort() != -1 ? newURI.getHost() + ':' + newURI.getPort() : newURI.getHost());
                swagger.setBasePath(newURI.getRawPath().isEmpty() ? "/" : newURI.getRawPath());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
        return swagger;
    }

    private Swagger transformV2(String content, Map<String, String> config) {
        Swagger swagger = new SwaggerParser().parse(content);
        if (swagger != null && config != null && config.get("tryItURL") != null) {
            URI newURI = URI.create(config.get("tryItURL"));
            swagger.setSchemes(Collections.singletonList(Scheme.forValue((String)newURI.getScheme())));
            swagger.setHost(newURI.getPort() != -1 ? newURI.getHost() + ':' + newURI.getPort() : newURI.getHost());
            swagger.setBasePath(newURI.getRawPath().isEmpty() ? "/" : newURI.getRawPath());
        }
        return swagger;
    }

    private OpenAPI transformV3(String content, Map<String, String> config) {
        SwaggerParseResult result = new OpenAPIV3Parser().readContents(content, null, null);
        if (result != null && config != null && config.get("tryItURL") != null) {
            URI newURI = URI.create(config.get("tryItURL"));
            result.getOpenAPI().getServers().forEach(server -> {
                try {
                    server.setUrl(new URI(newURI.getScheme(), newURI.getUserInfo(), newURI.getHost(), newURI.getPort(), newURI.getPath(), newURI.getQuery(), newURI.getFragment()).toString());
                }
                catch (URISyntaxException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        if (result != null) {
            return result.getOpenAPI();
        }
        return null;
    }

    private NewSwaggerApiEntity mapSwagger12ToNewApi(Swagger swagger, boolean isWithPolicyMocks) {
        if (swagger == null || swagger.getInfo() == null) {
            return null;
        }
        NewSwaggerApiEntity apiEntity = new NewSwaggerApiEntity();
        apiEntity.setName(swagger.getInfo().getTitle());
        if (swagger.getBasePath() != null && !swagger.getBasePath().isEmpty()) {
            apiEntity.setContextPath(swagger.getBasePath());
        } else {
            apiEntity.setContextPath(apiEntity.getName().replaceAll("\\s+", "").toLowerCase());
        }
        apiEntity.setDescription(swagger.getInfo().getDescription() == null ? "Description of " + apiEntity.getName() : swagger.getInfo().getDescription());
        apiEntity.setVersion(swagger.getInfo().getVersion());
        String scheme = swagger.getSchemes() == null || swagger.getSchemes().isEmpty() ? this.defaultScheme : ((Scheme)swagger.getSchemes().iterator().next()).toValue();
        apiEntity.setEndpoint(scheme + "://" + swagger.getHost() + swagger.getBasePath());
        apiEntity.setPaths((List)swagger.getPaths().entrySet().stream().map(entry -> {
            SwaggerPath swaggerPath = new SwaggerPath();
            swaggerPath.setPath(((String)entry.getKey()).replaceAll("\\{(.[^/]*)\\}", ":$1"));
            if (isWithPolicyMocks) {
                ArrayList verbs = new ArrayList();
                ((Path)entry.getValue()).getOperationMap().forEach((key, operation) -> {
                    SwaggerVerb swaggerVerb = new SwaggerVerb();
                    swaggerVerb.setVerb(key.name());
                    swaggerVerb.setDescription(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary());
                    Map.Entry responseEntry = operation.getResponses().entrySet().iterator().next();
                    swaggerVerb.setResponseStatus((String)responseEntry.getKey());
                    Model responseSchema = ((Response)responseEntry.getValue()).getResponseSchema();
                    if (responseSchema != null) {
                        if (responseSchema instanceof ArrayModel) {
                            ArrayModel arrayModel = (ArrayModel)responseSchema;
                            swaggerVerb.setResponseType(arrayModel.getType());
                            if (arrayModel.getItems() instanceof RefProperty) {
                                String simpleRef = ((RefProperty)arrayModel.getItems()).getSimpleRef();
                                swaggerVerb.setResponseProperties(this.getResponseFromSimpleRef(swagger, simpleRef));
                            } else if (arrayModel.getItems() instanceof ObjectProperty) {
                                swaggerVerb.setResponseProperties(this.getResponseProperties(swagger, ((ObjectProperty)arrayModel.getItems()).getProperties()));
                            }
                        } else if (responseSchema instanceof RefModel) {
                            swaggerVerb.setResponseType("object");
                            String simpleRef = ((RefModel)responseSchema).getSimpleRef();
                            swaggerVerb.setResponseProperties(this.getResponseFromSimpleRef(swagger, simpleRef));
                        } else if (responseSchema instanceof ModelImpl) {
                            ModelImpl model = (ModelImpl)responseSchema;
                            swaggerVerb.setResponseType(model.getType());
                            if ("object".equals(model.getType())) {
                                if (model.getAdditionalProperties() != null) {
                                    swaggerVerb.setResponseProperties(Collections.singletonMap("additionalProperty", model.getAdditionalProperties().getType()));
                                }
                            } else {
                                swaggerVerb.setResponseType(model.getType());
                            }
                        }
                    }
                    verbs.add(swaggerVerb);
                });
                swaggerPath.setVerbs(verbs);
            }
            return swaggerPath;
        }).collect(Collectors.toCollection(ArrayList::new)));
        return apiEntity;
    }

    private Map<String, Object> getResponseFromSimpleRef(Swagger swagger, String simpleRef) {
        Map properties = ((Model)swagger.getDefinitions().get(simpleRef)).getProperties();
        if (properties == null) {
            return Collections.emptyMap();
        }
        return this.getResponseProperties(swagger, properties);
    }

    private Map<String, Object> getResponseProperties(Swagger swagger, Map<String, Property> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Property property = (Property)e.getValue();
            if (property instanceof RefProperty) {
                return this.getResponseFromSimpleRef(swagger, ((RefProperty)property).getSimpleRef());
            }
            return property.getType();
        }));
    }

    private NewSwaggerApiEntity mapOpenApiToNewApi(SwaggerParseResult swagger, boolean isWithPolicyMocks) {
        if (swagger == null || swagger.getOpenAPI() == null || swagger.getOpenAPI().getInfo() == null) {
            return null;
        }
        NewSwaggerApiEntity apiEntity = new NewSwaggerApiEntity();
        apiEntity.setName(swagger.getOpenAPI().getInfo().getTitle());
        String contextPath = null;
        if (!swagger.getOpenAPI().getServers().isEmpty()) {
            contextPath = ((Server)swagger.getOpenAPI().getServers().get(0)).getUrl();
            contextPath = URI.create(contextPath.replace("{scheme}", "http")).getPath();
        }
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = apiEntity.getName().replaceAll("\\s+", "").toLowerCase();
        }
        apiEntity.setContextPath(contextPath);
        apiEntity.setDescription(swagger.getOpenAPI().getInfo().getDescription() == null ? "Description of " + apiEntity.getName() : swagger.getOpenAPI().getInfo().getDescription());
        apiEntity.setVersion(swagger.getOpenAPI().getInfo().getVersion());
        if (!swagger.getOpenAPI().getServers().isEmpty()) {
            apiEntity.setEndpoint(((Server)swagger.getOpenAPI().getServers().get(0)).getUrl());
        }
        apiEntity.setPaths((List)swagger.getOpenAPI().getPaths().entrySet().stream().map(entry -> {
            SwaggerPath swaggerPath = new SwaggerPath();
            swaggerPath.setPath(((String)entry.getKey()).replaceAll("\\{(.[^/]*)\\}", ":$1"));
            if (isWithPolicyMocks) {
                ArrayList<SwaggerVerb> verbs = new ArrayList<SwaggerVerb>();
                PathItem pathItem = (PathItem)entry.getValue();
                if (pathItem.getGet() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getGet(), "GET"));
                }
                if (pathItem.getPut() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getPut(), "PUT"));
                }
                if (pathItem.getPost() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getPost(), "POST"));
                }
                if (pathItem.getDelete() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getDelete(), "DELETE"));
                }
                if (pathItem.getPatch() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getPatch(), "PATCH"));
                }
                if (pathItem.getHead() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getHead(), "HEAD"));
                }
                if (pathItem.getOptions() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getOptions(), "OPTIONS"));
                }
                if (pathItem.getTrace() != null) {
                    verbs.add(this.getSwaggerVerb(swagger, pathItem.getTrace(), "TRACE"));
                }
                swaggerPath.setVerbs(verbs);
            }
            return swaggerPath;
        }).collect(Collectors.toCollection(ArrayList::new)));
        return apiEntity;
    }

    private SwaggerVerb getSwaggerVerb(SwaggerParseResult swagger, Operation operation, String verb) {
        SwaggerVerb swaggerVerb = new SwaggerVerb();
        swaggerVerb.setVerb(verb);
        swaggerVerb.setDescription(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary());
        Map.Entry responseEntry = (Map.Entry)operation.getResponses().entrySet().iterator().next();
        swaggerVerb.setResponseStatus((String)responseEntry.getKey());
        if (((ApiResponse)responseEntry.getValue()).getContent() != null) {
            MediaType mediaType = (MediaType)((Map.Entry)((ApiResponse)responseEntry.getValue()).getContent().entrySet().iterator().next()).getValue();
            if (mediaType.getExample() != null) {
                swaggerVerb.setResponseExample(this.mapper.convertValue(mediaType.getExample(), Map.class));
            } else if (mediaType.getExamples() != null) {
                swaggerVerb.setResponseExample(((Example)mediaType.getExamples().entrySet().iterator().next().getValue()).getValue());
            } else {
                Schema responseSchema = mediaType.getSchema();
                if (responseSchema != null) {
                    if (responseSchema instanceof ArraySchema) {
                        ArraySchema arraySchema = (ArraySchema)responseSchema;
                        this.processResponseSchema(swagger, swaggerVerb, "array", arraySchema.getItems());
                    } else {
                        this.processResponseSchema(swagger, swaggerVerb, responseSchema.getType() == null ? "object" : responseSchema.getType(), responseSchema);
                    }
                }
            }
        }
        return swaggerVerb;
    }

    private void processResponseSchema(SwaggerParseResult swagger, SwaggerVerb swaggerVerb, String type, Schema responseSchema) {
        if (responseSchema.getProperties() == null) {
            swaggerVerb.setResponseType(type);
            if (responseSchema.getAdditionalProperties() != null) {
                swaggerVerb.setResponseProperties(Collections.singletonMap("additionalProperty", ((ObjectSchema)responseSchema.getAdditionalProperties()).getType()));
            } else if (responseSchema.get$ref() != null) {
                String typeByRef;
                if (!"array".equals(type) && (typeByRef = this.getTypeByRef(swagger, responseSchema.get$ref())) != null) {
                    swaggerVerb.setResponseType(typeByRef);
                }
                swaggerVerb.setResponseProperties(this.getResponseFromSimpleRef(swagger, responseSchema.get$ref()));
            }
        } else {
            swaggerVerb.setResponseExample(this.getResponseExample(responseSchema.getProperties()));
        }
    }

    private String getTypeByRef(SwaggerParseResult swagger, String ref) {
        String simpleRef = ref.substring(ref.lastIndexOf(47) + 1);
        return ((Schema)swagger.getOpenAPI().getComponents().getSchemas().get(simpleRef)).getType();
    }

    private Map<String, Object> getResponseFromSimpleRef(SwaggerParseResult swagger, String ref) {
        String simpleRef = ref.substring(ref.lastIndexOf(47) + 1);
        Schema schema = (Schema)swagger.getOpenAPI().getComponents().getSchemas().get(simpleRef);
        if (schema instanceof ArraySchema) {
            return this.getResponseFromSimpleRef(swagger, ((ArraySchema)schema).getItems().get$ref());
        }
        if (schema instanceof ComposedSchema) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            ((ComposedSchema)schema).getAllOf().forEach(composedSchema -> {
                if (composedSchema.get$ref() != null) {
                    response.putAll(this.getResponseFromSimpleRef(swagger, composedSchema.get$ref()));
                }
                if (composedSchema.getProperties() != null) {
                    response.putAll(this.getResponseProperties(swagger, composedSchema.getProperties()));
                }
            });
            return response;
        }
        if (schema == null || schema.getProperties() == null) {
            return Collections.emptyMap();
        }
        return this.getResponseProperties(swagger, schema.getProperties());
    }

    private Map<String, Object> getResponseProperties(SwaggerParseResult swagger, Map<String, Schema> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (((Schema)e.getValue()).getType() != null) {
                return ((Schema)e.getValue()).getType();
            }
            return this.getResponseFromSimpleRef(swagger, ((Schema)e.getValue()).get$ref());
        }));
    }

    private Map<String, Object> getResponseExample(Map<String, Schema> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Schema)e.getValue()).getExample()));
    }

    static {
        System.setProperty(String.format("%s.trustAll", io.swagger.parser.util.RemoteUrl.class.getName()), Boolean.TRUE.toString());
        System.setProperty(String.format("%s.trustAll", RemoteUrl.class.getName()), Boolean.TRUE.toString());
    }
}

