/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.notification.NotificationConfigType;
import io.gravitee.management.model.notification.PortalNotificationConfigEntity;
import io.gravitee.management.service.PortalNotificationConfigService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalNotificationConfigServiceImpl
extends AbstractService
implements PortalNotificationConfigService {
    private final Logger LOGGER = LoggerFactory.getLogger(PortalNotificationConfigServiceImpl.class);
    @Autowired
    private PortalNotificationConfigRepository portalNotificationConfigRepository;

    @Override
    public PortalNotificationConfigEntity save(PortalNotificationConfigEntity notificationEntity) {
        try {
            if (notificationEntity.getHooks() == null || notificationEntity.getHooks().isEmpty()) {
                this.portalNotificationConfigRepository.delete(this.convert(notificationEntity));
                return this.getDefaultEmpty(notificationEntity.getUser(), NotificationReferenceType.valueOf((String)notificationEntity.getReferenceType()), notificationEntity.getReferenceId());
            }
            Optional optionalConfig = this.portalNotificationConfigRepository.findById(notificationEntity.getUser(), NotificationReferenceType.valueOf((String)notificationEntity.getReferenceType()), notificationEntity.getReferenceId());
            PortalNotificationConfig notificationConfig = this.convert(notificationEntity);
            if (optionalConfig.isPresent()) {
                notificationConfig.setCreatedAt(((PortalNotificationConfig)optionalConfig.get()).getCreatedAt());
                notificationConfig.setUpdatedAt(new Date());
                return this.convert(this.portalNotificationConfigRepository.update(notificationConfig));
            }
            notificationConfig.setCreatedAt(new Date());
            notificationConfig.setUpdatedAt(notificationConfig.getCreatedAt());
            return this.convert(this.portalNotificationConfigRepository.create(notificationConfig));
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to save the notification settings {}", (Object)notificationEntity, (Object)te);
            throw new TechnicalManagementException("An error occurs while trying to save the notification settings " + notificationEntity, te);
        }
    }

    @Override
    public PortalNotificationConfigEntity findById(String user, NotificationReferenceType referenceType, String referenceId) {
        try {
            Optional optionalConfig = this.portalNotificationConfigRepository.findById(user, referenceType, referenceId);
            if (optionalConfig.isPresent()) {
                return this.convert((PortalNotificationConfig)optionalConfig.get());
            }
            return this.getDefaultEmpty(user, referenceType, referenceId);
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to get the notification settings {}/{}/{}", new Object[]{user, referenceType, referenceId, te});
            throw new TechnicalManagementException("An error occurs while trying to get the notification settings " + user + "/" + referenceType + "/" + referenceId, te);
        }
    }

    private PortalNotificationConfigEntity getDefaultEmpty(String user, NotificationReferenceType referenceType, String referenceId) {
        PortalNotificationConfigEntity portalNotificationConfigEntity = new PortalNotificationConfigEntity();
        portalNotificationConfigEntity.setConfigType(NotificationConfigType.PORTAL);
        portalNotificationConfigEntity.setReferenceType(referenceType.name());
        portalNotificationConfigEntity.setReferenceId(referenceId);
        portalNotificationConfigEntity.setUser(user);
        portalNotificationConfigEntity.setHooks(Collections.emptyList());
        return portalNotificationConfigEntity;
    }

    private PortalNotificationConfig convert(PortalNotificationConfigEntity entity) {
        PortalNotificationConfig portalNotificationConfig = new PortalNotificationConfig();
        portalNotificationConfig.setReferenceType(NotificationReferenceType.valueOf((String)entity.getReferenceType()));
        portalNotificationConfig.setReferenceId(entity.getReferenceId());
        portalNotificationConfig.setUser(entity.getUser());
        portalNotificationConfig.setHooks(entity.getHooks());
        return portalNotificationConfig;
    }

    private PortalNotificationConfigEntity convert(PortalNotificationConfig portalNotificationConfig) {
        PortalNotificationConfigEntity entity = new PortalNotificationConfigEntity();
        entity.setConfigType(NotificationConfigType.PORTAL);
        entity.setReferenceType(portalNotificationConfig.getReferenceType().name());
        entity.setReferenceId(portalNotificationConfig.getReferenceId());
        entity.setUser(portalNotificationConfig.getUser());
        entity.setHooks(portalNotificationConfig.getHooks());
        return entity;
    }
}

