/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.PluginEntity;
import io.gravitee.management.model.PolicyDevelopmentEntity;
import io.gravitee.management.model.PolicyEntity;
import io.gravitee.management.service.PolicyService;
import io.gravitee.management.service.exceptions.PolicyNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.policy.PolicyPlugin;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyServiceImpl
extends TransactionalService
implements PolicyService {
    private final Logger LOGGER = LoggerFactory.getLogger(PolicyServiceImpl.class);
    @Autowired
    private ConfigurablePluginManager<PolicyPlugin> policyManager;

    @Override
    public Set<PolicyEntity> findAll() {
        try {
            this.LOGGER.debug("List all policies");
            Collection policyDefinitions = this.policyManager.findAll();
            return policyDefinitions.stream().map(policyDefinition -> this.convert((PolicyPlugin)policyDefinition, false)).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to list all policies", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all policies", ex);
        }
    }

    @Override
    public PolicyEntity findById(String policyId) {
        this.LOGGER.debug("Find policy by ID: {}", (Object)policyId);
        PolicyPlugin policyDefinition = (PolicyPlugin)this.policyManager.get(policyId);
        if (policyDefinition == null) {
            throw new PolicyNotFoundException(policyId);
        }
        return this.convert(policyDefinition, true);
    }

    @Override
    public String getSchema(String policyId) {
        try {
            this.LOGGER.debug("Find policy schema by ID: {}", (Object)policyId);
            return this.policyManager.getSchema(policyId);
        }
        catch (IOException ioex) {
            this.LOGGER.error("An error occurs while trying to get policy schema for policy {}", (Object)policyId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get policy schema for policy " + policyId, ioex);
        }
    }

    private PolicyEntity convert(PolicyPlugin policyPlugin, boolean withPlugin) {
        PolicyEntity entity = new PolicyEntity();
        entity.setId(policyPlugin.id());
        entity.setDescription(policyPlugin.manifest().description());
        entity.setName(policyPlugin.manifest().name());
        entity.setVersion(policyPlugin.manifest().version());
        if (withPlugin) {
            PolicyPlugin plugin = policyPlugin;
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setPlugin(plugin.clazz());
            pluginEntity.setPath(plugin.path().toString());
            pluginEntity.setType(plugin.type().toString().toLowerCase());
            pluginEntity.setDependencies(plugin.dependencies());
            entity.setPlugin(pluginEntity);
            PolicyDevelopmentEntity developmentEntity = new PolicyDevelopmentEntity();
            developmentEntity.setClassName(policyPlugin.policy().getName());
            entity.setDevelopment(developmentEntity);
        }
        return entity;
    }
}

