/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.GroupEntity;
import io.gravitee.management.model.InvitationReferenceType;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.NewExternalUserEntity;
import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.UserMembership;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.api.ApiQuery;
import io.gravitee.management.model.pagedresult.Metadata;
import io.gravitee.management.model.permissions.SystemRole;
import io.gravitee.management.model.providers.User;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.EmailNotification;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.GroupService;
import io.gravitee.management.service.IdentityService;
import io.gravitee.management.service.InvitationService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.NotifierService;
import io.gravitee.management.service.RoleService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.builder.EmailNotificationBuilder;
import io.gravitee.management.service.exceptions.AlreadyPrimaryOwnerException;
import io.gravitee.management.service.exceptions.MemberWithoutRoleException;
import io.gravitee.management.service.exceptions.NotAuthorizedMembershipException;
import io.gravitee.management.service.exceptions.SinglePrimaryOwnerException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UserNotFoundException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.notification.NotificationParamsBuilder;
import io.gravitee.management.service.notification.PortalHook;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MembershipServiceImpl
extends AbstractService
implements MembershipService {
    private final Logger LOGGER = LoggerFactory.getLogger(MembershipServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private InvitationService invitationService;

    @Override
    public Set<MemberEntity> getMembers(MembershipReferenceType referenceType, String referenceId, RoleScope roleScope) {
        return this.getMembers(referenceType, referenceId, roleScope, null);
    }

    @Override
    public Set<MemberEntity> getMembers(MembershipReferenceType referenceType, String referenceId, RoleScope roleScope, String roleName) {
        try {
            this.LOGGER.debug("Get members for {} {}", (Object)referenceType, (Object)referenceId);
            Set memberships = this.membershipRepository.findByReferenceAndRole(referenceType, referenceId, roleScope, roleName);
            return memberships.stream().map(m -> this.convert((Membership)m, roleScope)).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get members for {} {}", new Object[]{referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public MemberEntity getMember(MembershipReferenceType referenceType, String referenceId, String userId, RoleScope roleScope) {
        try {
            this.LOGGER.debug("Get membership for {} {} and user {}", new Object[]{referenceType, referenceId, userId});
            Optional optionalMembership = this.membershipRepository.findById(userId, referenceType, referenceId);
            return optionalMembership.map(m -> this.convert((Membership)m, roleScope)).orElse(null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get membership for {} {} and user", new Object[]{referenceType, referenceId, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for " + referenceType + " " + referenceId + " and user " + userId, ex);
        }
    }

    @Override
    public RoleEntity getRole(MembershipReferenceType referenceType, String referenceId, String userId, RoleScope roleScope) {
        try {
            if (referenceId == null) {
                throw new IllegalArgumentException("You must provide a referenceId !");
            }
            this.LOGGER.debug("Get role for {} {} and user {}", new Object[]{referenceType, referenceId, userId});
            Optional optionalMembership = this.membershipRepository.findById(userId, referenceType, referenceId);
            return optionalMembership.filter(m -> m.getRoles().get(roleScope.getId()) != null).map(m -> this.roleService.findById(roleScope, (String)m.getRoles().get(roleScope.getId()))).orElse(null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get membership for {} {} and user", new Object[]{referenceType, referenceId, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for " + referenceType + " " + referenceId + " and user " + userId, ex);
        }
    }

    @Override
    public Set<RoleEntity> getRoles(MembershipReferenceType referenceType, Set<String> referenceIds, String username, RoleScope roleScope) {
        try {
            if (referenceIds == null) {
                throw new IllegalArgumentException("You must provide referenceIds !");
            }
            this.LOGGER.debug("Get role for {} {} and user {}", new Object[]{referenceType, referenceIds, username});
            Set memberships = this.membershipRepository.findByIds(username, referenceType, referenceIds);
            return memberships == null ? Collections.emptySet() : memberships.stream().filter(m -> m.getRoles().get(roleScope.getId()) != null).map(m -> this.roleService.findById(roleScope, (String)m.getRoles().get(roleScope.getId()))).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get membership for {} {} and user", new Object[]{referenceType, referenceIds, username, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for " + referenceType + " " + referenceIds + " and user " + username, ex);
        }
    }

    private void assertRoleScopeAllowedForReference(MembershipService.MembershipReference reference, MembershipService.MembershipRole role) {
        RoleEntity roleEntity = this.roleService.findById(role.getScope(), role.getName());
        if (MembershipReferenceType.API.equals((Object)reference.getType()) && !io.gravitee.management.model.permissions.RoleScope.API.equals((Object)roleEntity.getScope())) {
            throw new NotAuthorizedMembershipException(role.getName());
        }
        if (MembershipReferenceType.APPLICATION.equals((Object)reference.getType()) && !io.gravitee.management.model.permissions.RoleScope.APPLICATION.equals((Object)roleEntity.getScope())) {
            throw new NotAuthorizedMembershipException(role.getName());
        }
        if (MembershipReferenceType.GROUP.equals((Object)reference.getType()) && !io.gravitee.management.model.permissions.RoleScope.APPLICATION.equals((Object)roleEntity.getScope()) && !io.gravitee.management.model.permissions.RoleScope.API.equals((Object)roleEntity.getScope()) && !io.gravitee.management.model.permissions.RoleScope.GROUP.equals((Object)roleEntity.getScope())) {
            throw new NotAuthorizedMembershipException(role.getName());
        }
        if (MembershipReferenceType.GROUP.equals((Object)reference.getType()) && SystemRole.PRIMARY_OWNER.name().equals(role.getName())) {
            throw new NotAuthorizedMembershipException(role.getName());
        }
    }

    private void assertRoleNameAllowedForReference(MembershipService.MembershipReference reference, MembershipService.MembershipRole role) {
        if (MembershipReferenceType.GROUP.equals((Object)reference.getType()) && SystemRole.PRIMARY_OWNER.name().equals(role.getName())) {
            throw new NotAuthorizedMembershipException(role.getName());
        }
    }

    private void assertNotOverridePrimaryOwner(MembershipService.MembershipReference reference, String userId, MembershipService.MembershipRole role) {
        MemberEntity member;
        if (userId != null && !SystemRole.PRIMARY_OWNER.name().equals(role.getName()) && (MembershipReferenceType.API.equals((Object)reference.getType()) || MembershipReferenceType.APPLICATION.equals((Object)reference.getType())) && (member = this.getMember(reference.getType(), reference.getId(), userId, role.getScope())) != null && SystemRole.PRIMARY_OWNER.name().equals(member.getRole())) {
            throw new AlreadyPrimaryOwnerException(userId);
        }
    }

    @Override
    public MemberEntity addOrUpdateMember(MembershipService.MembershipReference reference, MembershipService.MembershipUser user, MembershipService.MembershipRole role) {
        return this.addOrUpdateMember(reference, user, role, false);
    }

    public MemberEntity addOrUpdateMember(MembershipService.MembershipReference reference, MembershipService.MembershipUser user, MembershipService.MembershipRole role, boolean transferOwnership) {
        try {
            Membership returnedMembership;
            UserEntity userEntity;
            this.LOGGER.debug("Add a new member for {} {}", (Object)reference.getType(), (Object)reference.getId());
            this.assertRoleScopeAllowedForReference(reference, role);
            this.assertRoleNameAllowedForReference(reference, role);
            if (user.getId() != null) {
                userEntity = this.userService.findById(user.getId());
                if (!transferOwnership) {
                    this.assertNotOverridePrimaryOwner(reference, user.getId(), role);
                }
            } else {
                Optional<User> providerUser = this.identityService.findByReference(user.getReference());
                if (providerUser.isPresent()) {
                    User identityUser = providerUser.get();
                    try {
                        userEntity = this.userService.findBySource(identityUser.getSource(), identityUser.getSourceId(), false);
                        this.assertNotOverridePrimaryOwner(reference, userEntity.getId(), role);
                    }
                    catch (UserNotFoundException unfe) {
                        NewExternalUserEntity newUser = new NewExternalUserEntity();
                        newUser.setFirstname(identityUser.getFirstname());
                        newUser.setLastname(identityUser.getLastname());
                        newUser.setSource(identityUser.getSource());
                        newUser.setEmail(identityUser.getEmail());
                        newUser.setSourceId(identityUser.getSourceId());
                        userEntity = this.userService.create(newUser, true);
                    }
                } else {
                    throw new UserNotFoundException(user.getReference());
                }
            }
            Optional optionalMembership = this.membershipRepository.findById(userEntity.getId(), reference.getType(), reference.getId());
            Date updateDate = new Date();
            if (optionalMembership.isPresent()) {
                Membership updatedMembership = (Membership)optionalMembership.get();
                Membership previousMembership = new Membership(updatedMembership);
                updatedMembership.getRoles().put(role.getScope().getId(), role.getName());
                updatedMembership.setUpdatedAt(updateDate);
                returnedMembership = this.membershipRepository.update((Membership)optionalMembership.get());
                this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_UPDATED, updatedMembership.getUpdatedAt(), previousMembership, updatedMembership);
            } else {
                EmailNotification emailNotification;
                Membership membership = new Membership(userEntity.getId(), reference.getId(), reference.getType());
                membership.setRoles(Collections.singletonMap(role.getScope().getId(), role.getName()));
                membership.setCreatedAt(updateDate);
                membership.setUpdatedAt(updateDate);
                returnedMembership = this.membershipRepository.create(membership);
                this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_CREATED, membership.getCreatedAt(), null, membership);
                if (userEntity.getEmail() != null && !userEntity.getEmail().isEmpty() && (emailNotification = this.buildEmailNotification(userEntity, reference.getType(), reference.getId())) != null) {
                    this.emailService.sendAsyncEmailNotification(emailNotification);
                }
                if (MembershipReferenceType.GROUP.equals((Object)reference.getType())) {
                    this.notifierService.trigger(PortalHook.GROUP_INVITATION, Collections.singletonMap("group", this.groupService.findById(reference.getId())));
                }
            }
            return this.convert(returnedMembership, role.getScope());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to add member for {} {}", new Object[]{reference.getType(), reference.getId(), ex});
            throw new TechnicalManagementException("An error occurs while trying to add member for " + reference.getType() + " " + reference.getId(), ex);
        }
    }

    @Override
    public void deleteMember(MembershipReferenceType referenceType, String referenceId, String userId) {
        try {
            RoleScope roleScope;
            RoleEntity roleEntity;
            this.LOGGER.debug("Delete member {} for {} {}", new Object[]{userId, referenceType, referenceId});
            if (!MembershipReferenceType.GROUP.equals((Object)referenceType) && (roleEntity = this.getRole(referenceType, referenceId, userId, roleScope = this.getScopeByMembershipReferenceType(referenceType))) != null && SystemRole.PRIMARY_OWNER.name().equals(roleEntity.getName())) {
                throw new SinglePrimaryOwnerException(referenceType.equals((Object)MembershipReferenceType.API) ? RoleScope.API : RoleScope.APPLICATION);
            }
            Membership membership = new Membership(userId, referenceId, referenceType);
            this.membershipRepository.delete(membership);
            this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_DELETED, new Date(), membership, null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete member {} for {} {}", new Object[]{userId, referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete member " + userId + " for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public void transferApiOwnership(String apiId, MembershipService.MembershipUser user, RoleEntity newPrimaryOwnerRole) {
        this.transferOwnership(MembershipReferenceType.API, RoleScope.API, apiId, user, newPrimaryOwnerRole);
    }

    @Override
    public void transferApplicationOwnership(String applicationId, MembershipService.MembershipUser user, RoleEntity newPrimaryOwnerRole) {
        this.transferOwnership(MembershipReferenceType.APPLICATION, RoleScope.APPLICATION, applicationId, user, newPrimaryOwnerRole);
    }

    private void transferOwnership(MembershipReferenceType membershipReferenceType, RoleScope roleScope, String itemId, MembershipService.MembershipUser user, RoleEntity newPrimaryOwnerRole) {
        RoleEntity newRole = newPrimaryOwnerRole != null ? newPrimaryOwnerRole : this.roleService.findDefaultRoleByScopes(roleScope).get(0);
        MemberEntity newPrimaryOwner = this.addOrUpdateMember(new MembershipService.MembershipReference(membershipReferenceType, itemId), new MembershipService.MembershipUser(user.getId(), user.getReference()), new MembershipService.MembershipRole(roleScope, SystemRole.PRIMARY_OWNER.name()));
        this.getMembers(membershipReferenceType, itemId, roleScope, SystemRole.PRIMARY_OWNER.name()).stream().filter(memberEntity -> !memberEntity.getId().equals(newPrimaryOwner.getId())).forEach(m -> this.addOrUpdateMember(new MembershipService.MembershipReference(membershipReferenceType, itemId), new MembershipService.MembershipUser(m.getId(), null), new MembershipService.MembershipRole(roleScope, newRole.getName()), true));
    }

    @Override
    public Map<String, char[]> getMemberPermissions(ApiEntity api, String userId) {
        return this.getMemberPermissions(MembershipReferenceType.API, api.getId(), userId, api.getGroups(), RoleScope.API);
    }

    @Override
    public Map<String, char[]> getMemberPermissions(ApplicationEntity application, String userId) {
        return this.getMemberPermissions(MembershipReferenceType.APPLICATION, application.getId(), userId, application.getGroups(), RoleScope.APPLICATION);
    }

    @Override
    public Map<String, char[]> getMemberPermissions(GroupEntity group, String userId) {
        return this.getMemberPermissions(MembershipReferenceType.GROUP, group.getId(), userId, null, RoleScope.GROUP);
    }

    @Override
    public boolean removeRole(MembershipReferenceType referenceType, String referenceId, String userId, RoleScope roleScope) {
        try {
            Optional optionalMembership = this.membershipRepository.findById(userId, referenceType, referenceId);
            if (optionalMembership.isPresent()) {
                Membership membership = (Membership)optionalMembership.get();
                Membership previousMembership = new Membership(membership);
                membership.getRoles().remove(roleScope.getId());
                membership.setUpdatedAt(new Date());
                if (membership.getRoles().isEmpty()) {
                    throw new MemberWithoutRoleException(membership.getUserId());
                }
                this.membershipRepository.update(membership);
                this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_UPDATED, membership.getUpdatedAt(), previousMembership, membership);
                return true;
            }
            return false;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get membership for {} {} and user", new Object[]{referenceType, referenceId, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for " + referenceType + " " + referenceId + " and user " + userId, ex);
        }
    }

    @Override
    public void removeRoleUsage(RoleScope roleScope, String roleName, String newRole) {
        try {
            Set memberships = this.membershipRepository.findByRole(roleScope, roleName);
            for (Membership membership : memberships) {
                membership.getRoles().put(roleScope.getId(), newRole);
                this.membershipRepository.update(membership);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to remove role {} {}", new Object[]{roleScope, roleName, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove role " + roleScope + " " + roleName, ex);
        }
    }

    @Override
    public void removeUser(String userId) {
        try {
            for (Membership membership : this.membershipRepository.findByUser(userId)) {
                this.membershipRepository.delete(membership);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to remove user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove user " + userId, ex);
        }
    }

    @Override
    public List<UserMembership> findUserMembership(String userId, MembershipReferenceType type) {
        if (type == null || !type.equals((Object)MembershipReferenceType.API) && !type.equals((Object)MembershipReferenceType.APPLICATION) && !type.equals((Object)MembershipReferenceType.GROUP)) {
            return Collections.emptyList();
        }
        try {
            Set userMemberships = this.membershipRepository.findByUserAndReferenceType(userId, type).stream().map(membership -> {
                UserMembership userMembership = new UserMembership();
                userMembership.setType(type.name());
                userMembership.setReference(membership.getReferenceId());
                return userMembership;
            }).collect(Collectors.toSet());
            if (type.equals((Object)MembershipReferenceType.APPLICATION) || type.equals((Object)MembershipReferenceType.API)) {
                List<String> groupIds = this.membershipRepository.findByUserAndReferenceType(userId, MembershipReferenceType.GROUP).stream().filter(m -> m.getRoles().keySet().contains(type.equals((Object)MembershipReferenceType.API) ? RoleScope.API.getId() : RoleScope.APPLICATION.getId())).map(Membership::getReferenceId).collect(Collectors.toList());
                if (!groupIds.isEmpty() && type.equals((Object)MembershipReferenceType.API)) {
                    ApiQuery apiQuery = new ApiQuery();
                    apiQuery.setGroups(groupIds);
                    userMemberships.addAll(this.apiService.search(apiQuery).stream().map(apiEntity -> {
                        UserMembership userMembership = new UserMembership();
                        userMembership.setReference(apiEntity.getId());
                        userMembership.setType(type.name());
                        return userMembership;
                    }).collect(Collectors.toSet()));
                } else if (!groupIds.isEmpty() && type.equals((Object)MembershipReferenceType.APPLICATION)) {
                    userMemberships.addAll(this.applicationService.findByGroups(groupIds).stream().map(applicationEntity -> {
                        UserMembership userMembership = new UserMembership();
                        userMembership.setReference(applicationEntity.getId());
                        userMembership.setType(type.name());
                        return userMembership;
                    }).collect(Collectors.toSet()));
                }
            }
            return new ArrayList<UserMembership>(userMemberships);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to remove user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove user " + userId, ex);
        }
    }

    @Override
    public Metadata findUserMembershipMetadata(List<UserMembership> memberships, MembershipReferenceType type) {
        if (memberships == null || memberships.isEmpty() || type == null || !type.equals((Object)MembershipReferenceType.API) && !type.equals((Object)MembershipReferenceType.APPLICATION) && !type.equals((Object)MembershipReferenceType.GROUP)) {
            return new Metadata();
        }
        try {
            Metadata metadata = new Metadata();
            if (type.equals((Object)MembershipReferenceType.API)) {
                ApiCriteria.Builder criteria = new ApiCriteria.Builder();
                ApiFieldExclusionFilter filter = new ApiFieldExclusionFilter.Builder().excludeDefinition().excludePicture().build();
                criteria.ids((String[])memberships.stream().map(UserMembership::getReference).toArray(String[]::new));
                this.apiRepository.search(criteria.build(), filter).forEach(api -> {
                    metadata.put(api.getId(), "name", (Object)api.getName());
                    metadata.put(api.getId(), "version", (Object)api.getVersion());
                    metadata.put(api.getId(), "visibility", (Object)api.getVisibility());
                });
            } else if (type.equals((Object)MembershipReferenceType.APPLICATION)) {
                this.applicationRepository.findByIds(memberships.stream().map(UserMembership::getReference).collect(Collectors.toList())).forEach(application -> metadata.put(application.getId(), "name", (Object)application.getName()));
            }
            return metadata;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get user membership metadata", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to get user membership metadata", ex);
        }
    }

    @Override
    public int getNumberOfMembers(MembershipReferenceType referenceType, String referenceId, RoleScope roleScope) {
        return this.getMembers(referenceType, referenceId, roleScope).size() + this.invitationService.findByReference(InvitationReferenceType.valueOf((String)referenceType.name()), referenceId).size();
    }

    private Map<String, char[]> getMemberPermissions(MembershipReferenceType membershipReferenceType, String referenceId, String userId, Set<String> groups, RoleScope roleScope) {
        MemberEntity member = this.getMember(membershipReferenceType, referenceId, userId, roleScope);
        if (member != null) {
            return member.getPermissions();
        }
        if (groups != null) {
            HashMap mergedPermissions = new HashMap();
            for (String groupid : groups) {
                member = this.getMember(MembershipReferenceType.GROUP, groupid, userId, roleScope);
                if (member == null) continue;
                for (Map.Entry perm : member.getPermissions().entrySet()) {
                    if (mergedPermissions.containsKey(perm.getKey())) {
                        Set previousCRUD = (Set)mergedPermissions.get(perm.getKey());
                        for (char c : (char[])perm.getValue()) {
                            previousCRUD.add(Character.valueOf(c));
                        }
                        continue;
                    }
                    HashSet<Character> crudAsSet = new HashSet<Character>();
                    for (char c : (char[])perm.getValue()) {
                        crudAsSet.add(Character.valueOf(c));
                    }
                    mergedPermissions.put(perm.getKey(), crudAsSet);
                }
            }
            HashMap<String, char[]> permissions = new HashMap<String, char[]>(mergedPermissions.size());
            mergedPermissions.forEach((k, v) -> {
                Character[] characters = v.toArray(new Character[v.size()]);
                char[] chars = new char[characters.length];
                for (int i = 0; i < characters.length; ++i) {
                    chars[i] = characters[i].charValue();
                }
                permissions.put((String)k, chars);
            });
            return permissions;
        }
        return Collections.emptyMap();
    }

    private MemberEntity convert(Membership membership, RoleScope roleScope) {
        MemberEntity member = new MemberEntity();
        UserEntity userEntity = this.userService.findById(membership.getUserId());
        RoleEntity role = this.getRole(membership.getReferenceType(), membership.getReferenceId(), membership.getUserId(), roleScope);
        if (role == null) {
            return null;
        }
        member.setPermissions(role.getPermissions());
        member.setId(membership.getUserId());
        member.setCreatedAt(membership.getCreatedAt());
        member.setUpdatedAt(membership.getUpdatedAt());
        member.setRole(role.getName());
        member.setDisplayName(userEntity.getDisplayName());
        member.setEmail(userEntity.getEmail());
        return member;
    }

    private EmailNotification buildEmailNotification(UserEntity user, MembershipReferenceType referenceType, String referenceId) {
        String subject = null;
        EmailNotificationBuilder.EmailTemplate template = null;
        Map<String, Object> params = null;
        NotificationParamsBuilder paramsBuilder = new NotificationParamsBuilder();
        switch (referenceType) {
            case APPLICATION: {
                ApplicationEntity applicationEntity = this.applicationService.findById(referenceId);
                subject = "Subscription to application " + applicationEntity.getName();
                template = EmailNotificationBuilder.EmailTemplate.APPLICATION_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.application(applicationEntity).user(user).build();
                break;
            }
            case API: {
                ApiEntity apiEntity = this.apiService.findById(referenceId);
                subject = "Subscription to API " + apiEntity.getName();
                template = EmailNotificationBuilder.EmailTemplate.API_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.api(apiEntity).user(user).build();
                break;
            }
            case GROUP: {
                GroupEntity groupEntity = this.groupService.findById(referenceId);
                subject = "Subscription to group " + groupEntity.getName();
                template = EmailNotificationBuilder.EmailTemplate.GROUP_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.group(groupEntity).user(user).build();
            }
        }
        if (template == null) {
            return null;
        }
        return new EmailNotificationBuilder().to(user.getEmail()).subject(subject).template(template).params(params).build();
    }

    private RoleScope getScopeByMembershipReferenceType(MembershipReferenceType type) {
        if (type == null) {
            return null;
        }
        if (MembershipReferenceType.PORTAL.equals((Object)type)) {
            return RoleScope.PORTAL;
        }
        if (MembershipReferenceType.MANAGEMENT.equals((Object)type)) {
            return RoleScope.MANAGEMENT;
        }
        if (MembershipReferenceType.APPLICATION.equals((Object)type)) {
            return RoleScope.APPLICATION;
        }
        if (MembershipReferenceType.API.equals((Object)type)) {
            return RoleScope.API;
        }
        throw new TechnicalManagementException("the MembershipType is not associated to a RoleScope");
    }

    private void createAuditLog(Audit.AuditEvent event, Date date, Membership oldValue, Membership newValue) {
        MembershipReferenceType referenceType = oldValue != null ? oldValue.getReferenceType() : newValue.getReferenceType();
        String referenceId = oldValue != null ? oldValue.getReferenceId() : newValue.getReferenceId();
        String username = oldValue != null ? oldValue.getUserId() : newValue.getUserId();
        HashMap<Audit.AuditProperties, String> properties = new HashMap<Audit.AuditProperties, String>();
        properties.put(Audit.AuditProperties.USER, username);
        switch (referenceType) {
            case API: {
                this.auditService.createApiAuditLog(referenceId, properties, event, date, oldValue, newValue);
                break;
            }
            case APPLICATION: {
                this.auditService.createApplicationAuditLog(referenceId, properties, event, date, oldValue, newValue);
                break;
            }
            case GROUP: {
                properties.put(Audit.AuditProperties.GROUP, referenceId);
                this.auditService.createPortalAuditLog(properties, event, date, oldValue, newValue);
                break;
            }
            default: {
                this.auditService.createPortalAuditLog(properties, event, date, oldValue, newValue);
            }
        }
    }
}

