/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApiKeyEntity;
import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.InstanceListItem;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.PlanSecurityType;
import io.gravitee.management.model.SubscriptionEntity;
import io.gravitee.management.model.analytics.query.LogQuery;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.log.ApiRequest;
import io.gravitee.management.model.log.ApiRequestItem;
import io.gravitee.management.model.log.ApplicationRequest;
import io.gravitee.management.model.log.ApplicationRequestItem;
import io.gravitee.management.model.log.SearchLogResponse;
import io.gravitee.management.model.log.extended.Request;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.service.ApiKeyService;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.InstanceService;
import io.gravitee.management.service.LogsService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.SubscriptionService;
import io.gravitee.management.service.exceptions.ApiKeyNotFoundException;
import io.gravitee.management.service.exceptions.ApiNotFoundException;
import io.gravitee.management.service.exceptions.ApplicationNotFoundException;
import io.gravitee.management.service.exceptions.PlanNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.Order;
import io.gravitee.repository.analytics.query.QueryBuilders;
import io.gravitee.repository.analytics.query.SortBuilder;
import io.gravitee.repository.analytics.query.tabular.TabularQuery;
import io.gravitee.repository.analytics.query.tabular.TabularQueryBuilder;
import io.gravitee.repository.analytics.query.tabular.TabularResponse;
import io.gravitee.repository.log.api.LogRepository;
import io.gravitee.repository.log.model.ExtendedLog;
import io.gravitee.repository.log.model.Log;
import io.gravitee.repository.log.model.Response;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.Audit;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogsServiceImpl
implements LogsService {
    private final Logger logger = LoggerFactory.getLogger(LogsServiceImpl.class);
    private static final String APPLICATION_KEYLESS = "1";
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final char separator = ';';
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private PlanService planService;
    @Autowired
    private InstanceService instanceService;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;

    @Override
    public SearchLogResponse findByApi(String api, LogQuery query) {
        try {
            String field = query.getField() == null ? "@timestamp" : query.getField();
            TabularResponse response = this.logRepository.query((TabularQuery)((TabularQueryBuilder)((TabularQueryBuilder)((TabularQueryBuilder)QueryBuilders.tabular().page(query.getPage()).size(query.getSize()).query(query.getQuery())).sort(SortBuilder.on((String)field, (Order)(query.isOrder() ? Order.ASC : Order.DESC), null)).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root("api", api)).build());
            SearchLogResponse logResponse = new SearchLogResponse(response.getSize());
            logResponse.setLogs(response.getLogs().stream().map(this::toApiRequestItem).collect(Collectors.toList()));
            if (response.getSize() > 0L) {
                HashMap metadata = new HashMap();
                logResponse.getLogs().forEach(logItem -> {
                    String application = logItem.getApplication();
                    String plan = logItem.getPlan();
                    if (application != null) {
                        metadata.computeIfAbsent(application, this.getApplicationMetadata(application));
                    }
                    if (plan != null) {
                        metadata.computeIfAbsent(plan, this.getPlanMetadata(plan));
                    }
                });
                logResponse.setMetadata(metadata);
            }
            return logResponse;
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve logs: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve logs", ae);
        }
    }

    @Override
    public ApiRequest findApiLog(String id, Long timestamp) {
        try {
            ExtendedLog log = this.logRepository.findById(id, timestamp);
            if (this.parameterService.findAsBoolean(Key.LOGGING_AUDIT_ENABLED)) {
                this.auditService.createApiAuditLog(log.getApi(), Collections.singletonMap(Audit.AuditProperties.REQUEST_ID, id), (Audit.AuditEvent)Log.AuditEvent.LOG_READ, new Date(), null, null);
            }
            return this.toApiRequest(log);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve log: " + id, (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve log: " + id, ae);
        }
    }

    @Override
    public SearchLogResponse findByApplication(String application, LogQuery query) {
        try {
            String field = query.getField() == null ? "@timestamp" : query.getField();
            TabularResponse response = this.logRepository.query((TabularQuery)((TabularQueryBuilder)((TabularQueryBuilder)((TabularQueryBuilder)QueryBuilders.tabular().page(query.getPage()).size(query.getSize()).query(query.getQuery())).sort(SortBuilder.on((String)field, (Order)(query.isOrder() ? Order.ASC : Order.DESC), null)).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root("application", application)).build());
            SearchLogResponse logResponse = new SearchLogResponse(response.getSize());
            logResponse.setLogs(response.getLogs().stream().map(this::toApplicationRequestItem).collect(Collectors.toList()));
            if (response.getSize() > 0L) {
                HashMap metadata = new HashMap();
                logResponse.getLogs().forEach(logItem -> {
                    String api = logItem.getApi();
                    String plan = logItem.getPlan();
                    if (api != null) {
                        metadata.computeIfAbsent(api, this.getAPIMetadata(api));
                    }
                    if (plan != null) {
                        metadata.computeIfAbsent(plan, this.getPlanMetadata(plan));
                    }
                });
                logResponse.setMetadata(metadata);
            }
            return logResponse;
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve logs: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve logs", ae);
        }
    }

    @Override
    public ApplicationRequest findApplicationLog(String id, Long timestamp) {
        try {
            return this.toApplicationRequest(this.logRepository.findById(id, timestamp));
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve log: " + id, (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve log: " + id, ae);
        }
    }

    private Function<String, Map<String, String>> getAPIMetadata(String api) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            try {
                ApiEntity apiEntity = this.apiService.findById(api);
                metadata.put("name", apiEntity.getName());
                metadata.put("version", apiEntity.getVersion());
            }
            catch (ApiNotFoundException anfe) {
                metadata.put("name", "Deleted API");
                metadata.put("deleted", "true");
            }
            return metadata;
        };
    }

    private Function<String, Map<String, String>> getApplicationMetadata(String application) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            try {
                ApplicationEntity applicationEntity = this.applicationService.findById(application);
                metadata.put("name", applicationEntity.getName());
                if (ApplicationStatus.ARCHIVED.toString().equals(applicationEntity.getStatus())) {
                    metadata.put("deleted", "true");
                }
            }
            catch (ApplicationNotFoundException anfe) {
                metadata.put("deleted", "true");
                if (application.equals(APPLICATION_KEYLESS)) {
                    metadata.put("name", "Unknown application (keyless)");
                }
                metadata.put("name", "Deleted application");
            }
            return metadata;
        };
    }

    private Function<String, Map<String, String>> getPlanMetadata(String plan) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            try {
                PlanEntity planEntity = this.planService.findById(plan);
                metadata.put("name", planEntity.getName());
            }
            catch (PlanNotFoundException anfe) {
                metadata.put("deleted", "true");
            }
            return metadata;
        };
    }

    private Function<String, Map<String, String>> getGatewayMetadata(String gateway) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            Optional<InstanceListItem> instanceOptional = this.instanceService.findInstances(true, gateway).stream().findFirst();
            if (instanceOptional.isPresent()) {
                metadata.put("hostname", instanceOptional.get().getHostname());
                metadata.put("ip", instanceOptional.get().getIp());
                if (instanceOptional.get().getTenant() != null) {
                    metadata.put("tenant", instanceOptional.get().getTenant());
                }
            } else {
                metadata.put("deleted", "true");
            }
            return metadata;
        };
    }

    private String getSubscription(ExtendedLog log) {
        Collection<SubscriptionEntity> subscriptions;
        PlanEntity plan;
        if ("API_KEY".equals(log.getSecurityType())) {
            try {
                ApiKeyEntity key = this.apiKeyService.findByKey(log.getSecurityToken());
                if (key != null) {
                    return key.getSubscription();
                }
            }
            catch (ApiKeyNotFoundException key) {}
        } else if (!(log.getPlan() == null || log.getApplication() == null || PlanSecurityType.API_KEY.equals((Object)(plan = this.planService.findById(log.getPlan())).getSecurity()) || PlanSecurityType.KEY_LESS.equals((Object)plan.getSecurity()) || (subscriptions = this.subscriptionService.findByApplicationAndPlan(log.getApplication(), log.getPlan())).isEmpty() || subscriptions.size() != 1)) {
            return subscriptions.iterator().next().getId();
        }
        return null;
    }

    @Override
    public String exportAsCsv(SearchLogResponse searchLogResponse) {
        if (searchLogResponse.getLogs() == null || searchLogResponse.getLogs().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object log : searchLogResponse.getLogs()) {
            Object application;
            Object plan;
            if (log instanceof ApiRequestItem) {
                ApiRequestItem apiLog = (ApiRequestItem)log;
                sb.append(dateFormatter.format(apiLog.getTimestamp()));
                sb.append(';');
                sb.append(apiLog.getId());
                sb.append(';');
                sb.append(apiLog.getTransactionId());
                sb.append(';');
                sb.append(apiLog.getMethod());
                sb.append(';');
                sb.append(apiLog.getPath());
                sb.append(';');
                sb.append(apiLog.getStatus());
                sb.append(';');
                sb.append(apiLog.getResponseTime());
                sb.append(';');
                plan = searchLogResponse.getMetadata().get(apiLog.getPlan());
                sb.append(this.getName(plan));
                sb.append(';');
                application = searchLogResponse.getMetadata().get(apiLog.getApplication());
                sb.append(this.getName(application));
                sb.append(System.lineSeparator());
                continue;
            }
            if (!(log instanceof ApplicationRequestItem)) continue;
            ApplicationRequestItem applicationLog = (ApplicationRequestItem)log;
            sb.append(dateFormatter.format(applicationLog.getTimestamp()));
            sb.append(';');
            sb.append(applicationLog.getId());
            sb.append(';');
            sb.append(applicationLog.getTransactionId());
            sb.append(';');
            sb.append(applicationLog.getMethod());
            sb.append(';');
            sb.append(applicationLog.getPath());
            sb.append(';');
            sb.append(applicationLog.getStatus());
            sb.append(';');
            sb.append(applicationLog.getResponseTime());
            sb.append(';');
            plan = searchLogResponse.getMetadata().get(applicationLog.getPlan());
            sb.append(this.getName(plan));
            sb.append(';');
            application = searchLogResponse.getMetadata().get(applicationLog.getApi());
            sb.append(this.getName(application));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private String getName(Object map) {
        return map == null ? "" : ((Map)map).get("name").toString();
    }

    private ApiRequestItem toApiRequestItem(Log log) {
        ApiRequestItem req = new ApiRequestItem();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApplication(log.getApplication());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).path());
        req.setPlan(log.getPlan());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTimestamp(log.getTimestamp());
        req.setEndpoint(log.getApiResponseTime() > 0L);
        req.setUser(log.getUser());
        return req;
    }

    private ApplicationRequestItem toApplicationRequestItem(Log log) {
        ApplicationRequestItem req = new ApplicationRequestItem();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApi(log.getApi());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).path());
        req.setPlan(log.getPlan());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTimestamp(log.getTimestamp());
        req.setUser(log.getUser());
        return req;
    }

    private ApiRequest toApiRequest(ExtendedLog log) {
        ApiRequest req = new ApiRequest();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApplication(log.getApplication());
        req.setApiResponseTime(log.getApiResponseTime());
        req.setEndpoint(log.getEndpoint());
        req.setLocalAddress(log.getLocalAddress());
        req.setRemoteAddress(log.getRemoteAddress());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).path());
        req.setPlan(log.getPlan());
        req.setRequestContentLength(log.getRequestContentLength());
        req.setResponseContentLength(log.getResponseContentLength());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTenant(log.getTenant());
        req.setTimestamp(log.getTimestamp());
        req.setUri(log.getUri());
        req.setMessage(log.getMessage());
        req.setGateway(log.getGateway());
        req.setSubscription(this.getSubscription(log));
        req.setHost(log.getHost());
        req.setSecurityType(log.getSecurityType());
        req.setSecurityToken(log.getSecurityToken());
        req.setClientRequest(this.createRequest(log.getClientRequest()));
        req.setProxyRequest(this.createRequest(log.getProxyRequest()));
        req.setClientResponse(this.createResponse(log.getClientResponse()));
        req.setProxyResponse(this.createResponse(log.getProxyResponse()));
        HashMap<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
        String application = log.getApplication();
        String plan = log.getPlan();
        String gateway = log.getGateway();
        if (application != null) {
            metadata.computeIfAbsent(application, this.getApplicationMetadata(application));
        }
        if (plan != null) {
            metadata.computeIfAbsent(plan, this.getPlanMetadata(plan));
        }
        if (gateway != null) {
            metadata.computeIfAbsent(gateway, this.getGatewayMetadata(gateway));
        }
        req.setMetadata(metadata);
        req.setUser(log.getUser());
        return req;
    }

    private Request createRequest(io.gravitee.repository.log.model.Request repoRequest) {
        if (repoRequest == null) {
            return null;
        }
        Request request = new Request();
        request.setUri(repoRequest.getUri());
        request.setMethod(repoRequest.getMethod());
        request.setHeaders(repoRequest.getHeaders());
        request.setBody(repoRequest.getBody());
        return request;
    }

    private io.gravitee.management.model.log.extended.Response createResponse(Response repoResponse) {
        if (repoResponse == null) {
            return null;
        }
        io.gravitee.management.model.log.extended.Response response = new io.gravitee.management.model.log.extended.Response();
        response.setStatus(repoResponse.getStatus());
        response.setHeaders(repoResponse.getHeaders());
        response.setBody(repoResponse.getBody());
        return response;
    }

    private ApplicationRequest toApplicationRequest(ExtendedLog log) {
        ApplicationRequest req = new ApplicationRequest();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApi(log.getApi());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).path());
        req.setPlan(log.getPlan());
        req.setRequestContentLength(log.getRequestContentLength());
        req.setResponseContentLength(log.getResponseContentLength());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTimestamp(log.getTimestamp());
        req.setRequest(this.createRequest(log.getClientRequest()));
        req.setResponse(this.createResponse(log.getClientResponse()));
        req.setHost(log.getHost());
        req.setSecurityType(log.getSecurityType());
        req.setSecurityToken(log.getSecurityToken());
        HashMap<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
        String api = log.getApi();
        String plan = log.getPlan();
        String gateway = log.getGateway();
        if (api != null) {
            metadata.computeIfAbsent(api, this.getAPIMetadata(api));
        }
        if (plan != null) {
            metadata.computeIfAbsent(plan, this.getPlanMetadata(plan));
        }
        if (gateway != null) {
            metadata.computeIfAbsent(gateway, this.getGatewayMetadata(gateway));
        }
        req.setMetadata(metadata);
        req.setUser(log.getUser());
        return req;
    }
}

