/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.gravitee.management.service.EmailNotification;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.exceptions.EmailDisabledException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Component
public class EmailServiceImpl
extends TransactionalService
implements EmailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private Configuration freemarkerConfiguration;
    @Value(value="${templates.path:${gravitee.home}/templates}")
    private String templatesPath;
    @Value(value="${email.subject:[Gravitee.io] %s}")
    private String subject;
    @Value(value="${email.enabled:false}")
    private boolean enabled;
    @Value(value="${email.from}")
    private String defaultFrom;

    @Override
    public void sendEmailNotification(EmailNotification emailNotification) {
        if (this.enabled) {
            try {
                String from;
                MimeMessageHelper mailMessage = new MimeMessageHelper(this.mailSender.createMimeMessage(), true, StandardCharsets.UTF_8.name());
                Template template = this.freemarkerConfiguration.getTemplate(emailNotification.getTemplate());
                String content = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, emailNotification.getParams());
                String string = from = Objects.isNull(emailNotification.getFrom()) || emailNotification.getFrom().isEmpty() ? this.defaultFrom : emailNotification.getFrom();
                if (StringUtils.isEmpty((CharSequence)emailNotification.getFromName())) {
                    mailMessage.setFrom(from);
                } else {
                    mailMessage.setFrom(from, emailNotification.getFromName());
                }
                mailMessage.setTo(emailNotification.getTo());
                if (emailNotification.isCopyToSender() && emailNotification.getFrom() != null) {
                    mailMessage.setBcc(emailNotification.getFrom());
                }
                if (emailNotification.getBcc() != null && emailNotification.getBcc().length > 0) {
                    mailMessage.setBcc(emailNotification.getBcc());
                }
                mailMessage.setSubject(String.format(this.subject, emailNotification.getSubject()));
                String html = this.addResourcesInMessage(mailMessage, content);
                LOGGER.debug("Sending an email to: {}\nSubject: {}\nMessage: {}", new Object[]{emailNotification.getTo(), emailNotification.getSubject(), html});
                this.mailSender.send(mailMessage.getMimeMessage());
            }
            catch (Exception ex) {
                LOGGER.error("Error while sending email notification", (Throwable)ex);
                throw new TechnicalManagementException("Error while sending email notification", ex);
            }
        } else {
            throw new EmailDisabledException();
        }
    }

    @Override
    @Async
    public void sendAsyncEmailNotification(EmailNotification emailNotification) {
        this.sendEmailNotification(emailNotification);
    }

    private String addResourcesInMessage(MimeMessageHelper mailMessage, String htmlText) throws Exception {
        Document document = Jsoup.parse((String)htmlText);
        ArrayList resources = new ArrayList();
        Elements imageElements = document.getElementsByTag("img");
        resources.addAll(imageElements.stream().filter(imageElement -> imageElement.hasAttr("src")).filter(imageElement -> !imageElement.attr("src").startsWith("http")).map(imageElement -> {
            String src = imageElement.attr("src");
            imageElement.attr("src", "cid:" + src);
            return src;
        }).collect(Collectors.toList()));
        String html = document.html();
        mailMessage.setText(html, true);
        for (String res : resources) {
            FileSystemResource templateResource = new FileSystemResource(new File(this.templatesPath, res));
            mailMessage.addInline(res, (InputStreamSource)templateResource, this.getContentTypeByFileName(res));
        }
        return html;
    }

    private String getContentTypeByFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        return MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
    }
}

