/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.PortalConfigEntity;
import io.gravitee.management.model.annotations.ParameterKey;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.service.ConfigService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.impl.AbstractService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class ConfigServiceImpl
extends AbstractService
implements ConfigService {
    private final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private ConfigurableEnvironment environment;

    @Override
    public PortalConfigEntity getPortalConfig() {
        PortalConfigEntity portalConfigEntity = new PortalConfigEntity();
        Object[] objects = this.getObjectArray(portalConfigEntity);
        ArrayList<Key> parameterKeys = new ArrayList<Key>();
        for (Object o : objects) {
            for (Field f : o.getClass().getDeclaredFields()) {
                ParameterKey parameterKey = f.getAnnotation(ParameterKey.class);
                if (parameterKey == null) continue;
                parameterKeys.add(parameterKey.value());
            }
        }
        Map<String, List<String>> parameterMap = this.parameterService.findAll(parameterKeys);
        for (Object o : objects) {
            for (Field f : o.getClass().getDeclaredFields()) {
                ParameterKey parameterKey = f.getAnnotation(ParameterKey.class);
                if (parameterKey == null) continue;
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                try {
                    List<String> values = parameterMap.get(parameterKey.value().key());
                    String defaultValue = parameterKey.value().defaultValue();
                    if (PortalConfigEntity.Enabled.class.isAssignableFrom(f.getType())) {
                        f.set(o, Boolean.valueOf(this.getFirstValueOrDefault(values, defaultValue)) != false ? new PortalConfigEntity.Enabled(true) : new PortalConfigEntity.Enabled(false));
                    } else if (Boolean.class.isAssignableFrom(f.getType())) {
                        f.set(o, Boolean.valueOf(this.getFirstValueOrDefault(values, defaultValue)));
                    } else if (Integer.class.isAssignableFrom(f.getType())) {
                        f.set(o, Integer.valueOf(this.getFirstValueOrDefault(values, defaultValue)));
                    } else if (Long.class.isAssignableFrom(f.getType())) {
                        f.set(o, Long.valueOf(this.getFirstValueOrDefault(values, defaultValue)));
                    } else if (List.class.isAssignableFrom(f.getType())) {
                        if (values == null || values.isEmpty()) {
                            f.set(o, Collections.emptyList());
                        } else {
                            f.set(o, values);
                        }
                    } else if (Map.class.isAssignableFrom(f.getType())) {
                        if (values == null || values.isEmpty()) {
                            if (defaultValue == null) {
                                f.set(o, Collections.emptyMap());
                            } else {
                                f.set(o, Collections.singletonMap(defaultValue.split("@")[0], defaultValue.split("@")[1]));
                            }
                        } else {
                            f.set(o, values.stream().collect(Collectors.toMap(v -> v.split("@")[0], v -> {
                                String[] split = v.split("@");
                                if (split.length < 2) {
                                    return "";
                                }
                                return split[1];
                            })));
                        }
                    } else {
                        f.set(o, this.getFirstValueOrDefault(values, defaultValue));
                    }
                }
                catch (IllegalAccessException e) {
                    this.LOGGER.error("Unable to set parameter {}. Use the default value", (Object)parameterKey.value().key(), (Object)e);
                }
                f.setAccessible(accessible);
            }
        }
        this.enhanceFromConfigFile(portalConfigEntity);
        return portalConfigEntity;
    }

    private String getFirstValueOrDefault(List<String> values, String defaultValue) {
        if (values == null) {
            return defaultValue;
        }
        if (values.isEmpty()) {
            return "";
        }
        return values.get(0);
    }

    private void enhanceFromConfigFile(PortalConfigEntity portalConfigEntity) {
        boolean found = true;
        int idx = 0;
        while (found) {
            String type = this.environment.getProperty("security.providers[" + idx + "].type");
            boolean bl = found = type != null;
            if (found) {
                String clientId = this.environment.getProperty("security.providers[" + idx + "].clientId");
                if ("google".equals(type)) {
                    portalConfigEntity.getAuthentication().getGoogle().setClientId(clientId);
                } else if ("github".equals(type)) {
                    portalConfigEntity.getAuthentication().getGithub().setClientId(clientId);
                } else if ("oauth2".equals(type)) {
                    portalConfigEntity.getAuthentication().getOauth2().setClientId(clientId);
                }
            }
            ++idx;
        }
    }

    @Override
    public void save(PortalConfigEntity portalConfigEntity) {
        Object[] objects;
        for (Object o : objects = this.getObjectArray(portalConfigEntity)) {
            for (Field f : o.getClass().getDeclaredFields()) {
                ParameterKey parameterKey = f.getAnnotation(ParameterKey.class);
                if (parameterKey == null) continue;
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                try {
                    if (f.get(o) != null) {
                        if (PortalConfigEntity.Enabled.class.isAssignableFrom(f.getType())) {
                            this.parameterService.save(parameterKey.value(), Boolean.toString(((PortalConfigEntity.Enabled)f.get(o)).isEnabled()));
                        } else if (Boolean.class.isAssignableFrom(f.getType())) {
                            this.parameterService.save(parameterKey.value(), Boolean.toString((Boolean)f.get(o)));
                        } else if (Integer.class.isAssignableFrom(f.getType())) {
                            this.parameterService.save(parameterKey.value(), Integer.toString((Integer)f.get(o)));
                        } else if (Long.class.isAssignableFrom(f.getType())) {
                            this.parameterService.save(parameterKey.value(), Long.toString((Long)f.get(o)));
                        } else if (List.class.isAssignableFrom(f.getType())) {
                            this.parameterService.save(parameterKey.value(), (List)f.get(o));
                        } else if (Map.class.isAssignableFrom(f.getType())) {
                            this.parameterService.save(parameterKey.value(), (Map)f.get(o));
                        } else {
                            this.parameterService.save(parameterKey.value(), (String)f.get(o));
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    this.LOGGER.error("Unable to set parameter {}. Use the default value", (Object)parameterKey.value().key(), (Object)e);
                }
                f.setAccessible(accessible);
            }
        }
    }

    private Object[] getObjectArray(PortalConfigEntity portalConfigEntity) {
        return new Object[]{portalConfigEntity, portalConfigEntity.getAuthentication(), portalConfigEntity.getAuthentication().getGithub(), portalConfigEntity.getAuthentication().getGoogle(), portalConfigEntity.getAuthentication().getOauth2(), portalConfigEntity.getCompany(), portalConfigEntity.getDocumentation(), portalConfigEntity.getManagement(), portalConfigEntity.getPortal(), portalConfigEntity.getPortal().getApis(), portalConfigEntity.getPortal().getAnalytics(), portalConfigEntity.getPortal().getDashboard(), portalConfigEntity.getPortal().getRating(), portalConfigEntity.getPortal().getRating().getComment(), portalConfigEntity.getPortal().getUploadMedia(), portalConfigEntity.getScheduler(), portalConfigEntity.getTheme(), portalConfigEntity.getPlan(), portalConfigEntity.getPlan().getSecurity(), portalConfigEntity.getApiQualityMetrics(), portalConfigEntity.getLogging(), portalConfigEntity.getLogging().getAudit(), portalConfigEntity.getLogging().getUser(), portalConfigEntity.getAnalytics(), portalConfigEntity.getApplication(), portalConfigEntity.getApplication().getRegistration(), portalConfigEntity.getLogging().getAudit().getTrail()};
    }
}

