/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.utils.UUID;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.Path;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.endpoint.HttpEndpoint;
import io.gravitee.management.model.ApiMetadataEntity;
import io.gravitee.management.model.ApiModelEntity;
import io.gravitee.management.model.EventEntity;
import io.gravitee.management.model.EventQuery;
import io.gravitee.management.model.EventType;
import io.gravitee.management.model.GroupEntity;
import io.gravitee.management.model.ImportSwaggerDescriptorEntity;
import io.gravitee.management.model.InlinePictureEntity;
import io.gravitee.management.model.NewGroupEntity;
import io.gravitee.management.model.NewPageEntity;
import io.gravitee.management.model.NewPlanEntity;
import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.PageSourceEntity;
import io.gravitee.management.model.PageType;
import io.gravitee.management.model.PlanEntity;
import io.gravitee.management.model.PlanSecurityType;
import io.gravitee.management.model.PlanStatus;
import io.gravitee.management.model.PrimaryOwnerEntity;
import io.gravitee.management.model.RoleEntity;
import io.gravitee.management.model.SubscriptionEntity;
import io.gravitee.management.model.UpdatePageEntity;
import io.gravitee.management.model.UpdatePlanEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.model.Visibility;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.model.api.ApiQuery;
import io.gravitee.management.model.api.NewApiEntity;
import io.gravitee.management.model.api.NewSwaggerApiEntity;
import io.gravitee.management.model.api.SwaggerPath;
import io.gravitee.management.model.api.UpdateApiEntity;
import io.gravitee.management.model.api.header.ApiHeaderEntity;
import io.gravitee.management.model.documentation.PageQuery;
import io.gravitee.management.model.notification.GenericNotificationConfigEntity;
import io.gravitee.management.model.parameters.Key;
import io.gravitee.management.model.permissions.SystemRole;
import io.gravitee.management.model.plan.PlanQuery;
import io.gravitee.management.model.search.Indexable;
import io.gravitee.management.service.ApiHeaderService;
import io.gravitee.management.service.ApiMetadataService;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.EventService;
import io.gravitee.management.service.GenericNotificationConfigService;
import io.gravitee.management.service.GroupService;
import io.gravitee.management.service.MembershipService;
import io.gravitee.management.service.NotifierService;
import io.gravitee.management.service.PageService;
import io.gravitee.management.service.ParameterService;
import io.gravitee.management.service.PlanService;
import io.gravitee.management.service.SubscriptionService;
import io.gravitee.management.service.SwaggerService;
import io.gravitee.management.service.TagService;
import io.gravitee.management.service.TopApiService;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.management.service.exceptions.ApiContextPathAlreadyExistsException;
import io.gravitee.management.service.exceptions.ApiNotDeletableException;
import io.gravitee.management.service.exceptions.ApiNotFoundException;
import io.gravitee.management.service.exceptions.ApiRunningStateException;
import io.gravitee.management.service.exceptions.EndpointNameInvalidException;
import io.gravitee.management.service.exceptions.GroupsNotFoundException;
import io.gravitee.management.service.exceptions.InvalidDataException;
import io.gravitee.management.service.exceptions.TagNotAllowedException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UserNotFoundException;
import io.gravitee.management.service.impl.AbstractService;
import io.gravitee.management.service.impl.search.SearchResult;
import io.gravitee.management.service.jackson.ser.api.ApiSerializer;
import io.gravitee.management.service.notification.ApiHook;
import io.gravitee.management.service.notification.HookScope;
import io.gravitee.management.service.notification.NotificationParamsBuilder;
import io.gravitee.management.service.processor.ApiSynchronizationProcessor;
import io.gravitee.management.service.search.SearchEngineService;
import io.gravitee.management.service.search.query.Query;
import io.gravitee.management.service.search.query.QueryBuilder;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Component
public class ApiServiceImpl
extends AbstractService
implements ApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiServiceImpl.class);
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EventService eventService;
    @Autowired
    private UserService userService;
    @Autowired
    private PageService pageService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private PlanService planService;
    @Autowired
    private ApiSynchronizationProcessor apiSynchronizationProcessor;
    @Value(value="${configuration.default-icon:${gravitee.home}/assets/default_api_logo.png}")
    private String defaultIcon;
    @Autowired
    private ApiMetadataService apiMetadataService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private TopApiService topApiService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private SwaggerService swaggerService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private ApiHeaderService apiHeaderService;
    @Autowired
    private Configuration freemarkerConfiguration;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private TagService tagService;
    private static final Pattern LOGGING_MAX_DURATION_PATTERN = Pattern.compile("(?<before>.*)\\#request.timestamp\\s*\\<\\=?\\s*(?<timestamp>\\d*)l(?<after>.*)");
    private static final String LOGGING_MAX_DURATION_CONDITION = "#request.timestamp <= %dl";

    @Override
    public ApiEntity create(NewApiEntity newApiEntity, String userId) throws ApiAlreadyExistsException {
        return this.create(newApiEntity, userId, null, null);
    }

    @Override
    public ApiEntity create(NewSwaggerApiEntity swaggerApiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) throws ApiAlreadyExistsException {
        NewApiEntity newApiEntity = new NewApiEntity();
        newApiEntity.setVersion(swaggerApiEntity.getVersion());
        newApiEntity.setName(swaggerApiEntity.getName());
        newApiEntity.setContextPath(swaggerApiEntity.getContextPath());
        newApiEntity.setDescription(swaggerApiEntity.getDescription());
        newApiEntity.setEndpoint(swaggerApiEntity.getEndpoint());
        newApiEntity.setGroups(swaggerApiEntity.getGroups());
        return this.create(newApiEntity, userId, swaggerDescriptor, swaggerApiEntity.getPaths());
    }

    private ApiEntity create(NewApiEntity newApiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor, List<SwaggerPath> swaggerPaths) throws ApiAlreadyExistsException {
        List declaredPaths;
        UpdateApiEntity apiEntity = new UpdateApiEntity();
        apiEntity.setName(newApiEntity.getName());
        apiEntity.setDescription(newApiEntity.getDescription());
        apiEntity.setVersion(newApiEntity.getVersion());
        if (newApiEntity.getGroups() != null && !newApiEntity.getGroups().isEmpty()) {
            try {
                this.groupService.findByIds(newApiEntity.getGroups());
            }
            catch (GroupsNotFoundException gnfe) {
                throw new InvalidDataException("Groups [" + newApiEntity.getGroups() + "] does not exist");
            }
        }
        apiEntity.setGroups(newApiEntity.getGroups());
        Proxy proxy = new Proxy();
        proxy.setContextPath(newApiEntity.getContextPath());
        EndpointGroup group = new EndpointGroup();
        group.setName("default-group");
        group.setEndpoints(Collections.singleton(new HttpEndpoint("default", newApiEntity.getEndpoint())));
        proxy.setGroups(Collections.singleton(group));
        apiEntity.setProxy(proxy);
        if (swaggerPaths != null) {
            declaredPaths = swaggerPaths.stream().map(SwaggerPath::getPath).collect(Collectors.toList());
        } else {
            List<Object> list = declaredPaths = newApiEntity.getPaths() != null ? newApiEntity.getPaths() : new ArrayList();
        }
        if (!declaredPaths.contains("/")) {
            declaredPaths.add(0, "/");
        }
        Map<String, Path> paths = declaredPaths.stream().map(sPath -> {
            Path path = new Path();
            path.setPath(sPath);
            return path;
        }).collect(Collectors.toMap(Path::getPath, path -> path));
        apiEntity.setPaths(paths);
        apiEntity.setPathMappings(new HashSet(declaredPaths));
        if (swaggerDescriptor != null) {
            if (!swaggerDescriptor.isWithPolicyPaths()) {
                Path path2 = new Path();
                path2.setPath("/");
                apiEntity.setPaths(Collections.singletonMap("/", path2));
            } else if (swaggerPaths != null && !swaggerPaths.isEmpty()) {
                HashMap pathWithMocks = new HashMap(swaggerPaths.size());
                swaggerPaths.forEach(swaggerPath -> {
                    Path path = new Path();
                    path.setPath(swaggerPath.getPath());
                    if (swaggerDescriptor.isWithPolicyMocks()) {
                        ArrayList rules = new ArrayList();
                        swaggerPath.getVerbs().forEach(swaggerVerb -> {
                            Rule rule = new Rule();
                            rule.setEnabled(true);
                            rule.setDescription(swaggerVerb.getDescription());
                            rule.setMethods(Collections.singleton(HttpMethod.valueOf((String)swaggerVerb.getVerb())));
                            Policy policy = new Policy();
                            policy.setName("mock");
                            HashMap<String, Object> configuration = new HashMap<String, Object>();
                            String responseStatus = swaggerVerb.getResponseStatus();
                            try {
                                Integer.parseInt(responseStatus);
                            }
                            catch (NumberFormatException nfe) {
                                responseStatus = "200";
                            }
                            configuration.put("status", responseStatus);
                            HashMap<String, String> header = new HashMap<String, String>(2);
                            header.put("name", "Content-Type");
                            header.put("value", "application/json");
                            configuration.put("headers", Collections.singletonList(header));
                            try {
                                if (swaggerVerb.getResponseType() != null || swaggerVerb.getResponseExample() != null) {
                                    Object mockContent = swaggerVerb.getResponseExample() == null ? this.generateMockContent(swaggerVerb.getResponseType(), swaggerVerb.getResponseProperties()) : swaggerVerb.getResponseExample();
                                    configuration.put("content", this.objectMapper.writeValueAsString(mockContent));
                                }
                                policy.setConfiguration(this.objectMapper.writeValueAsString(configuration));
                            }
                            catch (JsonProcessingException e) {
                                e.printStackTrace();
                            }
                            rule.setPolicy(policy);
                            rules.add(rule);
                        });
                        path.setRules(rules);
                    }
                    pathWithMocks.put(swaggerPath.getPath(), path);
                });
                apiEntity.setPaths(pathWithMocks);
            }
            if (!swaggerDescriptor.isWithPathMapping()) {
                apiEntity.setPathMappings(null);
            }
        }
        ApiEntity createdApi = this.create0(apiEntity, userId);
        if (swaggerDescriptor != null && swaggerDescriptor.isWithDocumentation()) {
            NewPageEntity page = new NewPageEntity();
            page.setName("Swagger");
            page.setType(PageType.SWAGGER);
            page.setOrder(1);
            if (ImportSwaggerDescriptorEntity.Type.INLINE.equals((Object)swaggerDescriptor.getType())) {
                page.setContent(swaggerDescriptor.getPayload());
            } else {
                PageSourceEntity source = new PageSourceEntity();
                page.setSource(source);
                source.setType("http-fetcher");
                source.setConfiguration((JsonNode)this.objectMapper.convertValue(Collections.singletonMap("url", swaggerDescriptor.getPayload()), JsonNode.class));
            }
            this.pageService.createPage(createdApi.getId(), page);
        }
        return createdApi;
    }

    private Object generateMockContent(String responseType, Map<String, Object> responseProperties) {
        Random random = new Random();
        switch (responseType) {
            case "string": {
                return "Mocked " + (responseProperties == null ? "response" : responseProperties.getOrDefault("key", "response"));
            }
            case "boolean": {
                return random.nextBoolean();
            }
            case "integer": {
                return random.nextInt(1000);
            }
            case "number": {
                return random.nextDouble();
            }
            case "array": {
                return responseProperties == null ? Collections.emptyList() : Collections.singletonList(this.generateMockContent("object", responseProperties));
            }
            case "object": {
                if (responseProperties == null) {
                    return Collections.emptyMap();
                }
                HashMap mock = new HashMap(responseProperties.size());
                responseProperties.forEach((k, v) -> {
                    if (v instanceof Map) {
                        mock.put(k, this.generateMockContent("object", (Map)v));
                    } else {
                        mock.put(k, this.generateMockContent((String)v, Collections.singletonMap("key", k)));
                    }
                });
                return mock;
            }
        }
        return Collections.emptyMap();
    }

    private ApiEntity create0(UpdateApiEntity api, String userId) throws ApiAlreadyExistsException {
        try {
            LOGGER.debug("Create {} for user {}", (Object)api, (Object)userId);
            String id = UUID.toString((java.util.UUID)UUID.random());
            Optional checkApi = this.apiRepository.findById((Object)id);
            if (checkApi.isPresent()) {
                throw new ApiAlreadyExistsException(id);
            }
            this.checkShardingTags(api, null);
            this.checkContextPath(api.getProxy().getContextPath());
            this.checkEndpointsName(api);
            this.addLoggingMaxDuration(api.getProxy().getLogging());
            io.gravitee.repository.management.model.Api repoApi = this.convert(id, api);
            if (repoApi != null) {
                repoApi.setId(id);
                repoApi.setCreatedAt(new Date());
                repoApi.setUpdatedAt(repoApi.getCreatedAt());
                repoApi.setLifecycleState(LifecycleState.STOPPED);
                if (api.getVisibility() == null) {
                    repoApi.setVisibility(io.gravitee.repository.management.model.Visibility.PRIVATE);
                } else {
                    repoApi.setVisibility(io.gravitee.repository.management.model.Visibility.valueOf((String)api.getVisibility().toString()));
                }
                Set defaultGroups = this.groupService.findByEvent(GroupEvent.API_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
                if (!defaultGroups.isEmpty() && repoApi.getGroups() == null) {
                    repoApi.setGroups(defaultGroups);
                } else if (!defaultGroups.isEmpty()) {
                    repoApi.getGroups().addAll(defaultGroups);
                }
                io.gravitee.repository.management.model.Api createdApi = (io.gravitee.repository.management.model.Api)this.apiRepository.create((Object)repoApi);
                this.auditService.createApiAuditLog(createdApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_CREATED, createdApi.getCreatedAt(), null, createdApi);
                UserEntity primaryOwner = this.userService.findById(userId);
                Membership membership = new Membership(primaryOwner.getId(), createdApi.getId(), MembershipReferenceType.API);
                membership.setRoles(Collections.singletonMap(RoleScope.API.getId(), SystemRole.PRIMARY_OWNER.name()));
                membership.setCreatedAt(repoApi.getCreatedAt());
                membership.setUpdatedAt(repoApi.getCreatedAt());
                this.membershipRepository.create(membership);
                if (primaryOwner.getEmail() != null && !primaryOwner.getEmail().isEmpty()) {
                    GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
                    notificationConfigEntity.setName("Default Mail Notifications");
                    notificationConfigEntity.setReferenceType(HookScope.API.name());
                    notificationConfigEntity.setReferenceId(createdApi.getId());
                    notificationConfigEntity.setHooks(Arrays.stream(ApiHook.values()).map(Enum::name).collect(Collectors.toList()));
                    notificationConfigEntity.setNotifier("default-email");
                    notificationConfigEntity.setConfig(primaryOwner.getEmail());
                    this.genericNotificationConfigService.create(notificationConfigEntity);
                }
                ApiEntity apiEntity = this.convert(createdApi, primaryOwner);
                this.searchEngineService.index((Indexable)apiEntity);
                return apiEntity;
            }
            LOGGER.error("Unable to create API {} because of previous error.", (Object)api.getName());
            throw new TechnicalManagementException("Unable to create API " + api.getName());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to create {} for user {}", new Object[]{api, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + api + " for user " + userId, ex);
        }
    }

    @Override
    public void checkContextPath(String newContextPath) throws TechnicalException {
        this.checkContextPath(newContextPath, null);
    }

    private void checkContextPath(String newContextPath, String apiId) throws TechnicalException {
        if (newContextPath.charAt(0) != '/') {
            newContextPath = '/' + newContextPath;
        }
        if (newContextPath.charAt(newContextPath.length() - 1) == '/') {
            newContextPath = newContextPath.substring(0, newContextPath.length() - 1);
        }
        int indexOfEndOfNewSubContextPath = newContextPath.lastIndexOf(47, 1);
        String newSubContextPath = newContextPath.substring(0, indexOfEndOfNewSubContextPath <= 0 ? newContextPath.length() : indexOfEndOfNewSubContextPath) + '/';
        boolean contextPathExists = this.apiRepository.search(null).stream().filter(api -> !api.getId().equals(apiId)).anyMatch(api -> {
            String contextPath = this.convert((io.gravitee.repository.management.model.Api)api, null).getProxy().getContextPath();
            int indexOfEndOfSubContextPath = contextPath.lastIndexOf(47, 1);
            String subContextPath = contextPath.substring(0, indexOfEndOfSubContextPath <= 0 ? contextPath.length() : indexOfEndOfSubContextPath) + '/';
            return subContextPath.startsWith(newSubContextPath) || newSubContextPath.startsWith(subContextPath);
        });
        if (contextPathExists) {
            throw new ApiContextPathAlreadyExistsException(newSubContextPath);
        }
    }

    private void checkEndpointsName(UpdateApiEntity api) {
        if (api.getProxy() != null && api.getProxy().getGroups() != null) {
            for (EndpointGroup group : api.getProxy().getGroups()) {
                this.assertEndpointNameNotContainsInvalidCharacters(group.getName());
                if (group.getEndpoints() == null) continue;
                for (Endpoint endpoint : group.getEndpoints()) {
                    this.assertEndpointNameNotContainsInvalidCharacters(endpoint.getName());
                }
            }
        }
    }

    private void assertEndpointNameNotContainsInvalidCharacters(String name) {
        if (name != null && name.contains(":")) {
            throw new EndpointNameInvalidException(name);
        }
    }

    private void addLoggingMaxDuration(Logging logging) {
        Optional optionalMaxDuration;
        if (logging != null && !LoggingMode.NONE.equals((Object)logging.getMode()) && (optionalMaxDuration = this.parameterService.findAll(Key.LOGGING_DEFAULT_MAX_DURATION, Long::valueOf).stream().findFirst()).isPresent() && (Long)optionalMaxDuration.get() > 0L) {
            long maxEndDate = System.currentTimeMillis() + (Long)optionalMaxDuration.get();
            if (logging.getCondition() == null || logging.getCondition().isEmpty()) {
                logging.setCondition(String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate));
            } else {
                Matcher matcher = LOGGING_MAX_DURATION_PATTERN.matcher(logging.getCondition());
                if (matcher.matches()) {
                    String currentDurationAsStr = matcher.group("timestamp");
                    String before = matcher.group("before");
                    String after = matcher.group("after");
                    try {
                        Long currentDuration = Long.valueOf(currentDurationAsStr);
                        if (currentDuration > maxEndDate) {
                            logging.setCondition(before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.error("Wrong format of the logging condition. Add the default one", (Throwable)nfe);
                        logging.setCondition(before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after);
                    }
                } else {
                    logging.setCondition(String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + " && " + logging.getCondition());
                }
            }
        }
    }

    @Override
    public ApiEntity findById(String apiId) {
        try {
            LOGGER.debug("Find API by ID: {}", (Object)apiId);
            Optional api = this.apiRepository.findById((Object)apiId);
            if (api.isPresent()) {
                Optional primaryOwnerMembership = this.membershipRepository.findByReferenceAndRole(MembershipReferenceType.API, ((io.gravitee.repository.management.model.Api)api.get()).getId(), RoleScope.API, SystemRole.PRIMARY_OWNER.name()).stream().findFirst();
                if (!primaryOwnerMembership.isPresent()) {
                    LOGGER.error("The API {} doesn't have any primary owner.", (Object)apiId);
                    throw new TechnicalException("The API " + apiId + " doesn't have any primary owner.");
                }
                return this.convert((io.gravitee.repository.management.model.Api)api.get(), this.userService.findById(((Membership)primaryOwnerMembership.get()).getUserId()));
            }
            throw new ApiNotFoundException(apiId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    @Override
    public Set<ApiEntity> findByVisibility(Visibility visibility) {
        try {
            LOGGER.debug("Find APIs by visibility {}", (Object)visibility);
            return this.convert(this.apiRepository.search(new ApiCriteria.Builder().visibility(io.gravitee.repository.management.model.Visibility.valueOf((String)visibility.name())).build()));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find all APIs", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs", ex);
        }
    }

    @Override
    public Set<ApiEntity> findAll() {
        try {
            LOGGER.debug("Find all APIs");
            return this.convert(this.apiRepository.search(null));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find all APIs", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs", ex);
        }
    }

    @Override
    public Set<ApiEntity> findAllLight() {
        try {
            LOGGER.debug("Find all APIs without some fields (definition, picture...)");
            return this.convert(this.apiRepository.search(null, new ApiFieldExclusionFilter.Builder().excludeDefinition().excludePicture().build()));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find all APIs light", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs light", ex);
        }
    }

    @Override
    public Set<ApiEntity> findByUser(String userId, ApiQuery apiQuery) {
        try {
            LOGGER.debug("Find APIs by user {}", (Object)userId);
            List publicApis = this.apiRepository.search(this.queryToCriteria(apiQuery).visibility(io.gravitee.repository.management.model.Visibility.PUBLIC).build());
            List userApis = Collections.emptyList();
            String[] userApiIds = (String[])this.membershipRepository.findByUserAndReferenceType(userId, MembershipReferenceType.API).stream().map(Membership::getReferenceId).toArray(String[]::new);
            if (userApiIds.length > 0) {
                userApis = this.apiRepository.search(this.queryToCriteria(apiQuery).ids(userApiIds).build());
            }
            List groupApis = Collections.emptyList();
            String[] groupIds = (String[])this.membershipRepository.findByUserAndReferenceType(userId, MembershipReferenceType.GROUP).stream().filter(m -> m.getRoles().keySet().contains(RoleScope.API.getId())).map(Membership::getReferenceId).toArray(String[]::new);
            if (groupIds.length > 0 && groupIds[0] != null) {
                groupApis = this.apiRepository.search(this.queryToCriteria(apiQuery).groups(groupIds).build());
            }
            HashSet<ApiEntity> apis = new HashSet<ApiEntity>(publicApis.size() + userApis.size() + groupApis.size());
            apis.addAll(this.convert(publicApis));
            apis.addAll(this.convert(userApis));
            apis.addAll(this.convert(groupApis));
            return apis;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find APIs for user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find APIs for user " + userId, ex);
        }
    }

    @Override
    public ApiEntity update(String apiId, UpdateApiEntity updateApiEntity) {
        try {
            LOGGER.debug("Update API {}", (Object)apiId);
            Optional optApiToUpdate = this.apiRepository.findById((Object)apiId);
            if (!optApiToUpdate.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            this.checkShardingTags(updateApiEntity, this.convert((io.gravitee.repository.management.model.Api)optApiToUpdate.get()));
            this.checkContextPath(updateApiEntity.getProxy().getContextPath(), apiId);
            this.checkEndpointsName(updateApiEntity);
            this.addLoggingMaxDuration(updateApiEntity.getProxy().getLogging());
            if (updateApiEntity.getGroups() != null && !updateApiEntity.getGroups().isEmpty()) {
                try {
                    this.groupService.findByIds(updateApiEntity.getGroups());
                }
                catch (GroupsNotFoundException gnfe) {
                    throw new InvalidDataException("Groups [" + updateApiEntity.getGroups() + "] does not exist");
                }
            }
            io.gravitee.repository.management.model.Api apiToUpdate = (io.gravitee.repository.management.model.Api)optApiToUpdate.get();
            io.gravitee.repository.management.model.Api api = this.convert(apiId, updateApiEntity);
            if (api != null) {
                api.setId(apiId.trim());
                api.setUpdatedAt(new Date());
                api.setDeployedAt(apiToUpdate.getDeployedAt());
                api.setCreatedAt(apiToUpdate.getCreatedAt());
                api.setLifecycleState(apiToUpdate.getLifecycleState());
                if (updateApiEntity.getPicture() == null) {
                    api.setPicture(apiToUpdate.getPicture());
                }
                if (updateApiEntity.getGroups() == null) {
                    api.setGroups(apiToUpdate.getGroups());
                }
                if (updateApiEntity.getLabels() == null) {
                    api.setLabels(apiToUpdate.getLabels());
                }
                if (updateApiEntity.getViews() == null) {
                    api.setViews(apiToUpdate.getViews());
                }
                io.gravitee.repository.management.model.Api updatedApi = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
                this.auditService.createApiAuditLog(updatedApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, updatedApi.getUpdatedAt(), apiToUpdate, updatedApi);
                if (this.parameterService.findAsBoolean(Key.LOGGING_AUDIT_TRAIL_ENABLED)) {
                    this.auditApiLogging(apiToUpdate, updatedApi);
                }
                ApiEntity apiEntity = this.convert(Collections.singletonList(updatedApi)).iterator().next();
                this.searchEngineService.index((Indexable)apiEntity);
                return apiEntity;
            }
            LOGGER.error("Unable to update API {} because of previous error.", (Object)api.getId());
            throw new TechnicalManagementException("Unable to update API " + apiId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to update API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update API " + apiId, ex);
        }
    }

    private void checkShardingTags(UpdateApiEntity updateApiEntity, ApiEntity existingAPI) {
        if (!this.isAdmin()) {
            Set<String> userTags;
            Set<Object> updatedTags;
            Set tagsToUpdate;
            Set set = tagsToUpdate = updateApiEntity.getTags() == null ? new HashSet() : updateApiEntity.getTags();
            if (existingAPI == null) {
                updatedTags = tagsToUpdate;
            } else {
                Set existingAPITags = existingAPI.getTags() == null ? new HashSet() : existingAPI.getTags();
                updatedTags = existingAPITags.stream().filter(tag -> !tagsToUpdate.contains(tag)).collect(Collectors.toSet());
                updatedTags.addAll(tagsToUpdate.stream().filter(tag -> !existingAPITags.contains(tag)).collect(Collectors.toSet()));
            }
            if (updatedTags != null && !updatedTags.isEmpty() && !(userTags = this.tagService.findByUser(this.getAuthenticatedUsername())).containsAll(updatedTags)) {
                String[] notAllowedTags = (String[])updatedTags.stream().filter(tag -> !userTags.contains(tag)).toArray(String[]::new);
                throw new TagNotAllowedException(notAllowedTags);
            }
        }
    }

    @Override
    public void delete(String apiId) {
        try {
            LOGGER.debug("Delete API {}", (Object)apiId);
            Optional optApi = this.apiRepository.findById((Object)apiId);
            if (!optApi.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            if (((io.gravitee.repository.management.model.Api)optApi.get()).getLifecycleState() == LifecycleState.STARTED) {
                throw new ApiRunningStateException(apiId);
            }
            Set<PlanEntity> plans = this.planService.findByApi(apiId);
            Set plansNotClosed = plans.stream().filter(plan -> plan.getStatus() == PlanStatus.PUBLISHED).map(PlanEntity::getName).collect(Collectors.toSet());
            if (!plansNotClosed.isEmpty()) {
                throw new ApiNotDeletableException("Plan(s) [" + String.join((CharSequence)", ", plansNotClosed) + "] must be closed before being able to delete the API !");
            }
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApi(apiId);
            subscriptions.forEach(sub -> this.subscriptionService.delete(sub.getId()));
            for (PlanEntity plan2 : plans) {
                this.planService.delete(plan2.getId());
            }
            EventQuery query = new EventQuery();
            query.setApi(apiId);
            this.eventService.search(query).forEach(event -> this.eventService.delete(event.getId()));
            this.apiRepository.delete((Object)apiId);
            this.topApiService.delete(apiId);
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_DELETED, new Date(), optApi.get(), null);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity start(String apiId, String userId) {
        try {
            LOGGER.debug("Start API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(apiId, LifecycleState.STARTED, userId);
            this.notifierService.trigger(ApiHook.API_STARTED, apiId, new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to start API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to start API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity stop(String apiId, String userId) {
        try {
            LOGGER.debug("Stop API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(apiId, LifecycleState.STOPPED, userId);
            this.notifierService.trigger(ApiHook.API_STOPPED, apiId, new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to stop API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to stop API " + apiId, ex);
        }
    }

    @Override
    public boolean isSynchronized(String apiId) {
        try {
            ApiEntity api = this.findById(apiId);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(Event.EventProperties.API_ID.getValue(), apiId);
            Page<EventEntity> events = this.eventService.search(Arrays.asList(EventType.PUBLISH_API, EventType.UNPUBLISH_API), properties, 0L, 0L, 0, 1);
            if (!events.getContent().isEmpty()) {
                EventEntity lastEvent = (EventEntity)events.getContent().get(0);
                boolean enabled = this.objectMapper.getDeserializationConfig().isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                io.gravitee.repository.management.model.Api payloadEntity = (io.gravitee.repository.management.model.Api)this.objectMapper.readValue(lastEvent.getPayload(), io.gravitee.repository.management.model.Api.class);
                this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, enabled);
                ApiEntity deployedApi = this.convert(payloadEntity);
                this.removeDescriptionFromPolicies(api);
                this.removeDescriptionFromPolicies(deployedApi);
                boolean sync = this.apiSynchronizationProcessor.processCheckSynchronization(deployedApi, api);
                if (sync) {
                    Set<PlanEntity> plans = this.planService.findByApi(api.getId());
                    sync = plans.stream().filter(plan -> plan.getStatus() != PlanStatus.STAGING).filter(plan -> plan.getNeedRedeployAt().after(api.getDeployedAt())).count() == 0L;
                }
                return sync;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to check API synchronization state {}", (Object)apiId, (Object)e);
        }
        return false;
    }

    private void removeDescriptionFromPolicies(ApiEntity api) {
        if (api.getPaths() != null) {
            api.getPaths().forEach((s, path) -> {
                if (path.getRules() != null) {
                    path.getRules().forEach(rule -> rule.setDescription(""));
                }
            });
        }
    }

    @Override
    public ApiEntity deploy(String apiId, String userId, EventType eventType) {
        try {
            LOGGER.debug("Deploy API : {}", (Object)apiId);
            return this.deployCurrentAPI(apiId, userId, eventType);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to deploy API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to deploy API: " + apiId, ex);
        }
    }

    @Override
    public ApiEntity rollback(String apiId, UpdateApiEntity api) {
        LOGGER.debug("Rollback API : {}", (Object)apiId);
        try {
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_ROLLBACKED, new Date(), null, null);
            return this.update(apiId, api);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to rollback API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to rollback API: " + apiId, ex);
        }
    }

    private ApiEntity deployCurrentAPI(String apiId, String userId, EventType eventType) throws Exception {
        Optional api = this.apiRepository.findById((Object)apiId);
        if (api.isPresent()) {
            io.gravitee.repository.management.model.Api apiValue = (io.gravitee.repository.management.model.Api)api.get();
            apiValue.setUpdatedAt(new Date());
            apiValue.setDeployedAt(apiValue.getUpdatedAt());
            apiValue = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)apiValue);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.API_ID.getValue(), apiValue.getId());
            properties.put(Event.EventProperties.USER.getValue(), userId);
            apiValue.setPicture(null);
            this.eventService.create(eventType, this.objectMapper.writeValueAsString((Object)apiValue), properties);
            return this.convert(Collections.singletonList(apiValue)).iterator().next();
        }
        throw new ApiNotFoundException(apiId);
    }

    private ApiEntity deployLastPublishedAPI(String apiId, String userId, EventType eventType) throws TechnicalException {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(EventType.PUBLISH_API));
        Optional<EventEntity> optEvent = this.eventService.search(query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        try {
            if (optEvent.isPresent()) {
                EventEntity event = optEvent.get();
                JsonNode node = this.objectMapper.readTree(event.getPayload());
                io.gravitee.repository.management.model.Api lastPublishedAPI = (io.gravitee.repository.management.model.Api)this.objectMapper.convertValue((Object)node, io.gravitee.repository.management.model.Api.class);
                lastPublishedAPI.setLifecycleState(this.convert(eventType));
                lastPublishedAPI.setUpdatedAt(new Date());
                lastPublishedAPI.setDeployedAt(new Date());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.API_ID.getValue(), lastPublishedAPI.getId());
                properties.put(Event.EventProperties.USER.getValue(), userId);
                lastPublishedAPI.setPicture(null);
                this.eventService.create(eventType, this.objectMapper.writeValueAsString((Object)lastPublishedAPI), properties);
                return null;
            }
            return this.deploy(apiId, userId, EventType.PUBLISH_API);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to deploy last published API {}", (Object)apiId, (Object)e);
            throw new TechnicalException("An error occurs while trying to deploy last published API " + apiId, (Throwable)e);
        }
    }

    @Override
    public String exportAsJson(String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.findById(apiId);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        try {
            return this.objectMapper.writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public ApiEntity createOrUpdateWithDefinition(ApiEntity apiEntity, String apiDefinition, String userId) {
        try {
            JsonNode plansDefinition;
            JsonNode pagesDefinition;
            UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(apiDefinition, UpdateApiEntity.class);
            if (importedApi.getPaths() == null || importedApi.getPaths().isEmpty()) {
                Path path = new Path();
                path.setPath("/");
                importedApi.setPaths(Collections.singletonMap("/", path));
            }
            if (importedApi.getGroups() != null) {
                HashSet groupNames = new HashSet(importedApi.getGroups());
                importedApi.getGroups().clear();
                for (String name : groupNames) {
                    GroupEntity group;
                    List<GroupEntity> groupEntities = this.groupService.findByName(name);
                    if (groupEntities.isEmpty()) {
                        NewGroupEntity newGroupEntity = new NewGroupEntity();
                        newGroupEntity.setName(name);
                        group = this.groupService.create(newGroupEntity);
                    } else {
                        group = groupEntities.get(0);
                    }
                    importedApi.getGroups().add(group.getId());
                }
            }
            ApiEntity createdOrUpdatedApiEntity = apiEntity == null || apiEntity.getId() == null ? this.create0(importedApi, userId) : this.update(apiEntity.getId(), importedApi);
            JsonNode jsonNode = this.objectMapper.readTree(apiDefinition);
            JsonNode membersToImport = jsonNode.path("members");
            if (membersToImport != null && membersToImport.isArray()) {
                Set membersAlreadyPresent = this.membershipService.getMembers(MembershipReferenceType.API, createdOrUpdatedApiEntity.getId(), RoleScope.API).stream().map(member -> {
                    UserEntity userEntity = this.userService.findById(member.getId());
                    return new MemberToImport(userEntity.getSource(), userEntity.getSourceId(), member.getRole());
                }).collect(Collectors.toSet());
                MemberToImport currentPo = membersAlreadyPresent.stream().filter(memberToImport -> SystemRole.PRIMARY_OWNER.name().equals(memberToImport.getRole())).findFirst().orElse(new MemberToImport());
                String roleUsedInTransfert = null;
                MemberToImport futurePO = null;
                for (JsonNode memberNode : membersToImport) {
                    MemberToImport memberToImport2 = (MemberToImport)this.objectMapper.readValue(memberNode.toString(), MemberToImport.class);
                    boolean presentWithSameRole = membersAlreadyPresent.stream().anyMatch(m -> m.getRole().equals(memberToImport2.getRole()) && m.getSourceId().equals(memberToImport2.getSourceId()) && m.getSource().equals(memberToImport2.getSource()));
                    if (!(presentWithSameRole || SystemRole.PRIMARY_OWNER.name().equals(memberToImport2.getRole()) || memberToImport2.getSourceId().equals(currentPo.getSourceId()) && memberToImport2.getSource().equals(currentPo.getSource()))) {
                        try {
                            UserEntity userEntity = this.userService.findBySource(memberToImport2.getSource(), memberToImport2.getSourceId(), false);
                            this.membershipService.addOrUpdateMember(new MembershipService.MembershipReference(MembershipReferenceType.API, createdOrUpdatedApiEntity.getId()), new MembershipService.MembershipUser(userEntity.getId(), null), new MembershipService.MembershipRole(RoleScope.API, memberToImport2.getRole()));
                        }
                        catch (UserNotFoundException userNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (currentPo.getSourceId().equals(memberToImport2.getSourceId()) && currentPo.getSource().equals(memberToImport2.getSource()) && !SystemRole.PRIMARY_OWNER.name().equals(memberToImport2.getRole())) {
                        roleUsedInTransfert = memberToImport2.getRole();
                    }
                    if (!SystemRole.PRIMARY_OWNER.name().equals(memberToImport2.getRole())) continue;
                    futurePO = memberToImport2;
                }
                if (!(futurePO == null || currentPo.getSource().equals(futurePO.getSource()) && currentPo.getSourceId().equals(futurePO.getSourceId()))) {
                    try {
                        UserEntity userEntity = this.userService.findBySource(futurePO.getSource(), futurePO.getSourceId(), false);
                        RoleEntity roleEntity = null;
                        if (roleUsedInTransfert != null) {
                            roleEntity = new RoleEntity();
                            roleEntity.setName(roleUsedInTransfert);
                            roleEntity.setScope(io.gravitee.management.model.permissions.RoleScope.API);
                        }
                        this.membershipService.transferApiOwnership(createdOrUpdatedApiEntity.getId(), new MembershipService.MembershipUser(userEntity.getId(), null), roleEntity);
                    }
                    catch (UserNotFoundException userEntity) {
                        // empty catch block
                    }
                }
            }
            if ((pagesDefinition = jsonNode.path("pages")) != null && pagesDefinition.isArray()) {
                for (JsonNode pageNode : pagesDefinition) {
                    PageQuery query = new PageQuery.Builder().api(createdOrUpdatedApiEntity.getId()).name(pageNode.get("name").asText()).type(PageType.valueOf((String)pageNode.get("type").asText())).build();
                    List<PageEntity> pageEntities = this.pageService.search(query);
                    if (pageEntities == null || pageEntities.isEmpty()) {
                        this.pageService.createPage(createdOrUpdatedApiEntity.getId(), (NewPageEntity)this.objectMapper.readValue(pageNode.toString(), NewPageEntity.class));
                        continue;
                    }
                    if (pageEntities.size() == 1) {
                        UpdatePageEntity updatePageEntity = (UpdatePageEntity)this.objectMapper.readValue(pageNode.toString(), UpdatePageEntity.class);
                        this.pageService.update(pageEntities.get(0).getId(), updatePageEntity);
                        continue;
                    }
                    LOGGER.error("Not able to identify the page to update: {}. Too much page with the same name", (Object)pageNode.get("name").asText());
                    throw new TechnicalManagementException("Not able to identify the page to update: " + pageNode.get("name").asText() + ". Too much page with the same name");
                }
            }
            if ((plansDefinition = jsonNode.path("plans")) != null && plansDefinition.isArray()) {
                for (JsonNode planNode : plansDefinition) {
                    PlanQuery query = new PlanQuery.Builder().api(createdOrUpdatedApiEntity.getId()).name(planNode.get("name").asText()).security(PlanSecurityType.valueOf((String)planNode.get("security").asText())).build();
                    List<PlanEntity> planEntities = this.planService.search(query);
                    if (planEntities == null || planEntities.isEmpty()) {
                        NewPlanEntity newPlanEntity = (NewPlanEntity)this.objectMapper.readValue(planNode.toString(), NewPlanEntity.class);
                        newPlanEntity.setApi(createdOrUpdatedApiEntity.getId());
                        this.planService.create(newPlanEntity);
                        continue;
                    }
                    if (planEntities.size() == 1) {
                        UpdatePlanEntity updatePlanEntity = (UpdatePlanEntity)this.objectMapper.readValue(planNode.toString(), UpdatePlanEntity.class);
                        updatePlanEntity.setId(planEntities.iterator().next().getId());
                        this.planService.update(updatePlanEntity);
                        continue;
                    }
                    LOGGER.error("Not able to identify the plan to update: {}. Too much plan with the same name", (Object)planNode.get("name").asText());
                    throw new TechnicalManagementException("Not able to identify the plan to update: " + planNode.get("name").asText() + ". Too much plan with the same name");
                }
            }
            return createdOrUpdatedApiEntity;
        }
        catch (IOException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            return null;
        }
    }

    @Override
    public InlinePictureEntity getPicture(String apiId) {
        ApiEntity apiEntity = this.findById(apiId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (apiEntity.getPicture() == null) {
            imageEntity.setType("image/png");
            imageEntity.setContent(this.getDefaultPicture());
        } else {
            String[] parts = apiEntity.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = apiEntity.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public byte[] getDefaultPicture() {
        try {
            return IOUtils.toByteArray((InputStream)new FileInputStream(this.defaultIcon));
        }
        catch (IOException ioe) {
            LOGGER.error("Default icon for API does not exist", (Throwable)ioe);
            return null;
        }
    }

    @Override
    public void deleteViewFromAPIs(String viewId) {
        this.findAll().forEach(api -> {
            if (api.getViews() != null && api.getViews().contains(viewId)) {
                this.removeView(api.getId(), viewId);
            }
        });
    }

    private void removeView(String apiId, String viewId) throws TechnicalManagementException {
        try {
            Optional optApi = this.apiRepository.findById((Object)apiId);
            if (!optApi.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)optApi.get();
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            api.getViews().remove(viewId);
            api.setUpdatedAt(new Date());
            this.apiRepository.update((Object)api);
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while removing view from API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while removing view from API: " + apiId, ex);
        }
    }

    @Override
    public void deleteTagFromAPIs(String tagId) {
        this.findAll().forEach(api -> {
            if (api.getTags() != null && api.getTags().contains(tagId)) {
                this.removeTag(api.getId(), tagId);
            }
        });
    }

    @Override
    public ApiModelEntity findByIdForTemplates(String apiId) {
        ApiEntity apiEntity = this.findById(apiId);
        ApiModelEntity apiModelEntity = new ApiModelEntity();
        apiModelEntity.setId(apiEntity.getId());
        apiModelEntity.setName(apiEntity.getName());
        apiModelEntity.setDescription(apiEntity.getDescription());
        apiModelEntity.setCreatedAt(apiEntity.getCreatedAt());
        apiModelEntity.setDeployedAt(apiEntity.getDeployedAt());
        apiModelEntity.setUpdatedAt(apiEntity.getUpdatedAt());
        apiModelEntity.setGroups(apiEntity.getGroups());
        apiModelEntity.setVisibility(apiEntity.getVisibility());
        apiModelEntity.setViews(apiEntity.getViews());
        apiModelEntity.setVersion(apiEntity.getVersion());
        apiModelEntity.setState(apiEntity.getState());
        apiModelEntity.setTags(apiEntity.getTags());
        apiModelEntity.setServices(apiEntity.getServices());
        apiModelEntity.setPaths(apiEntity.getPaths());
        apiModelEntity.setPicture(apiEntity.getPicture());
        apiModelEntity.setPrimaryOwner(apiEntity.getPrimaryOwner());
        apiModelEntity.setProperties(apiEntity.getProperties());
        apiModelEntity.setProxy(apiEntity.getProxy());
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(apiId);
        if (metadataList != null) {
            HashMap mapMetadata = new HashMap(metadataList.size());
            metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue() == null ? metadata.getDefaultValue() : metadata.getValue()));
            apiModelEntity.setMetadata(mapMetadata);
        }
        return apiModelEntity;
    }

    @Override
    public boolean exists(String apiId) {
        try {
            return this.apiRepository.findById((Object)apiId).isPresent();
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while checking if the API exists: " + apiId;
            LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    @Override
    public ApiEntity importPathMappingsFromPage(ApiEntity apiEntity, String page) {
        PageEntity pageEntity = this.pageService.findById(page);
        if (PageType.SWAGGER.name().equals(pageEntity.getType())) {
            ImportSwaggerDescriptorEntity importSwaggerDescriptorEntity = new ImportSwaggerDescriptorEntity();
            importSwaggerDescriptorEntity.setPayload(pageEntity.getContent());
            NewSwaggerApiEntity newSwaggerApiEntity = this.swaggerService.prepare(importSwaggerDescriptorEntity);
            apiEntity.getPathMappings().addAll(newSwaggerApiEntity.getPaths().stream().map(SwaggerPath::getPath).collect(Collectors.toList()));
        }
        return this.update(apiEntity.getId(), ApiService.convert(apiEntity));
    }

    @Override
    public Collection<ApiEntity> search(ApiQuery query) {
        try {
            LOGGER.debug("Search APIs by {}", (Object)query);
            return this.convert(this.apiRepository.search(this.queryToCriteria(query).build())).stream().filter(api -> query.getTag() == null || api.getTags() != null && api.getTags().contains(query.getTag())).filter(api -> query.getContextPath() == null || query.getContextPath().equals(api.getProxy().getContextPath())).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String errorMessage = "An error occurs while trying to search for APIs: " + query;
            LOGGER.error(errorMessage, (Throwable)ex);
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    @Override
    public Collection<ApiEntity> search(String query, Map<String, Object> filters) {
        Query<ApiEntity> apiQuery = QueryBuilder.create(ApiEntity.class).setQuery(query).setFilters(filters).build();
        SearchResult matchApis = this.searchEngineService.search(apiQuery);
        return matchApis.getDocuments().stream().map(this::findById).collect(Collectors.toList());
    }

    @Override
    public List<ApiHeaderEntity> getPortalHeaders(String apiId) {
        List<ApiHeaderEntity> entities = this.apiHeaderService.findAll();
        ApiModelEntity apiEntity = this.findByIdForTemplates(apiId);
        HashMap<String, ApiModelEntity> model = new HashMap<String, ApiModelEntity>();
        model.put("api", apiEntity);
        entities.forEach(entity -> {
            if (entity.getValue().contains("${")) {
                try {
                    Template template = new Template(entity.getId() + entity.getUpdatedAt().toString(), entity.getValue(), this.freemarkerConfiguration);
                    entity.setValue(FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model));
                }
                catch (TemplateException | IOException e) {
                    LOGGER.error("Unable to apply templating on api headers ", e);
                    throw new TechnicalManagementException("Unable to apply templating on api headers", e);
                }
            }
        });
        return entities;
    }

    private ApiCriteria.Builder queryToCriteria(ApiQuery query) {
        ApiCriteria.Builder builder = new ApiCriteria.Builder();
        if (query == null) {
            return builder;
        }
        builder.label(query.getLabel()).name(query.getName()).version(query.getVersion()).view(query.getView());
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            builder.groups(query.getGroups().toArray(new String[0]));
        }
        if (!StringUtils.isBlank((CharSequence)query.getState())) {
            builder.state(LifecycleState.valueOf((String)query.getState()));
        }
        if (query.getVisibility() != null) {
            builder.visibility(io.gravitee.repository.management.model.Visibility.valueOf((String)query.getVisibility().name()));
        }
        return builder;
    }

    private void removeTag(String apiId, String tagId) throws TechnicalManagementException {
        try {
            ApiEntity apiEntity = this.findById(apiId);
            apiEntity.getTags().remove(tagId);
            this.update(apiId, ApiService.convert(apiEntity));
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while removing tag from API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while removing tag from API: " + apiId, ex);
        }
    }

    private ApiEntity updateLifecycle(String apiId, LifecycleState lifecycleState, String username) throws TechnicalException {
        Optional optApi = this.apiRepository.findById((Object)apiId);
        if (optApi.isPresent()) {
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)optApi.get();
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            api.setUpdatedAt(new Date());
            api.setLifecycleState(lifecycleState);
            ApiEntity apiEntity = this.convert((io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api));
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
            EventType eventType = null;
            switch (lifecycleState) {
                case STARTED: {
                    eventType = EventType.START_API;
                    break;
                }
                case STOPPED: {
                    eventType = EventType.STOP_API;
                    break;
                }
            }
            ApiEntity deployedApi = this.deployLastPublishedAPI(apiId, username, eventType);
            if (deployedApi != null) {
                return deployedApi;
            }
            return apiEntity;
        }
        throw new ApiNotFoundException(apiId);
    }

    private void auditApiLogging(io.gravitee.repository.management.model.Api apiToUpdate, io.gravitee.repository.management.model.Api apiUpdated) {
        try {
            Api apiToUpdateDefinition = (Api)this.objectMapper.readValue(apiToUpdate.getDefinition(), Api.class);
            Logging loggingToUpdate = apiToUpdateDefinition.getProxy().getLogging();
            Api apiUpdatedDefinition = (Api)this.objectMapper.readValue(apiUpdated.getDefinition(), Api.class);
            Logging loggingUpdated = apiUpdatedDefinition.getProxy().getLogging();
            if (loggingToUpdate == loggingUpdated || loggingToUpdate != null && loggingUpdated != null && Objects.equals(loggingToUpdate.getMode(), loggingUpdated.getMode()) && Objects.equals(loggingToUpdate.getCondition(), loggingUpdated.getCondition())) {
                return;
            }
            Api.AuditEvent auditEvent = (loggingToUpdate == null || loggingToUpdate.getMode().equals((Object)LoggingMode.NONE)) && !loggingUpdated.getMode().equals((Object)LoggingMode.NONE) ? Api.AuditEvent.API_LOGGING_ENABLED : (loggingToUpdate != null && !loggingToUpdate.getMode().equals((Object)LoggingMode.NONE) && loggingUpdated.getMode().equals((Object)LoggingMode.NONE) ? Api.AuditEvent.API_LOGGING_DISABLED : Api.AuditEvent.API_LOGGING_UPDATED);
            this.auditService.createApiAuditLog(apiUpdated.getId(), Collections.emptyMap(), (Audit.AuditEvent)auditEvent, new Date(), loggingToUpdate, loggingUpdated);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while auditing API logging configuration for API: {}", (Object)apiUpdated.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while auditing API logging configuration for API: " + apiUpdated.getId(), ex);
        }
    }

    private Set<ApiEntity> convert(List<io.gravitee.repository.management.model.Api> apis) throws TechnicalException {
        if (apis == null || apis.isEmpty()) {
            return Collections.emptySet();
        }
        Set memberships = this.membershipRepository.findByReferencesAndRole(MembershipReferenceType.API, apis.stream().map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toList()), RoleScope.API, SystemRole.PRIMARY_OWNER.name());
        int poMissing = apis.size() - memberships.size();
        Set apiIds = apis.stream().map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toSet());
        Stream<Object> streamApis = apis.stream();
        if (poMissing > 0) {
            Set apiMembershipsIds = memberships.stream().map(Membership::getReferenceId).collect(Collectors.toSet());
            apiIds.removeAll(apiMembershipsIds);
            Optional optionalApisAsString = apiIds.stream().reduce((a, b) -> a + " / " + b);
            String apisAsString = "?";
            if (optionalApisAsString.isPresent()) {
                apisAsString = (String)optionalApisAsString.get();
            }
            LOGGER.error("{} apis has no identified primary owners in this list {}.", (Object)poMissing, (Object)apisAsString);
            streamApis = streamApis.filter(api -> !apiIds.contains(api.getId()));
        }
        HashMap apiToUser = new HashMap(memberships.size());
        memberships.forEach(membership -> apiToUser.put(membership.getReferenceId(), membership.getUserId()));
        HashMap userIdToUserEntity = new HashMap(memberships.size());
        this.userService.findByIds(memberships.stream().map(Membership::getUserId).collect(Collectors.toList())).forEach(userEntity -> userIdToUserEntity.put(userEntity.getId(), userEntity));
        return streamApis.map(publicApi -> this.convert((io.gravitee.repository.management.model.Api)publicApi, (UserEntity)userIdToUserEntity.get(apiToUser.get(publicApi.getId())))).collect(Collectors.toSet());
    }

    private ApiEntity convert(io.gravitee.repository.management.model.Api api) {
        return this.convert(api, null);
    }

    private ApiEntity convert(io.gravitee.repository.management.model.Api api, UserEntity primaryOwner) {
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setName(api.getName());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        apiEntity.setGroups(api.getGroups());
        if (api.getDefinition() != null) {
            try {
                Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.setPaths(apiDefinition.getPaths());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                if (apiDefinition.getPathMappings() != null) {
                    apiEntity.setPathMappings(new HashSet(apiDefinition.getPathMappings().keySet()));
                }
                apiEntity.setResponseTemplates(apiDefinition.getResponseTemplates());
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setVersion(api.getVersion());
        apiEntity.setDescription(api.getDescription());
        apiEntity.setPicture(api.getPicture());
        apiEntity.setViews(api.getViews());
        apiEntity.setLabels(api.getLabels());
        LifecycleState lifecycleState = api.getLifecycleState();
        if (lifecycleState != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)lifecycleState.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if (primaryOwner != null) {
            apiEntity.setPrimaryOwner(new PrimaryOwnerEntity(primaryOwner));
        }
        return apiEntity;
    }

    private io.gravitee.repository.management.model.Api convert(String apiId, UpdateApiEntity updateApiEntity) {
        io.gravitee.repository.management.model.Api api = new io.gravitee.repository.management.model.Api();
        if (updateApiEntity.getVisibility() != null) {
            api.setVisibility(io.gravitee.repository.management.model.Visibility.valueOf((String)updateApiEntity.getVisibility().toString()));
        }
        api.setVersion(updateApiEntity.getVersion().trim());
        api.setName(updateApiEntity.getName().trim());
        api.setDescription(updateApiEntity.getDescription().trim());
        api.setPicture(updateApiEntity.getPicture());
        api.setViews(updateApiEntity.getViews());
        if (updateApiEntity.getLabels() != null) {
            api.setLabels(new ArrayList(new LinkedHashSet(updateApiEntity.getLabels())));
        }
        api.setGroups(updateApiEntity.getGroups());
        try {
            Api apiDefinition = new Api();
            apiDefinition.setId(apiId);
            apiDefinition.setName(updateApiEntity.getName());
            apiDefinition.setVersion(updateApiEntity.getVersion());
            apiDefinition.setProxy(updateApiEntity.getProxy());
            apiDefinition.setPaths(updateApiEntity.getPaths());
            apiDefinition.setServices(updateApiEntity.getServices());
            apiDefinition.setResources(updateApiEntity.getResources());
            apiDefinition.setProperties(updateApiEntity.getProperties());
            apiDefinition.setTags(updateApiEntity.getTags());
            if (updateApiEntity.getPathMappings() != null) {
                apiDefinition.setPathMappings(updateApiEntity.getPathMappings().stream().collect(Collectors.toMap(pathMapping -> pathMapping, pathMapping -> Pattern.compile(""))));
            }
            apiDefinition.setResponseTemplates(updateApiEntity.getResponseTemplates());
            String definition = this.objectMapper.writeValueAsString((Object)apiDefinition);
            api.setDefinition(definition);
            return api;
        }
        catch (JsonProcessingException jse) {
            LOGGER.error("Unexpected error while generating API definition", (Throwable)jse);
            return null;
        }
    }

    private LifecycleState convert(EventType eventType) {
        LifecycleState lifecycleState;
        switch (eventType) {
            case START_API: {
                lifecycleState = LifecycleState.STARTED;
                break;
            }
            case STOP_API: {
                lifecycleState = LifecycleState.STOPPED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EventType " + eventType.toString() + " to convert EventType into Lifecycle");
            }
        }
        return lifecycleState;
    }

    private static class MemberToImport {
        private String source;
        private String sourceId;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }
}

