/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.management.model.ApiMetadataEntity;
import io.gravitee.management.model.MetadataEntity;
import io.gravitee.management.model.NewApiMetadataEntity;
import io.gravitee.management.model.UpdateApiMetadataEntity;
import io.gravitee.management.model.api.ApiEntity;
import io.gravitee.management.service.ApiMetadataService;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.AuditService;
import io.gravitee.management.service.MetadataService;
import io.gravitee.management.service.exceptions.ApiMetadataNotFoundException;
import io.gravitee.management.service.exceptions.DuplicateMetadataNameException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.MetadataServiceImpl;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataFormat;
import io.gravitee.repository.management.model.MetadataReferenceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiMetadataServiceImpl
implements ApiMetadataService {
    private final Logger LOGGER = LoggerFactory.getLogger(MetadataServiceImpl.class);
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private AuditService auditService;

    @Override
    public List<ApiMetadataEntity> findAllByApi(String apiId) {
        try {
            this.LOGGER.debug("Find all metadata by api ID {}", (Object)apiId);
            List<MetadataEntity> defaultMetadata = this.metadataService.findAllDefault();
            List defaultMetadataKeys = defaultMetadata.stream().map(MetadataEntity::getKey).collect(Collectors.toList());
            List apiMetadata = this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.API, apiId);
            ArrayList<ApiMetadataEntity> allMetadata = new ArrayList<ApiMetadataEntity>();
            allMetadata.addAll(defaultMetadata.stream().map(metadata -> {
                Optional<Metadata> optApiMetadata = apiMetadata.stream().filter(metadataEntity -> metadata.getKey().equals(metadataEntity.getKey())).findAny();
                return this.convert(optApiMetadata, (MetadataEntity)metadata, null);
            }).collect(Collectors.toList()));
            allMetadata.addAll(apiMetadata.stream().filter(metadata -> !defaultMetadataKeys.contains(metadata.getKey())).map(metadata -> this.convert((Metadata)metadata, apiId)).collect(Collectors.toList()));
            return allMetadata;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to find all metadata by API", (Throwable)ex);
            throw new TechnicalManagementException("An error occurred while trying to find all metadata by API", ex);
        }
    }

    @Override
    public ApiMetadataEntity findByIdAndApi(String metadataId, String apiId) {
        this.LOGGER.debug("Find metadata by id {} and api {}", (Object)metadataId, (Object)apiId);
        try {
            List<MetadataEntity> defaultMedatata = this.metadataService.findAllDefault();
            Optional optMetadata = this.metadataRepository.findById(metadataId, apiId, MetadataReferenceType.API);
            if (optMetadata.isPresent()) {
                Metadata metadata = (Metadata)optMetadata.get();
                Optional<MetadataEntity> optDefaultMetadata = defaultMedatata.stream().filter(metadataEntity -> metadata.getKey().equals(metadataEntity.getKey())).findAny();
                ApiMetadataEntity apiMetadataEntity = this.convert(metadata, apiId);
                optDefaultMetadata.ifPresent(defMetadata -> apiMetadataEntity.setDefaultValue(defMetadata.getValue()));
                return apiMetadataEntity;
            }
            throw new ApiMetadataNotFoundException(apiId, metadataId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to find metadata by id and API", (Throwable)ex);
            throw new TechnicalManagementException("An error occurred while trying to find metadata by id and API", ex);
        }
    }

    @Override
    public void delete(String metadataId, String apiId) {
        this.LOGGER.debug("Delete metadata by id {} and api {}", (Object)metadataId, (Object)apiId);
        ApiMetadataEntity apiMetadata = this.findByIdAndApi(metadataId, apiId);
        try {
            this.metadataRepository.delete(metadataId, apiMetadata.getApiId(), MetadataReferenceType.API);
            this.auditService.createApiAuditLog(apiId, Collections.singletonMap(Audit.AuditProperties.METADATA, metadataId), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_DELETED, new Date(), apiMetadata, null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete metadata {}", (Object)metadataId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete metadata " + metadataId, ex);
        }
    }

    @Override
    public ApiMetadataEntity create(NewApiMetadataEntity metadataEntity) {
        Optional<ApiMetadataEntity> optionalMetadata;
        ApiEntity apiEntity = this.apiService.findById(metadataEntity.getApiId());
        if (metadataEntity.getFormat() == null) {
            metadataEntity.setFormat(io.gravitee.management.model.MetadataFormat.STRING);
        }
        if ((optionalMetadata = this.findAllByApi(apiEntity.getId()).stream().filter(metadata -> metadataEntity.getName().equalsIgnoreCase(metadata.getName())).findAny()).isPresent()) {
            throw new DuplicateMetadataNameException(optionalMetadata.get().getName());
        }
        this.metadataService.checkMetadataFormat(metadataEntity.getFormat(), metadataEntity.getValue());
        try {
            Metadata metadata2 = this.convertForAPI(metadataEntity);
            Date now = new Date();
            metadata2.setCreatedAt(now);
            metadata2.setUpdatedAt(now);
            this.metadataRepository.create(metadata2);
            this.auditService.createApiAuditLog(apiEntity.getId(), Collections.singletonMap(Audit.AuditProperties.METADATA, metadata2.getKey()), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_CREATED, metadata2.getCreatedAt(), null, metadata2);
            return this.convert(metadata2, metadataEntity.getApiId());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to create metadata {} on API {}", new Object[]{metadataEntity.getName(), metadataEntity.getApiId(), ex});
            throw new TechnicalManagementException("An error occurred while trying to create metadata " + metadataEntity.getName() + " on API " + metadataEntity.getApiId(), ex);
        }
    }

    @Override
    public ApiMetadataEntity update(UpdateApiMetadataEntity metadataEntity) {
        ApiEntity apiEntity = this.apiService.findById(metadataEntity.getApiId());
        Optional<ApiMetadataEntity> optionalMetadata = this.findAllByApi(apiEntity.getId()).stream().filter(metadata -> !metadataEntity.getKey().equals(metadata.getKey()) && metadataEntity.getName().equalsIgnoreCase(metadata.getName())).findAny();
        if (optionalMetadata.isPresent()) {
            throw new DuplicateMetadataNameException(optionalMetadata.get().getName());
        }
        this.metadataService.checkMetadataFormat(metadataEntity.getFormat(), metadataEntity.getDefaultValue());
        try {
            Metadata savedMetadata;
            List<MetadataEntity> defaultMedatata = this.metadataService.findAllDefault();
            Optional<MetadataEntity> optDefaultMetadata = defaultMedatata.stream().filter(metadata -> metadata.getKey().equals(metadataEntity.getKey())).findAny();
            Optional apiMetadata = this.metadataRepository.findById(metadataEntity.getKey(), metadataEntity.getApiId(), MetadataReferenceType.API);
            Metadata metadata2 = this.convertForAPI(metadataEntity);
            Date now = new Date();
            if (apiMetadata.isPresent()) {
                metadata2.setUpdatedAt(now);
                savedMetadata = this.metadataRepository.update(metadata2);
                this.auditService.createApiAuditLog(apiEntity.getId(), Collections.singletonMap(Audit.AuditProperties.METADATA, metadata2.getKey()), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_UPDATED, metadata2.getUpdatedAt(), apiMetadata.get(), metadata2);
            } else {
                metadata2.setCreatedAt(now);
                metadata2.setUpdatedAt(now);
                savedMetadata = this.metadataRepository.create(metadata2);
                this.auditService.createApiAuditLog(apiEntity.getId(), Collections.singletonMap(Audit.AuditProperties.METADATA, metadata2.getKey()), (Audit.AuditEvent)Metadata.AuditEvent.METADATA_CREATED, metadata2.getCreatedAt(), null, metadata2);
            }
            ApiMetadataEntity apiMetadataEntity = this.convert(savedMetadata, null);
            optDefaultMetadata.ifPresent(defaultMetadata -> apiMetadataEntity.setDefaultValue(defaultMetadata.getValue()));
            return apiMetadataEntity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to update metadata {} on API {}", new Object[]{metadataEntity.getName(), metadataEntity.getApiId(), ex});
            throw new TechnicalManagementException("An error occurred while trying to update metadata " + metadataEntity.getName() + " on API " + metadataEntity.getApiId(), ex);
        }
    }

    private ApiMetadataEntity convert(Optional<Metadata> optMetadata, MetadataEntity defaultMetadata, String apiId) {
        Metadata metadata;
        if (optMetadata.isPresent()) {
            metadata = optMetadata.get();
        } else {
            metadata = this.convert(defaultMetadata);
            metadata.setValue(null);
        }
        ApiMetadataEntity apiMetadataEntity = this.convert(metadata, apiId);
        apiMetadataEntity.setDefaultValue(defaultMetadata.getValue());
        return apiMetadataEntity;
    }

    private ApiMetadataEntity convert(Metadata metadata, String apiId) {
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setApiId(apiId);
        apiMetadataEntity.setValue(metadata.getValue());
        apiMetadataEntity.setKey(metadata.getKey());
        apiMetadataEntity.setName(metadata.getName());
        apiMetadataEntity.setFormat(io.gravitee.management.model.MetadataFormat.valueOf((String)metadata.getFormat().name()));
        return apiMetadataEntity;
    }

    private Metadata convert(MetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(metadataEntity.getKey());
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (io.gravitee.management.model.MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        return metadata;
    }

    private Metadata convertForAPI(NewApiMetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(IdGenerator.generate((String)metadataEntity.getName()));
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (io.gravitee.management.model.MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(metadataEntity.getApiId());
        metadata.setReferenceType(MetadataReferenceType.API);
        return metadata;
    }

    private Metadata convertForAPI(UpdateApiMetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(metadataEntity.getKey());
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (io.gravitee.management.model.MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(metadataEntity.getApiId());
        metadata.setReferenceType(MetadataReferenceType.API);
        return metadata;
    }
}

