/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.alert.AlertEntity;
import io.gravitee.management.model.alert.AlertReferenceType;
import io.gravitee.management.model.alert.AlertType;
import io.gravitee.management.model.alert.Metric;
import io.gravitee.management.model.alert.MetricType;
import io.gravitee.management.model.alert.NewAlertEntity;
import io.gravitee.management.model.alert.ThresholdType;
import io.gravitee.management.model.alert.UpdateAlertEntity;
import io.gravitee.management.service.AlertService;
import io.gravitee.management.service.alert.AlertTriggerService;
import io.gravitee.management.service.exceptions.AlertInvalidException;
import io.gravitee.management.service.exceptions.AlertNotFoundException;
import io.gravitee.management.service.exceptions.AlertUnavailableException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AlertRepository;
import io.gravitee.repository.management.model.Alert;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AlertServiceImpl
extends TransactionalService
implements AlertService {
    private final Logger LOGGER = LoggerFactory.getLogger(AlertServiceImpl.class);
    @Autowired
    private AlertRepository alertRepository;
    @Autowired
    private AlertTriggerService alertTriggerService;
    @Value(value="${alerts.enabled:false}")
    private boolean enabled;

    @Override
    public AlertEntity create(NewAlertEntity alert) {
        this.checkAlert(alert.getType(), alert.getReferenceType());
        try {
            List alerts;
            if (AlertType.HEALTH_CHECK.equals((Object)alert.getType()) && (alerts = this.alertRepository.findByReference(alert.getReferenceType().name(), alert.getReferenceId())).stream().anyMatch(a -> AlertType.HEALTH_CHECK.name().equals(a.getType()))) {
                throw new IllegalStateException("A HC configuration already exists");
            }
            Alert createdAlert = (Alert)this.alertRepository.create((Object)this.convert(alert));
            AlertEntity alertEntity = this.convert(createdAlert);
            this.triggerOrCancelAlert(alertEntity);
            return alertEntity;
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create alert of type " + alert.getType();
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public AlertEntity update(UpdateAlertEntity alert) {
        this.checkAlert(alert.getType(), alert.getReferenceType());
        try {
            Optional alertOptional = this.alertRepository.findById((Object)alert.getId());
            if (alertOptional.isPresent()) {
                Alert alertToUpdate = (Alert)alertOptional.get();
                if (!alertToUpdate.getReferenceId().equals(alert.getReferenceId())) {
                    throw new AlertNotFoundException(alert.getId());
                }
                alertToUpdate.setName(alert.getName());
                alertToUpdate.setDescription(alert.getDescription());
                alertToUpdate.setEnabled(alert.isEnabled());
                if (alert.getMetricType() != null) {
                    alertToUpdate.setMetricType(alert.getMetricType().name());
                }
                if (alert.getMetric() != null) {
                    alertToUpdate.setMetric(alert.getMetric().name());
                }
                if (alert.getThresholdType() != null) {
                    alertToUpdate.setThresholdType(alert.getThresholdType().name());
                }
                if (alert.getThreshold() != null) {
                    alertToUpdate.setThreshold(alert.getThreshold());
                }
                alertToUpdate.setPlan(alert.getPlan());
                alertToUpdate.setUpdatedAt(new Date());
                AlertEntity alertEntity = this.convert((Alert)this.alertRepository.update((Object)alertToUpdate));
                this.triggerOrCancelAlert(alertEntity);
                return alertEntity;
            }
            throw new AlertNotFoundException(alert.getId());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to update alert of type " + alert.getType();
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public List<AlertEntity> findAll() {
        try {
            Set alerts = this.alertRepository.findAll();
            return alerts.stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list all alerts";
            this.LOGGER.error("An error occurs while trying to list all alerts", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all alerts", ex);
        }
    }

    @Override
    public List<AlertEntity> findByReference(AlertReferenceType referenceType, String referenceId) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        try {
            List alerts = this.alertRepository.findByReference(referenceType.name(), referenceId);
            this.createDefaultAlert(referenceType, referenceId, alerts);
            return alerts.stream().map(this::convert).sorted(Comparator.comparing(AlertEntity::getName)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts by reference " + referenceType + '/' + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private void createDefaultAlert(AlertReferenceType referenceType, String referenceId, List<Alert> alerts) {
        if (AlertReferenceType.API.equals((Object)referenceType)) {
            if (alerts.stream().noneMatch(alert -> AlertType.HEALTH_CHECK.name().equals(alert.getType()))) {
                Alert alert2 = new Alert();
                alert2.setName("Health-check");
                alert2.setDescription(referenceType + " health-check status changed");
                alert2.setType(AlertType.HEALTH_CHECK.name());
                alert2.setReferenceType(referenceType.name());
                alert2.setReferenceId(referenceId);
                alerts.add(alert2);
            }
        } else if (alerts.isEmpty()) {
            Alert alert3 = new Alert();
            alert3.setName("Request");
            alert3.setType(AlertType.REQUEST.name());
            alert3.setReferenceType(referenceType.name());
            alert3.setReferenceId(referenceId);
            alerts.add(alert3);
        }
    }

    @Override
    public void delete(String alertId, String referenceId) {
        try {
            Optional optionalAlert = this.alertRepository.findById((Object)alertId);
            if (!optionalAlert.isPresent() || !((Alert)optionalAlert.get()).getReferenceId().equals(referenceId)) {
                throw new AlertNotFoundException(alertId);
            }
            AlertEntity alert = this.convert((Alert)optionalAlert.get());
            this.checkAlert(alert.getType(), alert.getReferenceType());
            this.alertRepository.delete((Object)alertId);
            this.alertTriggerService.disable(alert);
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while trying to delete the alert " + alertId;
            this.LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    private void checkAlert(AlertType type, AlertReferenceType referenceType) {
        if (!this.enabled) {
            throw new AlertUnavailableException();
        }
        if (!type.getReferenceTypes().contains(referenceType)) {
            throw new AlertInvalidException(type.name(), referenceType.name());
        }
    }

    private void triggerOrCancelAlert(AlertEntity alert) {
        if (alert.isEnabled()) {
            this.alertTriggerService.trigger(alert);
        } else {
            this.alertTriggerService.disable(alert);
        }
    }

    private Alert convert(NewAlertEntity alertEntity) {
        Alert alert = new Alert();
        alert.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        alert.setName(alertEntity.getName());
        alert.setDescription(alertEntity.getDescription());
        alert.setReferenceId(alertEntity.getReferenceId());
        alert.setReferenceType(alertEntity.getReferenceType().name());
        alert.setType(alertEntity.getType().name());
        alert.setEnabled(alertEntity.isEnabled());
        if (alertEntity.getMetricType() != null) {
            alert.setMetricType(alertEntity.getMetricType().name());
        }
        if (alertEntity.getMetric() != null) {
            alert.setMetric(alertEntity.getMetric().name());
        }
        if (alertEntity.getThresholdType() != null) {
            alert.setThresholdType(alertEntity.getThresholdType().name());
        }
        if (alertEntity.getThreshold() != null) {
            alert.setThreshold(alertEntity.getThreshold());
        }
        alert.setPlan(alertEntity.getPlan());
        Date now = new Date();
        alert.setCreatedAt(now);
        alert.setUpdatedAt(now);
        return alert;
    }

    private AlertEntity convert(Alert alert) {
        AlertEntity alertEntity = new AlertEntity();
        alertEntity.setId(alert.getId());
        alertEntity.setName(alert.getName());
        alertEntity.setDescription(alert.getDescription());
        alertEntity.setReferenceId(alert.getReferenceId());
        alertEntity.setReferenceType(AlertReferenceType.valueOf((String)alert.getReferenceType()));
        alertEntity.setType(AlertType.valueOf((String)alert.getType()));
        alertEntity.setEnabled(alert.isEnabled());
        if (alert.getMetricType() != null) {
            alertEntity.setMetricType(MetricType.valueOf((String)alert.getMetricType()));
        }
        if (alert.getMetric() != null) {
            alertEntity.setMetric(Metric.valueOf((String)alert.getMetric()));
        }
        if (alert.getThresholdType() != null) {
            alertEntity.setThresholdType(ThresholdType.valueOf((String)alert.getThresholdType()));
        }
        if (alert.getThreshold() != null) {
            alertEntity.setThreshold(alert.getThreshold());
        }
        alertEntity.setPlan(alert.getPlan());
        alertEntity.setCreatedAt(alert.getCreatedAt());
        alertEntity.setUpdatedAt(alert.getUpdatedAt());
        return alertEntity;
    }
}

