/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.NewUserEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.exceptions.UserNotFoundException;
import io.gravitee.management.service.exceptions.UsernameAlreadyExistsException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.model.User;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserServiceImpl
extends TransactionalService
implements UserService {
    private final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserRepository userRepository;

    @Override
    public UserEntity findByName(String username) {
        try {
            this.LOGGER.debug("Find user by name: {}", (Object)username);
            Optional application = this.userRepository.findByUsername(username);
            if (application.isPresent()) {
                return UserServiceImpl.convert((User)application.get());
            }
            throw new UserNotFoundException(username);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find a user using its name {}", (Object)username, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find a user using its name " + username, ex);
        }
    }

    @Override
    public UserEntity create(NewUserEntity newUserEntity) {
        try {
            this.LOGGER.debug("Create {}", (Object)newUserEntity);
            Optional checkUser = this.userRepository.findByUsername(newUserEntity.getUsername());
            if (checkUser.isPresent()) {
                throw new UsernameAlreadyExistsException(newUserEntity.getUsername());
            }
            User user = UserServiceImpl.convert(newUserEntity);
            user.setCreatedAt(new Date());
            user.setUpdatedAt(user.getCreatedAt());
            User createdUser = this.userRepository.create(user);
            return UserServiceImpl.convert(createdUser);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {}", (Object)newUserEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + newUserEntity, ex);
        }
    }

    private static User convert(NewUserEntity newUserEntity) {
        if (newUserEntity == null) {
            return null;
        }
        User user = new User();
        user.setUsername(newUserEntity.getUsername());
        user.setEmail(newUserEntity.getEmail());
        user.setFirstname(newUserEntity.getFirstname());
        user.setLastname(newUserEntity.getLastname());
        user.setPassword(newUserEntity.getPassword());
        user.setRoles(newUserEntity.getRoles());
        return user;
    }

    private static UserEntity convert(User user) {
        if (user == null) {
            return null;
        }
        UserEntity userEntity = new UserEntity();
        userEntity.setUsername(user.getUsername());
        userEntity.setEmail(user.getEmail());
        userEntity.setFirstname(user.getFirstname());
        userEntity.setLastname(user.getLastname());
        userEntity.setPassword(user.getPassword());
        userEntity.setRoles(user.getRoles());
        userEntity.setCreatedAt(user.getCreatedAt());
        userEntity.setUpdatedAt(user.getUpdatedAt());
        return userEntity;
    }
}

