/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.PluginEntity;
import io.gravitee.management.model.PolicyDevelopmentEntity;
import io.gravitee.management.model.PolicyEntity;
import io.gravitee.management.model.PolicyType;
import io.gravitee.management.service.PolicyService;
import io.gravitee.management.service.exceptions.PolicyConfigurationNotFoundException;
import io.gravitee.management.service.exceptions.PolicyNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.policy.PolicyDefinition;
import io.gravitee.plugin.policy.PolicyManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyServiceImpl
extends TransactionalService
implements PolicyService {
    private final Logger LOGGER = LoggerFactory.getLogger(PolicyServiceImpl.class);
    @Autowired
    private PolicyManager policyManager;

    @Override
    public Set<PolicyEntity> findAll() {
        try {
            this.LOGGER.debug("List all policies");
            Collection policyDefinitions = this.policyManager.getPolicyDefinitions();
            return policyDefinitions.stream().map(policyDefinition -> this.convert((PolicyDefinition)policyDefinition, false)).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to list all policies", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all policies", ex);
        }
    }

    @Override
    public PolicyEntity findById(String policyId) {
        this.LOGGER.debug("Find policy by ID: {}", (Object)policyId);
        PolicyDefinition policyDefinition = this.policyManager.getPolicyDefinition(policyId);
        if (policyDefinition == null) {
            throw new PolicyNotFoundException(policyId);
        }
        return this.convert(policyDefinition, true);
    }

    @Override
    public String getSchema(String policyId) {
        try {
            this.LOGGER.debug("Find policy schema by ID: {}", (Object)policyId);
            String configuration = this.policyManager.getPolicyConfiguration(policyId);
            if (configuration == null) {
                throw new PolicyConfigurationNotFoundException(policyId);
            }
            return configuration;
        }
        catch (IOException ioex) {
            this.LOGGER.error("An error occurs while trying to get policy schema for policy {}", (Object)policyId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get policy schema for policy " + policyId, ioex);
        }
    }

    private PolicyEntity convert(PolicyDefinition policyDefinition, boolean withPlugin) {
        PolicyEntity entity = new PolicyEntity();
        entity.setId(policyDefinition.id());
        entity.setDescription(policyDefinition.plugin().manifest().description());
        entity.setName(policyDefinition.plugin().manifest().name());
        entity.setVersion(policyDefinition.plugin().manifest().version());
        if (policyDefinition.onRequestMethod() != null && policyDefinition.onResponseMethod() != null) {
            entity.setType(PolicyType.REQUEST_RESPONSE);
        } else if (policyDefinition.onRequestMethod() != null) {
            entity.setType(PolicyType.REQUEST);
        } else if (policyDefinition.onResponseMethod() != null) {
            entity.setType(PolicyType.RESPONSE);
        }
        if (withPlugin) {
            Plugin plugin = policyDefinition.plugin();
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setClassName(plugin.clazz().getName());
            pluginEntity.setPath(plugin.path().toString());
            pluginEntity.setType(plugin.type().toString().toLowerCase());
            pluginEntity.setDependencies(plugin.dependencies());
            entity.setPlugin(pluginEntity);
            PolicyDevelopmentEntity developmentEntity = new PolicyDevelopmentEntity();
            developmentEntity.setClassName(policyDefinition.policy().getName());
            if (policyDefinition.configuration() != null) {
                developmentEntity.setConfiguration(policyDefinition.configuration().getName());
            }
            if (policyDefinition.onRequestMethod() != null) {
                developmentEntity.setOnRequestMethod(policyDefinition.onRequestMethod().toGenericString());
            }
            if (policyDefinition.onResponseMethod() != null) {
                developmentEntity.setOnResponseMethod(policyDefinition.onResponseMethod().toGenericString());
            }
            entity.setDevelopment(developmentEntity);
        }
        return entity;
    }
}

