/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.ApiEntity;
import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.MembershipType;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.PermissionService;
import io.gravitee.management.service.PermissionType;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.exceptions.ForbiddenAccessException;
import io.gravitee.management.service.impl.TransactionalService;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionServiceImpl
extends TransactionalService
implements PermissionService {
    private final Logger LOGGER = LoggerFactory.getLogger(PermissionServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ApplicationService applicationService;

    @Override
    public void hasPermission(Principal principal, String item, PermissionType permissionType) {
        UserEntity user;
        if (principal != null && (user = this.userService.findByName(principal.getName())) != null && user.getRoles().contains("ROLE_ADMIN")) {
            this.LOGGER.debug("User {} has full access because of admin role", (Object)principal.getName());
            return;
        }
        if (permissionType == PermissionType.VIEW_API || permissionType == PermissionType.EDIT_API) {
            this.validateApi(principal, item, permissionType);
        } else if (permissionType == PermissionType.VIEW_APPLICATION || permissionType == PermissionType.EDIT_APPLICATION) {
            this.validateApplication(principal, item, permissionType);
        }
    }

    private void validateApi(Principal principal, String apiId, PermissionType permissionType) {
        this.LOGGER.debug("Validate user rights for API: {}", (Object)apiId);
        ApiEntity api = this.apiService.findById(apiId);
        if (permissionType == PermissionType.VIEW_API) {
            switch (api.getVisibility()) {
                case PRIVATE: 
                case RESTRICTED: {
                    if (principal == null) {
                        this.LOGGER.error("Anonymous user does not have rights to view API {}", (Object)api);
                        throw new ForbiddenAccessException();
                    }
                    MemberEntity member = this.apiService.getMember(apiId, principal.getName());
                    if (member != null) break;
                    this.LOGGER.error("User {} does not have rights to view API {}", (Object)principal.getName(), (Object)api);
                    throw new ForbiddenAccessException();
                }
            }
        } else if (permissionType == PermissionType.EDIT_API) {
            if (principal == null) {
                this.LOGGER.error("Anonymous user does not have rights to edit API {}", (Object)api);
                throw new ForbiddenAccessException();
            }
            MemberEntity member = this.apiService.getMember(apiId, principal.getName());
            if (member == null || member.getType() == MembershipType.USER) {
                this.LOGGER.error("User {} does not have rights to view API {}", (Object)principal.getName(), (Object)api);
                throw new ForbiddenAccessException();
            }
        }
    }

    private void validateApplication(Principal principal, String applicationId, PermissionType permissionType) {
        this.LOGGER.debug("Validate user rights for application: {}", (Object)applicationId);
        if (principal == null) {
            this.LOGGER.error("Anonymous user does not have rights to view application {}", (Object)applicationId);
            throw new ForbiddenAccessException();
        }
        ApplicationEntity application = this.applicationService.findById(applicationId);
        MemberEntity member = this.applicationService.getMember(applicationId, principal.getName());
        if (member == null) {
            this.LOGGER.error("User {} does not have correct rights to view application {}", (Object)principal.getName(), (Object)application);
            throw new ForbiddenAccessException();
        }
        if (permissionType == PermissionType.EDIT_APPLICATION && member.getType() == MembershipType.USER) {
            this.LOGGER.error("User {} does not have correct rights to edit application {}", (Object)principal.getName(), (Object)application);
            throw new ForbiddenAccessException();
        }
    }
}

