/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.NewPageEntity;
import io.gravitee.management.model.PageEntity;
import io.gravitee.management.model.PageListItem;
import io.gravitee.management.model.UpdatePageEntity;
import io.gravitee.management.service.IdGenerator;
import io.gravitee.management.service.PageService;
import io.gravitee.management.service.exceptions.PageAlreadyExistsException;
import io.gravitee.management.service.exceptions.PageNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageServiceImpl
extends TransactionalService
implements PageService {
    private final Logger LOGGER = LoggerFactory.getLogger(PageServiceImpl.class);
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private IdGenerator idGenerator;

    @Override
    public List<PageListItem> findByApi(String apiId) {
        try {
            Collection pages = this.pageRepository.findByApi(apiId);
            if (pages == null) {
                return Collections.emptyList();
            }
            return pages.stream().map(this::reduce).sorted((o1, o2) -> Integer.compare(o1.getOrder(), o2.getOrder())).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get API pages using api ID {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get API pages using api ID " + apiId, ex);
        }
    }

    @Override
    public PageEntity findById(String pageId) {
        try {
            this.LOGGER.debug("Find page by ID: {}", (Object)pageId);
            Optional page = this.pageRepository.findById((Object)pageId);
            if (page.isPresent()) {
                return PageServiceImpl.convert((Page)page.get());
            }
            throw new PageNotFoundException(pageId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find a page using its ID {}", (Object)pageId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find a page using its ID " + pageId, ex);
        }
    }

    @Override
    public PageEntity create(String apiId, NewPageEntity newPageEntity) {
        try {
            this.LOGGER.debug("Create page {} for API {}", (Object)newPageEntity, (Object)apiId);
            String id = apiId + '_' + this.idGenerator.generate(newPageEntity.getName());
            Optional checkPage = this.pageRepository.findById((Object)id);
            if (checkPage.isPresent()) {
                throw new PageAlreadyExistsException(id);
            }
            Page page = PageServiceImpl.convert(newPageEntity);
            page.setId(apiId + '_' + this.idGenerator.generate(page.getName()));
            page.setApi(apiId);
            page.setCreatedAt(new Date());
            page.setUpdatedAt(page.getCreatedAt());
            Page createdPage = (Page)this.pageRepository.create((Object)page);
            return PageServiceImpl.convert(createdPage);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {}", (Object)newPageEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + newPageEntity, ex);
        }
    }

    @Override
    public PageEntity update(String pageId, UpdatePageEntity updatePageEntity) {
        try {
            this.LOGGER.debug("Update Page {}", (Object)pageId);
            Optional optPageToUpdate = this.pageRepository.findById((Object)pageId);
            if (!optPageToUpdate.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page pageToUpdate = (Page)optPageToUpdate.get();
            Page page = PageServiceImpl.convert(updatePageEntity);
            page.setId(pageId);
            page.setUpdatedAt(new Date());
            page.setCreatedAt(pageToUpdate.getCreatedAt());
            page.setType(pageToUpdate.getType());
            page.setApi(pageToUpdate.getApi());
            if (page.getOrder() != pageToUpdate.getOrder()) {
                this.reorderAndSavePages(page);
                return null;
            }
            Page updatedPage = (Page)this.pageRepository.update((Object)page);
            return PageServiceImpl.convert(updatedPage);
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    private void reorderAndSavePages(Page pageToReorder) throws TechnicalException {
        Collection pages = this.pageRepository.findByApi(pageToReorder.getApi());
        List<Boolean> increment = Arrays.asList(true);
        pages.stream().sorted((o1, o2) -> Integer.compare(o1.getOrder(), o2.getOrder())).forEachOrdered(page2 -> {
            try {
                if (page2.equals((Object)pageToReorder)) {
                    increment.set(0, false);
                    page2.setOrder(pageToReorder.getOrder());
                } else {
                    Boolean isIncrement = (Boolean)increment.get(0);
                    int newOrder = page2.getOrder() < pageToReorder.getOrder() ? page2.getOrder() - (isIncrement != false ? 0 : 1) : (page2.getOrder() > pageToReorder.getOrder() ? page2.getOrder() + (isIncrement != false ? 1 : 0) : page2.getOrder() + (isIncrement != false ? 1 : -1));
                    page2.setOrder(newOrder);
                }
                this.pageRepository.update(page2);
            }
            catch (TechnicalException ex) {
                throw this.onUpdateFail(page2.getId(), ex);
            }
        });
    }

    private TechnicalManagementException onUpdateFail(String pageId, TechnicalException ex) {
        this.LOGGER.error("An error occurs while trying to update page {}", (Object)pageId, (Object)ex);
        return new TechnicalManagementException("An error occurs while trying to update page " + pageId, ex);
    }

    @Override
    public void delete(String pageName) {
        try {
            this.LOGGER.debug("Delete PAGE : {}", (Object)pageName);
            this.pageRepository.delete((Object)pageName);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete PAGE {}", (Object)pageName, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete PAGE " + pageName, ex);
        }
    }

    @Override
    public int findMaxPageOrderByApi(String apiName) {
        try {
            this.LOGGER.debug("Find Max Order Page for api name : {}", (Object)apiName);
            Integer maxPageOrder = this.pageRepository.findMaxPageOrderByApi(apiName);
            return maxPageOrder == null ? 0 : maxPageOrder;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occured when searching max order page for api name [{}]", (Object)apiName, (Object)ex);
            throw new TechnicalManagementException("An error occured when searching max order page for api name " + apiName, ex);
        }
    }

    private PageListItem reduce(Page page) {
        PageListItem pageItem = new PageListItem();
        pageItem.setId(page.getId());
        pageItem.setName(page.getName());
        pageItem.setType(io.gravitee.management.model.PageType.valueOf((String)page.getType().toString()));
        pageItem.setOrder(page.getOrder());
        pageItem.setLastContributor(page.getLastContributor());
        pageItem.setPublished(page.isPublished());
        return pageItem;
    }

    private static Page convert(NewPageEntity newPageEntity) {
        Page page = new Page();
        page.setName(newPageEntity.getName());
        String type = newPageEntity.getType();
        if (type != null) {
            page.setType(PageType.valueOf((String)type.toString()));
        }
        page.setContent(newPageEntity.getContent());
        page.setLastContributor(newPageEntity.getLastContributor());
        page.setOrder(newPageEntity.getOrder());
        return page;
    }

    private static PageEntity convert(Page page) {
        PageEntity pageEntity = new PageEntity();
        pageEntity.setId(page.getId());
        pageEntity.setName(page.getName());
        if (page.getType() != null) {
            pageEntity.setType(page.getType().toString());
        }
        pageEntity.setContent(page.getContent());
        pageEntity.setLastContributor(page.getLastContributor());
        pageEntity.setLastModificationDate(page.getUpdatedAt());
        pageEntity.setOrder(page.getOrder());
        pageEntity.setPublished(page.isPublished());
        return pageEntity;
    }

    private static Page convert(UpdatePageEntity updatePageEntity) {
        Page page = new Page();
        page.setName(updatePageEntity.getName());
        page.setContent(updatePageEntity.getContent());
        page.setLastContributor(updatePageEntity.getLastContributor());
        page.setOrder(updatePageEntity.getOrder());
        page.setPublished(updatePageEntity.isPublished());
        return page;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

