/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.EventEntity;
import io.gravitee.management.model.NewEventEntity;
import io.gravitee.management.service.EventService;
import io.gravitee.management.service.exceptions.EventNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventServiceImpl
extends TransactionalService
implements EventService {
    private final Logger LOGGER = LoggerFactory.getLogger(EventServiceImpl.class);
    @Autowired
    private EventRepository eventRepository;

    @Override
    public EventEntity findById(String id) {
        try {
            this.LOGGER.debug("Find event by ID: {}", (Object)id);
            Optional event = this.eventRepository.findById((Object)id);
            if (event.isPresent()) {
                return this.convert((Event)event.get());
            }
            throw new EventNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an event using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an event using its ID " + id, ex);
        }
    }

    @Override
    public EventEntity create(NewEventEntity newEventEntity) {
        String hostAddress = "";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
            this.LOGGER.debug("Create {} for server {}", (Object)newEventEntity, (Object)hostAddress);
            Event event = this.convert(newEventEntity);
            event.getProperties().put(Event.EventProperties.ORIGIN.getValue(), hostAddress);
            event.setCreatedAt(new Date());
            event.setUpdatedAt(event.getCreatedAt());
            Event createdEvent = (Event)this.eventRepository.create((Object)event);
            return this.convert(createdEvent);
        }
        catch (UnknownHostException e) {
            this.LOGGER.error("An error occurs while getting the server IP address", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while getting the server IP address", e);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for server {}", new Object[]{newEventEntity, hostAddress, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + newEventEntity + " for server " + hostAddress, ex);
        }
    }

    @Override
    public EventEntity create(io.gravitee.management.model.EventType type, String payload, Map<String, String> properties) {
        NewEventEntity event = new NewEventEntity();
        event.setType(type);
        event.setPayload(payload);
        event.setProperties(properties);
        return this.create(event);
    }

    @Override
    public void delete(String eventId) {
        try {
            this.LOGGER.debug("Delete Event {}", (Object)eventId);
            this.eventRepository.delete((Object)eventId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete Event {}", (Object)eventId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Event " + eventId, ex);
        }
    }

    @Override
    public Set<EventEntity> findByType(List<io.gravitee.management.model.EventType> eventTypes) {
        Set events = this.eventRepository.findByType(this.convert(eventTypes));
        return this.convert(events);
    }

    @Override
    public Set<EventEntity> findByApi(String apiId) {
        Set events = this.eventRepository.findByProperty(Event.EventProperties.API_ID.getValue(), apiId);
        return this.convert(events);
    }

    @Override
    public Set<EventEntity> findByUser(String username) {
        Set events = this.eventRepository.findByProperty(Event.EventProperties.USERNAME.getValue(), username);
        return this.convert(events);
    }

    @Override
    public Set<EventEntity> findByOrigin(String origin) {
        Set events = this.eventRepository.findByProperty(Event.EventProperties.ORIGIN.getValue(), origin);
        return this.convert(events);
    }

    private List<EventType> convert(List<io.gravitee.management.model.EventType> eventTypes) {
        ArrayList<EventType> convertedEvents = new ArrayList<EventType>();
        for (io.gravitee.management.model.EventType eventType : eventTypes) {
            convertedEvents.add(this.convert(eventType));
        }
        return convertedEvents;
    }

    private EventType convert(io.gravitee.management.model.EventType eventType) {
        return EventType.valueOf((String)eventType.toString());
    }

    private Set<EventEntity> convert(Set<Event> events) {
        return events.stream().map(this::convert).collect(Collectors.toSet());
    }

    private EventEntity convert(Event event) {
        EventEntity eventEntity = new EventEntity();
        eventEntity.setId(event.getId());
        eventEntity.setType(io.gravitee.management.model.EventType.valueOf((String)event.getType().toString()));
        eventEntity.setPayload(event.getPayload());
        eventEntity.setParentId(event.getParentId());
        eventEntity.setProperties(event.getProperties());
        eventEntity.setCreatedAt(event.getCreatedAt());
        eventEntity.setUpdatedAt(event.getUpdatedAt());
        return eventEntity;
    }

    private Event convert(NewEventEntity newEventEntity) {
        Event event = new Event();
        event.setType(EventType.valueOf((String)newEventEntity.getType().toString()));
        event.setPayload(newEventEntity.getPayload());
        event.setParentId(newEventEntity.getParentId());
        event.setProperties(newEventEntity.getProperties());
        return event;
    }
}

