/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.gravitee.management.service.EmailNotification;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.impl.TransactionalService;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Component
public class EmailServiceImpl
extends TransactionalService
implements EmailService {
    private final Logger LOGGER = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private MimeMessageHelper mailMessage;
    @Autowired
    private Configuration freemarkerConfiguration;
    @Value(value="${templates.path:${gravitee.home}/templates}")
    private String templatesPath;

    @Override
    @Async
    public void sendEmailNotification(EmailNotification emailNotification) {
        try {
            Template template = this.freemarkerConfiguration.getTemplate(emailNotification.getContent());
            String htmlText = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)emailNotification.getParams());
            String from = emailNotification.getFrom();
            if (from != null && !from.isEmpty()) {
                this.mailMessage.setFrom(from);
            }
            this.mailMessage.setTo(emailNotification.getTo());
            this.mailMessage.setSubject(emailNotification.getSubject());
            String html = this.addResourcesInMessage(this.mailMessage, htmlText);
            this.LOGGER.debug("Sending an email to: {}\nSubject: {}\nMessage: {}", new Object[]{emailNotification.getTo(), emailNotification.getSubject(), html});
            this.mailSender.send(this.mailMessage.getMimeMessage());
        }
        catch (Exception ioe) {
            this.LOGGER.error("Error while sending email notification", (Throwable)ioe);
        }
    }

    private String addResourcesInMessage(MimeMessageHelper mailMessage, String htmlText) throws Exception {
        Document document = Jsoup.parse((String)htmlText);
        ArrayList resources = new ArrayList();
        Elements imageElements = document.getElementsByTag("img");
        resources.addAll(imageElements.stream().filter(imageElement -> imageElement.hasAttr("src")).map(imageElement -> {
            String src = imageElement.attr("src");
            imageElement.attr("src", "cid:" + src);
            return src;
        }).collect(Collectors.toList()));
        String html = document.html();
        mailMessage.setText(html, true);
        for (String res : resources) {
            FileSystemResource templateResource = new FileSystemResource(new File(this.templatesPath, res));
            mailMessage.addInline(res, (InputStreamSource)templateResource, MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(res));
        }
        return html;
    }
}

