/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.google.common.collect.ImmutableMap;
import io.gravitee.management.model.ApplicationEntity;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.NewApplicationEntity;
import io.gravitee.management.model.PrimaryOwnerEntity;
import io.gravitee.management.model.UpdateApplicationEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.service.ApplicationService;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.IdGenerator;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.builder.EmailNotificationBuilder;
import io.gravitee.management.service.exceptions.ApplicationAlreadyExistsException;
import io.gravitee.management.service.exceptions.ApplicationNotFoundException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipType;
import io.gravitee.repository.management.model.User;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationServiceImpl
extends TransactionalService
implements ApplicationService {
    private final Logger LOGGER = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private ApiKeyRepository apiKeyRepository;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private UserService userService;
    @Autowired
    private EmailService emailService;

    @Override
    public ApplicationEntity findById(String applicationId) {
        try {
            this.LOGGER.debug("Find application by ID: {}", (Object)applicationId);
            Optional application = this.applicationRepository.findById((Object)applicationId);
            if (application.isPresent()) {
                return ApplicationServiceImpl.convert((Application)application.get());
            }
            throw new ApplicationNotFoundException(applicationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an application using its ID {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an application using its ID " + applicationId, ex);
        }
    }

    @Override
    public Set<ApplicationEntity> findByUser(String username) {
        try {
            this.LOGGER.debug("Find applications for user {}", (Object)username);
            Set applications = this.applicationRepository.findByUser(username, null);
            if (applications == null || applications.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<ApplicationEntity> applicationEntities = new HashSet<ApplicationEntity>(applications.size());
            applicationEntities.addAll(applications.stream().map(ApplicationServiceImpl::convert).collect(Collectors.toSet()));
            return applicationEntities;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find applications for user {}", (Object)username, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find applications for user " + username, ex);
        }
    }

    @Override
    public ApplicationEntity create(NewApplicationEntity newApplicationEntity, String username) {
        try {
            this.LOGGER.debug("Create {} for user {}", (Object)newApplicationEntity, (Object)username);
            String id = this.idGenerator.generate(newApplicationEntity.getName());
            Optional checkApplication = this.applicationRepository.findById((Object)id);
            if (checkApplication.isPresent()) {
                throw new ApplicationAlreadyExistsException(id);
            }
            Application application = ApplicationServiceImpl.convert(newApplicationEntity);
            application.setId(id);
            application.setCreatedAt(new Date());
            application.setUpdatedAt(application.getCreatedAt());
            Application createdApplication = (Application)this.applicationRepository.create((Object)application);
            this.applicationRepository.saveMember(createdApplication.getId(), username, MembershipType.PRIMARY_OWNER);
            return ApplicationServiceImpl.convert(createdApplication);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for user {}", new Object[]{newApplicationEntity, username, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + newApplicationEntity + " for user " + username, ex);
        }
    }

    @Override
    public ApplicationEntity update(String applicationId, UpdateApplicationEntity updateApplicationEntity) {
        try {
            this.LOGGER.debug("Update application {}", (Object)applicationId);
            Optional optApplicationToUpdate = this.applicationRepository.findById((Object)applicationId);
            if (!optApplicationToUpdate.isPresent()) {
                throw new ApplicationNotFoundException(applicationId);
            }
            Application application = ApplicationServiceImpl.convert(updateApplicationEntity);
            application.setId(applicationId);
            application.setUpdatedAt(new Date());
            Application updatedApplication = (Application)this.applicationRepository.update((Object)application);
            return ApplicationServiceImpl.convert(updatedApplication);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update application " + applicationId, ex);
        }
    }

    @Override
    public void delete(String applicationId) {
        try {
            this.LOGGER.debug("Delete application {}", (Object)applicationId);
            Set keys = this.apiKeyRepository.findByApplication(applicationId);
            keys.forEach(apiKey -> {
                try {
                    this.apiKeyRepository.delete(apiKey.getKey());
                }
                catch (TechnicalException e) {
                    this.LOGGER.error("An error occurs while deleting API Key {}", (Object)apiKey.getKey(), (Object)e);
                }
            });
            this.applicationRepository.delete((Object)applicationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete application " + applicationId, ex);
        }
    }

    @Override
    public Set<ApplicationEntity> findByApi(String apiId) {
        try {
            this.LOGGER.debug("Find applications for api {}", (Object)apiId);
            Set applications = this.apiKeyRepository.findByApi(apiId);
            return applications.stream().map(application -> this.findById(application.getApplication())).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get applications for api {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get applications for api " + apiId, ex);
        }
    }

    @Override
    public Set<MemberEntity> getMembers(String applicationId, io.gravitee.management.model.MembershipType membershipType) {
        try {
            this.LOGGER.debug("Get members for application {}", (Object)applicationId);
            Collection membersRepo = this.applicationRepository.getMembers(applicationId, membershipType == null ? null : MembershipType.valueOf((String)membershipType.toString()));
            HashSet<MemberEntity> members = new HashSet<MemberEntity>(membersRepo.size());
            members.addAll(membersRepo.stream().map(member -> this.convert((Membership)member)).collect(Collectors.toSet()));
            return members;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get members for application {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get members for application " + applicationId, ex);
        }
    }

    @Override
    public MemberEntity getMember(String applicationId, String username) {
        try {
            this.LOGGER.debug("Get membership for application {} and user {}", (Object)applicationId, (Object)username);
            Membership membership = this.applicationRepository.getMember(applicationId, username);
            if (membership != null) {
                return this.convert(membership);
            }
            return null;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get membership for application {} and user", new Object[]{applicationId, username, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for application " + applicationId + " and user " + username, ex);
        }
    }

    @Override
    public void addOrUpdateMember(String applicationId, String username, io.gravitee.management.model.MembershipType membershipType) {
        try {
            this.LOGGER.debug("Add a new member for applicationId {}", (Object)applicationId);
            UserEntity user = this.userService.findByName(username);
            this.applicationRepository.saveMember(applicationId, username, MembershipType.valueOf((String)membershipType.toString()));
            if (user.getEmail() != null && !user.getEmail().isEmpty()) {
                this.emailService.sendEmailNotification(new EmailNotificationBuilder().to(user.getEmail()).subject("Subscription to application " + applicationId).content("applicationMember.html").params((Map)ImmutableMap.of((Object)"application", (Object)applicationId, (Object)"username", (Object)username)).build());
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to add member for applicationId {}", (Object)applicationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to add member for applicationId " + applicationId, ex);
        }
    }

    @Override
    public void deleteMember(String applicationId, String username) {
        try {
            this.LOGGER.debug("Delete member {} for application {}", (Object)username, (Object)applicationId);
            this.applicationRepository.deleteMember(applicationId, username);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete member {} for application {}", new Object[]{username, applicationId, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete member " + username + " for application " + applicationId, ex);
        }
    }

    private static ApplicationEntity convert(Application application) {
        Optional<Membership> member;
        ApplicationEntity applicationEntity = new ApplicationEntity();
        applicationEntity.setId(application.getId());
        applicationEntity.setName(application.getName());
        applicationEntity.setDescription(application.getDescription());
        applicationEntity.setType(application.getType());
        applicationEntity.setCreatedAt(application.getCreatedAt());
        applicationEntity.setUpdatedAt(application.getUpdatedAt());
        if (application.getMembers() != null && (member = application.getMembers().stream().filter(membership -> MembershipType.PRIMARY_OWNER.equals((Object)membership.getMembershipType())).findFirst()).isPresent()) {
            User user = member.get().getUser();
            PrimaryOwnerEntity primaryOwnerEntity = new PrimaryOwnerEntity();
            primaryOwnerEntity.setUsername(user.getUsername());
            primaryOwnerEntity.setLastname(user.getLastname());
            primaryOwnerEntity.setFirstname(user.getFirstname());
            primaryOwnerEntity.setEmail(user.getEmail());
            applicationEntity.setPrimaryOwner(primaryOwnerEntity);
        }
        return applicationEntity;
    }

    private static Application convert(NewApplicationEntity newApplicationEntity) {
        Application application = new Application();
        application.setName(newApplicationEntity.getName().trim());
        application.setDescription(newApplicationEntity.getDescription().trim());
        if (newApplicationEntity.getType() != null) {
            application.setType(newApplicationEntity.getType().trim());
        }
        return application;
    }

    private static Application convert(UpdateApplicationEntity updateApplicationEntity) {
        Application application = new Application();
        application.setName(updateApplicationEntity.getName().trim());
        application.setDescription(updateApplicationEntity.getDescription().trim());
        if (updateApplicationEntity.getType() != null) {
            application.setType(updateApplicationEntity.getType().trim());
        }
        return application;
    }

    private MemberEntity convert(Membership membership) {
        MemberEntity member = new MemberEntity();
        member.setUser(membership.getUser().getUsername());
        member.setCreatedAt(membership.getCreatedAt());
        member.setUpdatedAt(membership.getUpdatedAt());
        member.setType(io.gravitee.management.model.MembershipType.valueOf((String)membership.getMembershipType().toString()));
        return member;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

