/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.Path;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Rule;
import io.gravitee.management.model.ApiEntity;
import io.gravitee.management.model.EventEntity;
import io.gravitee.management.model.EventType;
import io.gravitee.management.model.MemberEntity;
import io.gravitee.management.model.NewApiEntity;
import io.gravitee.management.model.PrimaryOwnerEntity;
import io.gravitee.management.model.UpdateApiEntity;
import io.gravitee.management.model.UserEntity;
import io.gravitee.management.service.ApiService;
import io.gravitee.management.service.EmailService;
import io.gravitee.management.service.EventService;
import io.gravitee.management.service.IdGenerator;
import io.gravitee.management.service.UserService;
import io.gravitee.management.service.builder.EmailNotificationBuilder;
import io.gravitee.management.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.management.service.exceptions.ApiNotFoundException;
import io.gravitee.management.service.exceptions.ApiRunningStateException;
import io.gravitee.management.service.exceptions.TechnicalManagementException;
import io.gravitee.management.service.impl.TransactionalService;
import io.gravitee.management.service.processor.ApiSynchronizationProcessor;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipType;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.Visibility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiServiceImpl
extends TransactionalService
implements ApiService {
    private final Logger LOGGER = LoggerFactory.getLogger(ApiServiceImpl.class);
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ApiKeyRepository apiKeyRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private EventService eventService;
    @Autowired
    private UserService userService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private ApiSynchronizationProcessor apiSynchronizationProcessor;

    @Override
    public ApiEntity create(NewApiEntity newApiEntity, String username) throws ApiAlreadyExistsException {
        try {
            this.LOGGER.debug("Create {} for user {}", (Object)newApiEntity, (Object)username);
            String id = this.idGenerator.generate(newApiEntity.getName());
            Optional checkApi = this.apiRepository.findById((Object)id);
            if (checkApi.isPresent()) {
                throw new ApiAlreadyExistsException(id);
            }
            io.gravitee.repository.management.model.Api api = this.convert(id, newApiEntity);
            if (api != null) {
                api.setId(id);
                api.setCreatedAt(new Date());
                api.setUpdatedAt(api.getCreatedAt());
                api.setLifecycleState(LifecycleState.STOPPED);
                api.setVisibility(Visibility.PRIVATE);
                io.gravitee.repository.management.model.Api createdApi = (io.gravitee.repository.management.model.Api)this.apiRepository.create((Object)api);
                this.apiRepository.saveMember(createdApi.getId(), username, MembershipType.PRIMARY_OWNER);
                return this.convert(createdApi);
            }
            this.LOGGER.error("Unable to create API {} because of previous error.");
            throw new TechnicalManagementException("Unable to create API " + id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for user {}", new Object[]{newApiEntity, username, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + newApiEntity + " for user " + username, ex);
        }
    }

    @Override
    public ApiEntity findById(String apiId) {
        try {
            this.LOGGER.debug("Find API by ID: {}", (Object)apiId);
            Optional api = this.apiRepository.findById((Object)apiId);
            if (api.isPresent()) {
                return this.convert((io.gravitee.repository.management.model.Api)api.get());
            }
            throw new ApiNotFoundException(apiId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    @Override
    public Set<ApiEntity> findByVisibility(io.gravitee.management.model.Visibility visibility) {
        try {
            this.LOGGER.debug("Find APIs by visibility {}", (Object)visibility);
            Set publicApis = this.apiRepository.findByMember(null, null, Visibility.PUBLIC);
            return publicApis.stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all APIs", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs", ex);
        }
    }

    @Override
    public Set<ApiEntity> findByUser(String username) {
        try {
            this.LOGGER.debug("Find APIs by user {}", (Object)username);
            Set publicApis = this.apiRepository.findByMember(null, null, Visibility.PUBLIC);
            Set restrictedApis = this.apiRepository.findByMember(null, null, Visibility.RESTRICTED);
            Set privateApis = this.apiRepository.findByMember(username, null, Visibility.PRIVATE);
            HashSet<ApiEntity> apis = new HashSet<ApiEntity>(publicApis.size() + restrictedApis.size() + privateApis.size());
            apis.addAll(publicApis.stream().map(this::convert).collect(Collectors.toSet()));
            apis.addAll(restrictedApis.stream().map(this::convert).collect(Collectors.toSet()));
            apis.addAll(privateApis.stream().map(this::convert).collect(Collectors.toSet()));
            return apis;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find APIs for user {}", (Object)username, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find APIs for user " + username, ex);
        }
    }

    @Override
    public int countByApplication(String applicationId) {
        try {
            this.LOGGER.debug("Find APIs by application {}", (Object)applicationId);
            Set applicationApiKeys = this.apiKeyRepository.findByApplication(applicationId);
            return (int)applicationApiKeys.stream().map(apiKey -> apiKey.getApi()).distinct().count();
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all APIs", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs", ex);
        }
    }

    @Override
    public ApiEntity update(String apiId, UpdateApiEntity updateApiEntity) {
        try {
            this.LOGGER.debug("Update API {}", (Object)apiId);
            Optional optApiToUpdate = this.apiRepository.findById((Object)apiId);
            if (!optApiToUpdate.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            io.gravitee.repository.management.model.Api apiToUpdate = (io.gravitee.repository.management.model.Api)optApiToUpdate.get();
            io.gravitee.repository.management.model.Api api = this.convert(apiId, updateApiEntity);
            if (api != null) {
                api.setId(apiId.trim());
                api.setUpdatedAt(new Date());
                api.setDeployedAt(apiToUpdate.getDeployedAt());
                api.setCreatedAt(apiToUpdate.getCreatedAt());
                api.setLifecycleState(apiToUpdate.getLifecycleState());
                io.gravitee.repository.management.model.Api updatedApi = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
                return this.convert(updatedApi);
            }
            this.LOGGER.error("Unable to update API {} because of previous error.");
            throw new TechnicalManagementException("Unable to update API " + apiId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update API " + apiId, ex);
        }
    }

    @Override
    public void delete(String apiName) {
        ApiEntity api = this.findById(apiName);
        try {
            this.LOGGER.debug("Delete API {}", (Object)apiName);
            if (api.getState() == Lifecycle.State.STARTED) {
                throw new ApiRunningStateException(apiName);
            }
            Set keys = this.apiKeyRepository.findByApi(apiName);
            keys.forEach(apiKey -> {
                try {
                    this.apiKeyRepository.delete(apiKey.getKey());
                }
                catch (TechnicalException e) {
                    this.LOGGER.error("An error occurs while deleting API Key {}", (Object)apiKey.getKey(), (Object)e);
                }
            });
            Set<EventEntity> events = this.eventService.findByApi(apiName);
            events.forEach(event -> this.eventService.delete(event.getId()));
            this.apiRepository.delete((Object)apiName);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete API {}", (Object)apiName, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete API " + apiName, ex);
        }
    }

    @Override
    public void start(String apiId, String username) {
        try {
            this.LOGGER.debug("Start API {}", (Object)apiId);
            this.updateLifecycle(apiId, LifecycleState.STARTED, username);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to start API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to start API " + apiId, ex);
        }
    }

    @Override
    public void stop(String apiId, String username) {
        try {
            this.LOGGER.debug("Stop API {}", (Object)apiId);
            this.updateLifecycle(apiId, LifecycleState.STOPPED, username);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to stop API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to stop API " + apiId, ex);
        }
    }

    @Override
    public Set<MemberEntity> getMembers(String apiId, io.gravitee.management.model.MembershipType membershipType) {
        try {
            this.LOGGER.debug("Get members for API {}", (Object)apiId);
            Collection membersRepo = this.apiRepository.getMembers(apiId, membershipType == null ? null : MembershipType.valueOf((String)membershipType.toString()));
            HashSet<MemberEntity> members = new HashSet<MemberEntity>(membersRepo.size());
            members.addAll(membersRepo.stream().map(member -> this.convert((Membership)member)).collect(Collectors.toSet()));
            return members;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get members for API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get members for API " + apiId, ex);
        }
    }

    @Override
    public MemberEntity getMember(String apiId, String username) {
        try {
            this.LOGGER.debug("Get membership for API {} and user {}", (Object)apiId, (Object)username);
            Membership membership = this.apiRepository.getMember(apiId, username);
            if (membership != null) {
                return this.convert(membership);
            }
            return null;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get membership for API {} and user", new Object[]{apiId, username, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for API " + apiId + " and user " + username, ex);
        }
    }

    @Override
    public void addOrUpdateMember(String api, String username, io.gravitee.management.model.MembershipType membershipType) {
        try {
            this.LOGGER.debug("Add or update a new member for API {}", (Object)api);
            UserEntity user = this.userService.findByName(username);
            this.apiRepository.saveMember(api, username, MembershipType.valueOf((String)membershipType.toString()));
            if (user.getEmail() != null && !user.getEmail().isEmpty()) {
                this.emailService.sendEmailNotification(new EmailNotificationBuilder().to(user.getEmail()).subject("Subscription to API " + api).content("apiMember.html").params((Map)ImmutableMap.of((Object)"api", (Object)api, (Object)"username", (Object)username)).build());
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to add or update member for API {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to add or update member for API " + api, ex);
        }
    }

    @Override
    public void deleteMember(String api, String username) {
        try {
            this.LOGGER.debug("Delete member {} for API {}", (Object)username, (Object)api);
            this.apiRepository.deleteMember(api, username);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete member {} for API {}", new Object[]{username, api, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete member " + username + " for API " + api, ex);
        }
    }

    @Override
    public boolean isAPISynchronized(String apiId) {
        try {
            ApiEntity api = this.findById(apiId);
            Set<EventEntity> events = this.eventService.findByType(Arrays.asList(EventType.PUBLISH_API, EventType.UNPUBLISH_API));
            List eventsSorted = events.stream().sorted((e1, e2) -> e1.getCreatedAt().compareTo(e2.getCreatedAt())).collect(Collectors.toList());
            Collections.reverse(eventsSorted);
            for (EventEntity event : eventsSorted) {
                JsonNode node = this.objectMapper.readTree(event.getPayload());
                io.gravitee.repository.management.model.Api payloadEntity = (io.gravitee.repository.management.model.Api)this.objectMapper.convertValue((Object)node, io.gravitee.repository.management.model.Api.class);
                if (!api.getId().equals(payloadEntity.getId())) continue;
                if (api.getUpdatedAt().compareTo(payloadEntity.getUpdatedAt()) <= 0) {
                    return true;
                }
                return this.apiSynchronizationProcessor.processCheckSynchronization(this.convert(payloadEntity), api);
            }
        }
        catch (Exception e) {
            this.LOGGER.error("An error occurs while trying to check API synchronization state {}", (Object)apiId, (Object)e);
            return false;
        }
        return false;
    }

    @Override
    public ApiEntity deploy(String apiId, String username, EventType eventType) {
        try {
            this.LOGGER.debug("Deploy API : {}", (Object)apiId);
            return this.deployCurrentAPI(apiId, username, eventType);
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to deploy API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to deploy API: " + apiId, ex);
        }
    }

    @Override
    public ApiEntity rollback(String apiId, UpdateApiEntity api) {
        this.LOGGER.debug("Rollback API : {}", (Object)apiId);
        try {
            this.update(apiId, api);
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to rollback API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to rollback API: " + apiId, ex);
        }
        return null;
    }

    private ApiEntity deployCurrentAPI(String apiId, String username, EventType eventType) throws Exception {
        Optional api = this.apiRepository.findById((Object)apiId);
        if (api.isPresent()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.API_ID.getValue(), ((io.gravitee.repository.management.model.Api)api.get()).getId());
            properties.put(Event.EventProperties.USERNAME.getValue(), username);
            EventEntity event = this.eventService.create(eventType, this.objectMapper.writeValueAsString(api.get()), properties);
            if (event != null) {
                io.gravitee.repository.management.model.Api apiValue = (io.gravitee.repository.management.model.Api)api.get();
                apiValue.setDeployedAt(event.getCreatedAt());
                apiValue.setUpdatedAt(event.getCreatedAt());
                this.apiRepository.update((Object)apiValue);
            }
            return this.convert((io.gravitee.repository.management.model.Api)api.get());
        }
        throw new ApiNotFoundException(apiId);
    }

    private ApiEntity deployLastPublishedAPI(String apiId, String username, EventType eventType) throws TechnicalException {
        Optional<EventEntity> optEvent = this.eventService.findByApi(apiId).stream().filter(event -> EventType.PUBLISH_API.equals((Object)event.getType())).sorted((e1, e2) -> e2.getCreatedAt().compareTo(e1.getCreatedAt())).findFirst();
        try {
            if (optEvent.isPresent()) {
                EventEntity event2 = optEvent.get();
                JsonNode node = this.objectMapper.readTree(event2.getPayload());
                io.gravitee.repository.management.model.Api lastPublishedAPI = (io.gravitee.repository.management.model.Api)this.objectMapper.convertValue((Object)node, io.gravitee.repository.management.model.Api.class);
                lastPublishedAPI.setLifecycleState(this.convert(eventType));
                lastPublishedAPI.setUpdatedAt(new Date());
                lastPublishedAPI.setDeployedAt(lastPublishedAPI.getUpdatedAt());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.API_ID.getValue(), lastPublishedAPI.getId());
                properties.put(Event.EventProperties.USERNAME.getValue(), username);
                this.eventService.create(eventType, this.objectMapper.writeValueAsString((Object)lastPublishedAPI), properties);
                return this.convert(lastPublishedAPI);
            }
            throw new TechnicalException("No event found for API " + apiId);
        }
        catch (Exception e) {
            this.LOGGER.error("An error occurs while trying to deploy last published API {}", (Object)apiId, (Object)e);
            throw new TechnicalException("An error occurs while trying to deploy last published API " + apiId, (Throwable)e);
        }
    }

    @Override
    public String convertAsJsonForExport(String apiId) {
        ApiEntity apiEntity = this.findById(apiId);
        apiEntity.setId(null);
        apiEntity.setCreatedAt(null);
        apiEntity.setUpdatedAt(null);
        apiEntity.setDeployedAt(null);
        apiEntity.setPrimaryOwner(null);
        apiEntity.setState(null);
        try {
            return this.objectMapper.writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            this.LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public ApiEntity createWithDefinition(String apiDefinition, String username) {
        try {
            UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.readValue(apiDefinition, UpdateApiEntity.class);
            NewApiEntity newApiEntity = new NewApiEntity();
            newApiEntity.setName(importedApi.getName());
            newApiEntity.setVersion(importedApi.getVersion());
            newApiEntity.setDescription(importedApi.getDescription());
            newApiEntity.setProxy(importedApi.getProxy());
            ApiEntity apiEntity = this.create(newApiEntity, username);
            return this.update(apiEntity.getId(), importedApi);
        }
        catch (IOException e) {
            this.LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            return null;
        }
    }

    @Override
    public ApiEntity updateWithDefinition(ApiEntity apiEntity, String apiDefinition) {
        try {
            UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.readValue(apiDefinition, UpdateApiEntity.class);
            return this.update(apiEntity.getId(), importedApi);
        }
        catch (IOException e) {
            this.LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            return null;
        }
    }

    private void updateLifecycle(String apiId, LifecycleState lifecycleState, String username) throws TechnicalException {
        Optional optApi = this.apiRepository.findById((Object)apiId);
        if (optApi.isPresent()) {
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)optApi.get();
            api.setUpdatedAt(new Date());
            api.setLifecycleState(lifecycleState);
            this.apiRepository.update((Object)api);
            switch (lifecycleState) {
                case STARTED: {
                    this.deployLastPublishedAPI(apiId, username, EventType.START_API);
                    break;
                }
                case STOPPED: {
                    this.deployLastPublishedAPI(apiId, username, EventType.STOP_API);
                    break;
                }
            }
        } else {
            throw new ApiNotFoundException(apiId);
        }
    }

    private ApiEntity convert(io.gravitee.repository.management.model.Api api) {
        Optional<Membership> member;
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setName(api.getName());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        if (api.getDefinition() != null) {
            try {
                Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.setPaths(apiDefinition.getPaths());
                apiEntity.setMonitoring(apiDefinition.getMonitoring());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
            }
            catch (IOException ioe) {
                this.LOGGER.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setVersion(api.getVersion());
        apiEntity.setDescription(api.getDescription());
        LifecycleState lifecycleState = api.getLifecycleState();
        if (lifecycleState != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)lifecycleState.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(io.gravitee.management.model.Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if (api.getMembers() != null && (member = api.getMembers().stream().filter(membership -> MembershipType.PRIMARY_OWNER.equals((Object)membership.getMembershipType())).findFirst()).isPresent()) {
            User user = member.get().getUser();
            PrimaryOwnerEntity primaryOwnerEntity = new PrimaryOwnerEntity();
            primaryOwnerEntity.setUsername(user.getUsername());
            primaryOwnerEntity.setLastname(user.getLastname());
            primaryOwnerEntity.setFirstname(user.getFirstname());
            primaryOwnerEntity.setEmail(user.getEmail());
            apiEntity.setPrimaryOwner(primaryOwnerEntity);
        }
        return apiEntity;
    }

    private io.gravitee.repository.management.model.Api convert(String apiId, NewApiEntity newApiEntity) {
        io.gravitee.repository.management.model.Api api = new io.gravitee.repository.management.model.Api();
        api.setName(newApiEntity.getName().trim());
        api.setVersion(newApiEntity.getVersion().trim());
        api.setDescription(newApiEntity.getDescription().trim());
        try {
            Api apiDefinition = new Api();
            apiDefinition.setId(apiId);
            apiDefinition.setName(newApiEntity.getName());
            apiDefinition.setVersion(newApiEntity.getVersion());
            apiDefinition.setProxy(newApiEntity.getProxy());
            HashMap<String, Path> paths = new HashMap<String, Path>();
            Path rootPath = new Path();
            Rule apiKeyRule = new Rule();
            Policy apiKeyPolicy = new Policy();
            apiKeyPolicy.setName("api-key");
            apiKeyPolicy.setConfiguration("{}");
            apiKeyRule.setPolicy(apiKeyPolicy);
            rootPath.getRules().add(apiKeyRule);
            paths.put("/", rootPath);
            apiDefinition.setPaths(paths);
            String definition = this.objectMapper.writeValueAsString((Object)apiDefinition);
            api.setDefinition(definition);
            return api;
        }
        catch (JsonProcessingException jse) {
            this.LOGGER.error("Unexpected error while generating API definition", (Throwable)jse);
            return null;
        }
    }

    private io.gravitee.repository.management.model.Api convert(String apiId, UpdateApiEntity updateApiEntity) {
        io.gravitee.repository.management.model.Api api = new io.gravitee.repository.management.model.Api();
        if (updateApiEntity.getVisibility() != null) {
            api.setVisibility(Visibility.valueOf((String)updateApiEntity.getVisibility().toString()));
        }
        api.setVersion(updateApiEntity.getVersion().trim());
        api.setName(updateApiEntity.getName().trim());
        api.setDescription(updateApiEntity.getDescription().trim());
        try {
            Api apiDefinition = new Api();
            apiDefinition.setId(apiId);
            apiDefinition.setName(updateApiEntity.getName());
            apiDefinition.setVersion(updateApiEntity.getVersion());
            apiDefinition.setProxy(updateApiEntity.getProxy());
            apiDefinition.setPaths(updateApiEntity.getPaths());
            apiDefinition.setMonitoring(updateApiEntity.getMonitoring());
            apiDefinition.setProperties(updateApiEntity.getProperties());
            apiDefinition.setTags(updateApiEntity.getTags());
            String definition = this.objectMapper.writeValueAsString((Object)apiDefinition);
            api.setDefinition(definition);
            return api;
        }
        catch (JsonProcessingException jse) {
            this.LOGGER.error("Unexpected error while generating API definition", (Throwable)jse);
            return null;
        }
    }

    private MemberEntity convert(Membership membership) {
        MemberEntity member = new MemberEntity();
        member.setUser(membership.getUser().getUsername());
        member.setCreatedAt(membership.getCreatedAt());
        member.setUpdatedAt(membership.getUpdatedAt());
        member.setType(io.gravitee.management.model.MembershipType.valueOf((String)membership.getMembershipType().toString()));
        return member;
    }

    private LifecycleState convert(EventType eventType) {
        LifecycleState lifecycleState = null;
        switch (eventType) {
            case START_API: {
                lifecycleState = LifecycleState.STARTED;
                break;
            }
            case STOP_API: {
                lifecycleState = LifecycleState.STOPPED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EventType " + eventType.toString() + " to convert EventType into Lifecycle");
            }
        }
        return lifecycleState;
    }
}

