/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.management.service.impl;

import io.gravitee.management.model.analytics.Bucket;
import io.gravitee.management.model.analytics.HealthAnalytics;
import io.gravitee.management.model.analytics.HistogramAnalytics;
import io.gravitee.management.service.AnalyticsService;
import io.gravitee.repository.analytics.api.AnalyticsRepository;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.HitsByApiKeyQuery;
import io.gravitee.repository.analytics.query.HitsByApiQuery;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.Query;
import io.gravitee.repository.analytics.query.QueryBuilders;
import io.gravitee.repository.analytics.query.response.HealthResponse;
import io.gravitee.repository.analytics.query.response.histogram.Data;
import io.gravitee.repository.analytics.query.response.histogram.HistogramResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsServiceImpl
implements AnalyticsService {
    private final Logger logger = LoggerFactory.getLogger(AnalyticsServiceImpl.class);
    @Autowired
    private AnalyticsRepository analyticsRepository;

    @Override
    public HistogramAnalytics apiHits(String apiId, long from, long to, long interval) {
        return this.apiHits(HitsByApiQuery.Type.HITS, apiId, from, to, interval);
    }

    @Override
    public HistogramAnalytics apiHitsByStatus(String apiId, long from, long to, long interval) {
        return this.apiHits(HitsByApiQuery.Type.HITS_BY_STATUS, apiId, from, to, interval);
    }

    @Override
    public HistogramAnalytics apiHitsByLatency(String apiId, long from, long to, long interval) {
        return this.apiHits(HitsByApiQuery.Type.HITS_BY_LATENCY, apiId, from, to, interval);
    }

    @Override
    public HistogramAnalytics apiHitsByApiKey(String apiId, long from, long to, long interval) {
        return this.apiHits(HitsByApiQuery.Type.HITS_BY_APIKEY, apiId, from, to, interval);
    }

    @Override
    public HistogramAnalytics apiHitsByPayloadSize(String apiId, long from, long to, long interval) {
        return this.apiHits(HitsByApiQuery.Type.HITS_BY_PAYLOAD_SIZE, apiId, from, to, interval);
    }

    @Override
    public HistogramAnalytics apiKeyHits(String apiKey, long from, long to, long interval) {
        return this.apiKeyHits(HitsByApiKeyQuery.Type.HITS, apiKey, from, to, interval);
    }

    @Override
    public HistogramAnalytics apiKeyHitsByStatus(String apiKey, long from, long to, long interval) {
        return this.apiKeyHits(HitsByApiKeyQuery.Type.HITS_BY_STATUS, apiKey, from, to, interval);
    }

    @Override
    public HistogramAnalytics apiKeyHitsByLatency(String apiKey, long from, long to, long interval) {
        return this.apiKeyHits(HitsByApiKeyQuery.Type.HITS_BY_LATENCY, apiKey, from, to, interval);
    }

    @Override
    public HealthAnalytics health(String api, long from, long to, long interval) {
        this.logger.debug("Run health query for API '{}'", (Object)api);
        try {
            return this.convert(this.analyticsRepository.query(api, interval, from, to));
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for health data.", (Throwable)ex);
            return null;
        }
    }

    private HistogramAnalytics apiKeyHits(HitsByApiKeyQuery.Type type, String apiKey, long from, long to, long interval) {
        this.logger.debug("Run analytics query {} for API key '{}'", (Object)type, (Object)apiKey);
        try {
            return this.runHistoricalQuery((Query<HistogramResponse>)QueryBuilders.query().hitsByApiKey(apiKey).period(DateRangeBuilder.between((long)from, (long)to)).interval(IntervalBuilder.interval((long)interval)).type(type).build(), from, interval);
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for analytics data.", (Throwable)ex);
            return null;
        }
    }

    private HistogramAnalytics apiHits(HitsByApiQuery.Type type, String apiId, long from, long to, long interval) {
        this.logger.debug("Run analytics query {} for API '{}'", (Object)type, (Object)apiId);
        try {
            return this.runHistoricalQuery((Query<HistogramResponse>)QueryBuilders.query().hitsByApi(apiId).period(DateRangeBuilder.between((long)from, (long)to)).interval(IntervalBuilder.interval((long)interval)).type(type).build(), from, interval);
        }
        catch (Exception ex) {
            this.logger.error("An unexpected error occurs while searching for analytics data.", (Throwable)ex);
            return null;
        }
    }

    private HistogramAnalytics runHistoricalQuery(Query<HistogramResponse> query, long from, long interval) throws Exception {
        return this.convert((HistogramResponse)this.analyticsRepository.query(query), from, interval);
    }

    private HistogramAnalytics convert(HistogramResponse histogramResponse, long from, long interval) {
        HistogramAnalytics analytics = new HistogramAnalytics();
        analytics.setTimestamps(histogramResponse.timestamps());
        for (io.gravitee.repository.analytics.query.response.histogram.Bucket bucket : histogramResponse.values()) {
            Bucket analyticsBucket = this.convertBucket(analytics.getTimestamps(), from, interval, bucket);
            analytics.getValues().add(analyticsBucket);
        }
        return analytics;
    }

    private Bucket convertBucket(List<Long> timestamps, long from, long interval, io.gravitee.repository.analytics.query.response.histogram.Bucket bucket) {
        Bucket analyticsBucket = new Bucket();
        analyticsBucket.setName(bucket.name());
        for (io.gravitee.repository.analytics.query.response.histogram.Bucket bucket2 : bucket.buckets()) {
            analyticsBucket.getBuckets().add(this.convertBucket(timestamps, from, interval, bucket2));
        }
        for (Map.Entry entry : bucket.data().entrySet()) {
            Bucket analyticsDataBucket = new Bucket();
            analyticsDataBucket.setName((String)entry.getKey());
            long[] values = new long[timestamps.size()];
            for (Data data : (List)entry.getValue()) {
                values[(int)((data.timestamp() - from) / interval)] = data.count();
            }
            analyticsDataBucket.setData(values);
            analyticsBucket.getBuckets().add(analyticsDataBucket);
        }
        return analyticsBucket;
    }

    private HealthAnalytics convert(HealthResponse response) {
        HealthAnalytics healthAnalytics = new HealthAnalytics();
        healthAnalytics.setTimestamps(response.timestamps());
        healthAnalytics.setBuckets(response.buckets());
        return healthAnalytics;
    }
}

