/*
 * Copyright © 2015 The Gravitee team (http://gravitee.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gravitee.kubernetes.mapper;

/**
 * @author GraviteeSource Team
 */
public abstract class CustomResource<S> {

    private final String apiVersion;
    private final String kind;
    private final ObjectMeta metadata;
    private final S spec;

    protected CustomResource(GroupVersionKind groupVersionKind, ObjectMeta metadata, S spec) {
        this.apiVersion = groupVersionKind.group() + "/" + groupVersionKind.version();
        this.kind = groupVersionKind.kind();
        this.metadata = metadata;
        this.spec = spec;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public String getKind() {
        return kind;
    }

    public ObjectMeta getMetadata() {
        return metadata;
    }

    public S getSpec() {
        return spec;
    }
}
