/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.policy;

public class SecurityToken {
    private String tokenType;
    private String tokenValue;
    private boolean invalid;

    public static SecurityToken none() {
        return SecurityToken.builder().tokenType(TokenType.NONE.name()).build();
    }

    public static SecurityToken forApiKey(String apiKey) {
        return SecurityToken.builder().tokenType(TokenType.API_KEY.name()).tokenValue(apiKey).build();
    }

    public static SecurityToken forClientId(String clientId) {
        return SecurityToken.builder().tokenType(TokenType.CLIENT_ID.name()).tokenValue(clientId).build();
    }

    public static SecurityToken invalid(TokenType tokenType) {
        return SecurityToken.builder().tokenType(tokenType.name()).invalid(true).build();
    }

    SecurityToken(String tokenType, String tokenValue, boolean invalid) {
        this.tokenType = tokenType;
        this.tokenValue = tokenValue;
        this.invalid = invalid;
    }

    public static SecurityTokenBuilder builder() {
        return new SecurityTokenBuilder();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String toString() {
        return "SecurityToken(tokenType=" + this.getTokenType() + ", tokenValue=" + this.getTokenValue() + ", invalid=" + this.isInvalid() + ")";
    }

    public static class SecurityTokenBuilder {
        private String tokenType;
        private String tokenValue;
        private boolean invalid;

        SecurityTokenBuilder() {
        }

        public SecurityTokenBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public SecurityTokenBuilder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public SecurityTokenBuilder invalid(boolean invalid) {
            this.invalid = invalid;
            return this;
        }

        public SecurityToken build() {
            return new SecurityToken(this.tokenType, this.tokenValue, this.invalid);
        }

        public String toString() {
            return "SecurityToken.SecurityTokenBuilder(tokenType=" + this.tokenType + ", tokenValue=" + this.tokenValue + ", invalid=" + this.invalid + ")";
        }
    }

    public static enum TokenType {
        CLIENT_ID,
        API_KEY,
        NONE;

    }
}

