/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.reactive.api.exception.PluginConfigurationException;
import io.gravitee.node.api.configuration.Configuration;

public class PluginConfigurationHelper {
    private final Configuration configuration;
    private final ObjectMapper objectMapper;

    public Configuration getNodeConfiguration() {
        return this.configuration;
    }

    public <T> T readConfiguration(Class<T> configurationClass, String configuration) throws PluginConfigurationException {
        try {
            if (configuration == null) {
                return configurationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)this.objectMapper.readValue(configuration, configurationClass);
        }
        catch (Exception e) {
            throw new PluginConfigurationException("Failed to instantiate connector configuration", e);
        }
    }

    public PluginConfigurationHelper(Configuration configuration, ObjectMapper objectMapper) {
        this.configuration = configuration;
        this.objectMapper = objectMapper;
    }
}

