/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.el;

import io.gravitee.common.util.MultiValueMap;
import io.gravitee.gateway.api.el.EvaluableSSLSession;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.reactive.api.context.GenericRequest;
import java.util.Map;

public class EvaluableRequest {
    private final GenericRequest request;
    private String content;
    private Map<String, Object> jsonContent;
    private Map<String, Object> xmlContent;

    public EvaluableRequest(GenericRequest request) {
        this(request, null);
    }

    public EvaluableRequest(GenericRequest request, String content) {
        this.request = request;
        this.content = content;
    }

    public String getId() {
        return this.request.id();
    }

    public String getTransactionId() {
        return this.request.transactionId();
    }

    public String getUri() {
        return this.request.uri();
    }

    public String getPath() {
        return this.request.path();
    }

    public String[] getPaths() {
        return this.request.path().split("/");
    }

    public String getPathInfo() {
        return this.request.pathInfo();
    }

    public String[] getPathInfos() {
        return this.request.pathInfo().split("/");
    }

    public String getContextPath() {
        return this.request.contextPath();
    }

    public MultiValueMap<String, String> getParams() {
        return this.request.parameters();
    }

    public MultiValueMap<String, String> getPathParams() {
        return this.request.pathParameters();
    }

    public HttpHeaders getHeaders() {
        return this.request.headers();
    }

    public String getMethod() {
        return this.request.method().name();
    }

    public String getScheme() {
        return this.request.scheme();
    }

    public String getVersion() {
        return this.request.version().name();
    }

    public long getTimestamp() {
        return this.request.timestamp();
    }

    public String getRemoteAddress() {
        return this.request.localAddress();
    }

    public String getLocalAddress() {
        return this.request.localAddress();
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, Object> getJsonContent() {
        return this.jsonContent;
    }

    public EvaluableSSLSession getSsl() {
        return new EvaluableSSLSession(this.request.sslSession());
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setJsonContent(Map<String, Object> jsonContent) {
        this.jsonContent = jsonContent;
    }

    public Map<String, Object> getXmlContent() {
        return this.xmlContent;
    }

    public void setXmlContent(Map<String, Object> xmlContent) {
        this.xmlContent = xmlContent;
    }
}

