/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.proxy.builder;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.gateway.api.proxy.builder.ProxyRequestImpl;
import io.gravitee.gateway.api.proxy.ws.WebSocketProxyRequestImpl;
import java.util.regex.Pattern;

public class ProxyRequestBuilder {
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(https?:|wss?:|grpcs?:))[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private static final String URI_DUPLICATED_PATH_SEPARATOR = "//";
    private String uri;
    private MultiValueMap<String, String> parameters;
    private MultiValueMap<String, String> pathParameters;
    private HttpMethod method;
    private String rawMethod;
    private HttpHeaders headers;
    private final Request request;

    private ProxyRequestBuilder(Request request) {
        this.request = request;
    }

    public static ProxyRequestBuilder from(Request request) {
        ProxyRequestBuilder builder = new ProxyRequestBuilder(request);
        builder.uri(request.uri());
        builder.headers(request.headers());
        builder.method(request.method());
        builder.parameters(request.parameters());
        builder.pathParameters(request.pathParameters());
        return builder;
    }

    public ProxyRequestBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public ProxyRequestBuilder parameters(MultiValueMap<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ProxyRequestBuilder pathParameters(MultiValueMap<String, String> pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public ProxyRequestBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public ProxyRequestBuilder rawMethod(String rawMethod) {
        this.rawMethod = rawMethod;
        return this;
    }

    public ProxyRequestBuilder headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public ProxyRequest build() {
        ProxyRequestImpl proxyRequest = !this.request.isWebSocket() ? new ProxyRequestImpl(this.request) : new WebSocketProxyRequestImpl(this.request);
        if (this.uri.indexOf(URI_DUPLICATED_PATH_SEPARATOR, 8) != -1) {
            proxyRequest.setUri(DUPLICATE_SLASH_REMOVER.matcher(this.uri).replaceAll(URI_PATH_SEPARATOR));
        } else {
            proxyRequest.setUri(this.uri);
        }
        proxyRequest.setMethod(this.method);
        proxyRequest.setRawMethod(this.rawMethod);
        proxyRequest.setParameters(this.parameters);
        proxyRequest.setPathParameters(this.pathParameters);
        proxyRequest.setHeaders(this.headers);
        return proxyRequest;
    }
}

