/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.el;

import io.gravitee.common.http.HttpHeaders;
import io.gravitee.gateway.api.el.EvaluableRequest;
import io.gravitee.gateway.api.el.EvaluableResponse;
import io.gravitee.gateway.api.el.EvaluableSSLPrincipal;
import io.gravitee.gateway.api.el.EvaluableSSLSession;
import java.beans.Introspector;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;

public class EvaluableExtractor {
    public static void main(String[] args) throws IOException {
        new EvaluableExtractor().run();
    }

    public void run() throws IOException {
        String[] attrs;
        TreeMap<String, Object> all = new TreeMap<String, Object>();
        TreeMap request = new TreeMap();
        for (Method declaredMethod : EvaluableRequest.class.getDeclaredMethods()) {
            if (!declaredMethod.getName().startsWith("get")) continue;
            String name = Introspector.decapitalize(declaredMethod.getName().replace("get", ""));
            if (!name.equals("ssl")) {
                request.put(name, this.getChild(declaredMethod));
                continue;
            }
            TreeMap ssl = new TreeMap();
            Method[] methodArray = EvaluableSSLSession.class.getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method declaredSSLMethod = methodArray[i];
                if (!declaredSSLMethod.getName().startsWith("get")) continue;
                String sslAttributeName = Introspector.decapitalize(declaredSSLMethod.getName().replace("get", ""));
                if (!sslAttributeName.equals("client") && !sslAttributeName.equals("server")) {
                    ssl.put(sslAttributeName, this.getChild(declaredSSLMethod));
                    continue;
                }
                TreeMap<String, TreeMap<String, Object>> principal = new TreeMap<String, TreeMap<String, Object>>();
                for (Method declaredSSLPrincipalMethod : EvaluableSSLPrincipal.class.getDeclaredMethods()) {
                    String principalAttributeName;
                    if (declaredSSLPrincipalMethod.getName().startsWith("get")) {
                        principalAttributeName = Introspector.decapitalize(declaredSSLPrincipalMethod.getName().replace("get", ""));
                        principal.put(principalAttributeName, this.getChild(declaredSSLPrincipalMethod));
                        continue;
                    }
                    if (!declaredSSLPrincipalMethod.getName().startsWith("is")) continue;
                    principalAttributeName = Introspector.decapitalize(declaredSSLPrincipalMethod.getName().replace("is", ""));
                    principal.put(principalAttributeName, this.getChild(declaredSSLPrincipalMethod));
                }
                ssl.put(sslAttributeName, principal);
            }
            request.put(name, ssl);
        }
        all.put("request", request);
        HashMap<String[], TreeMap<String, Object>> response = new HashMap<String[], TreeMap<String, Object>>();
        for (Method declaredMethod : EvaluableResponse.class.getDeclaredMethods()) {
            if (!declaredMethod.getName().startsWith("get")) continue;
            String[] name = Introspector.decapitalize(declaredMethod.getName().replace("get", ""));
            response.put(name, this.getChild(declaredMethod));
        }
        all.put("response", response);
        HashMap<String, String> arrayOfStringType = new HashMap<String, String>();
        arrayOfStringType.put("_type", String[].class.getSimpleName());
        all.put("properties", arrayOfStringType);
        all.put("dictionaries", arrayOfStringType);
        all.put("endpoints", arrayOfStringType);
        HashMap context = new HashMap();
        HashMap attributes = new HashMap();
        for (String attr : attrs = new String[]{"context-path", "resolved-path", "application", "api", "user-id", "plan", "api-key"}) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("_type", String.class.getSimpleName());
            attributes.put(attr, m);
        }
        context.put("attributes", attributes);
        all.put("context", context);
        all.put("_enums", this.buildEnums());
        JSONObject o = new JSONObject(all);
        BufferedWriter writer = new BufferedWriter(new FileWriter("/tmp/grammar.json"));
        writer.write(o.toJSONString(JSONStyle.NO_COMPRESS));
        writer.close();
    }

    private Object buildEnums() {
        HashMap _enums = new HashMap();
        Field[] declaredFields = HttpHeaders.class.getDeclaredFields();
        _enums.put(HttpHeaders.class.getSimpleName(), Arrays.stream(declaredFields).filter(f -> Modifier.isPublic(f.getModifiers())).map(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                return field.getName();
            }
        }).collect(Collectors.toList()));
        return _enums;
    }

    private TreeMap<String, Object> getChild(Method declaredMethod) {
        Class<?> returnType = declaredMethod.getReturnType();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("_type", returnType.getSimpleName());
        return map;
    }
}

