/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.http;

import io.gravitee.common.util.LinkedCaseInsensitiveMap;
import io.gravitee.gateway.api.http.HttpHeaders;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
implements HttpHeaders {
    private final Map<String, List<String>> headers;

    DefaultHttpHeaders() {
        this.headers = new LinkedCaseInsensitiveMap(8);
    }

    private DefaultHttpHeaders(int initialCapacity) {
        this.headers = new LinkedCaseInsensitiveMap(initialCapacity);
    }

    DefaultHttpHeaders(HttpHeaders headers) {
        this(headers.size());
        headers.forEach(stringListEntry -> this.add((CharSequence)stringListEntry.getKey(), (CharSequence)stringListEntry.getValue()));
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public String get(CharSequence name) {
        List<String> headerValues = this.headers.get(name);
        return headerValues != null ? headerValues.get(0) : null;
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Set<String> names() {
        return this.headers.keySet();
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence value) {
        List<String> headerValues = this.headers.get(name);
        if (headerValues == null) {
            headerValues = new LinkedList<String>();
            this.headers.put((String)name, headerValues);
        }
        headerValues.add((String)value);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<CharSequence> values) {
        if (values != null) {
            LinkedList list = new LinkedList();
            values.forEach(charSequence -> list.add((String)charSequence));
            this.headers.put((String)name, list);
        }
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence value) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add((String)value);
        this.headers.put((String)name, headerValues);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<CharSequence> values) {
        if (values != null) {
            LinkedList list = new LinkedList();
            values.forEach(charSequence -> list.add((String)charSequence));
            this.headers.put((String)name, list);
        }
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    public boolean equals(Object o) {
        return this.headers.equals(o);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator<Map.Entry<String, List<String>>> entries = this.headers.entrySet().iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                final Map.Entry next = (Map.Entry)entries.next();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return (String)next.getKey();
                    }

                    @Override
                    public String getValue() {
                        return (String)((List)next.getValue()).get(0);
                    }

                    @Override
                    public String setValue(String value) {
                        throw new IllegalStateException();
                    }
                };
            }
        };
    }
}

