/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel.context;

import io.gravitee.el.TemplateContext;
import io.gravitee.el.spel.CachedExpression;
import io.gravitee.el.spel.context.SecuredEvaluationContext;
import io.gravitee.el.spel.function.json.JsonPathFunction;
import io.gravitee.el.spel.function.xml.XPathFunction;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.expression.EvaluationContext;

public class SpelTemplateContext
implements TemplateContext {
    protected static final Method JSON_PATH_EVAL_METHOD = BeanUtils.resolveSignature((String)"evaluate", JsonPathFunction.class);
    protected static final Method XPATH_EVAL_METHOD = BeanUtils.resolveSignature((String)"evaluate", XPathFunction.class);
    private final EvaluationContext context = new SecuredEvaluationContext();
    private Map<String, Object> deferredVariables;

    public SpelTemplateContext() {
        this.context.setVariable("jsonPath", (Object)JSON_PATH_EVAL_METHOD);
        this.context.setVariable("xpath", (Object)XPATH_EVAL_METHOD);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    @Override
    public void setDeferredVariable(String name, Completable deferred) {
        this.addDeferredVariable(name, deferred);
    }

    @Override
    public void setDeferredVariable(String name, Maybe<?> deferred) {
        this.addDeferredVariable(name, deferred);
    }

    @Override
    public void setDeferredVariable(String name, Single<?> deferred) {
        this.addDeferredVariable(name, deferred);
    }

    @Override
    public Object lookupVariable(String name) {
        return this.context.lookupVariable(name);
    }

    public EvaluationContext getContext() {
        return this.context;
    }

    public Single<EvaluationContext> evaluationContext(CachedExpression expression) {
        if (this.deferredVariables != null) {
            return Flowable.fromIterable(this.deferredVariables.entrySet()).filter(deferredEntry -> this.requiresDeferredVariable(expression, (Map.Entry<String, Object>)deferredEntry)).flatMapCompletable(e -> this.resolveDeferred((String)e.getKey(), e.getValue())).andThen((SingleSource)Single.just((Object)this.context));
        }
        return Single.just((Object)this.context);
    }

    private boolean requiresDeferredVariable(CachedExpression expression, Map.Entry<String, Object> deferredEntry) {
        return expression.getVariables().stream().anyMatch(variable -> variable.equals(deferredEntry.getKey()) || variable.startsWith((String)deferredEntry.getKey() + "."));
    }

    private Completable resolveDeferred(String key, Object deferred) {
        if (deferred instanceof Completable) {
            return (Completable)deferred;
        }
        if (deferred instanceof Maybe) {
            return ((Maybe)deferred).doOnSuccess(o -> this.context.setVariable(key, o)).ignoreElement();
        }
        if (deferred instanceof Single) {
            return ((Single)deferred).doOnSuccess(o -> this.context.setVariable(key, o)).ignoreElement();
        }
        return Completable.error((Throwable)new RuntimeException("Deferred EL variable unsupported" + deferred.getClass().getSimpleName()));
    }

    private void addDeferredVariable(String name, Object deferred) {
        Objects.requireNonNull(deferred, "Deferred EL variable cannot be null");
        if (this.deferredVariables == null) {
            this.deferredVariables = new HashMap<String, Object>();
        }
        this.deferredVariables.put(name, deferred);
    }
}

