/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.discovery.api.service;

import io.gravitee.discovery.api.ServiceDiscovery;
import io.gravitee.discovery.api.event.Event;
import io.gravitee.discovery.api.event.EventType;
import io.gravitee.discovery.api.service.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractServiceDiscovery<T extends Service>
implements ServiceDiscovery {
    private List<T> services = new ArrayList<T>();

    public Event registerEndpoint(T service) {
        this.services.add(service);
        return new Event((Service)service){
            final /* synthetic */ Service val$service;
            {
                this.val$service = service;
            }

            @Override
            public EventType type() {
                return EventType.REGISTER;
            }

            @Override
            public Service service() {
                return this.val$service;
            }
        };
    }

    public Event unregisterEndpoint(T service) {
        this.services.remove(service);
        return new Event((Service)service){
            final /* synthetic */ Service val$service;
            {
                this.val$service = service;
            }

            @Override
            public EventType type() {
                return EventType.UNREGISTER;
            }

            @Override
            public Service service() {
                return this.val$service;
            }
        };
    }

    public T getService(Predicate<T> predicate) {
        return (T)((Service)this.services.stream().filter(predicate).findAny().orElse(null));
    }

    public List<T> getServices(Predicate<T> predicate) {
        return this.services.stream().filter(predicate).collect(Collectors.toList());
    }
}

