/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProvider;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.event.ApiEvent;
import io.gravitee.rest.api.services.dynamicproperties.DynamicPropertyScheduler;
import io.gravitee.rest.api.services.dynamicproperties.provider.http.HttpProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DynamicPropertiesService
extends AbstractService
implements EventListener<ApiEvent, Api> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicPropertiesService.class);
    final Map<ApiEntity, DynamicPropertyScheduler> schedulers = new HashMap<ApiEntity, DynamicPropertyScheduler>();
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private EventManager eventManager;
    @Autowired
    private ApiService apiService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private Node node;

    protected String name() {
        return "Dynamic Properties Service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, ApiEvent.class);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.eventManager.unsubscribeForEvents((EventListener)this, ApiEvent.class);
    }

    public void onEvent(Event<ApiEvent, Api> event) {
        Api eventPayload = (Api)event.content();
        if (eventPayload.getDefinitionVersion() != null && eventPayload.getDefinitionVersion() == DefinitionVersion.V4) {
            return;
        }
        ApiEntity apiEntity = this.convert(eventPayload);
        if (apiEntity.getDefinitionVersion() == null || apiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            switch ((ApiEvent)event.type()) {
                case DEPLOY: {
                    this.startDynamicProperties(apiEntity);
                    break;
                }
                case UNDEPLOY: {
                    this.stopDynamicProperties(apiEntity);
                    break;
                }
                case UPDATE: {
                    this.update(apiEntity);
                }
            }
        } else {
            log.warn("Dynamic properties service is not compatible with API v4");
        }
    }

    private void update(ApiEntity api) {
        ApiEntity currentApi = this.schedulers.keySet().stream().filter(entity -> entity.equals((Object)api)).findFirst().orElse(null);
        if (currentApi == null) {
            this.startDynamicProperties(api);
        } else {
            DynamicPropertyService currentDynamicPropertyService = (DynamicPropertyService)currentApi.getServices().get(DynamicPropertyService.class);
            DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
            if (currentDynamicPropertyService != null) {
                if (!dynamicPropertyService.isEnabled()) {
                    this.stopDynamicProperties(api);
                } else if (!Objects.equals(currentDynamicPropertyService, dynamicPropertyService)) {
                    this.stopDynamicProperties(api);
                    this.startDynamicProperties(api);
                }
            } else {
                this.startDynamicProperties(api);
            }
        }
    }

    private void startDynamicProperties(ApiEntity api) {
        if (api.getState() != Lifecycle.State.STARTED) {
            return;
        }
        DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
        if (dynamicPropertyService == null || !dynamicPropertyService.isEnabled()) {
            log.info("{} Dynamic properties service is disabled for API: {} [{}]", new Object[]{api.getId(), api.getName(), api.getVersion()});
            return;
        }
        EnvironmentEntity environment = this.environmentService.findById(api.getEnvironmentId());
        ExecutionContext executionContext = new ExecutionContext(environment.getOrganizationId(), environment.getId());
        DynamicPropertyScheduler scheduler = DynamicPropertyScheduler.builder().clusterManager(this.clusterManager).schedule(dynamicPropertyService.getSchedule()).api(api).apiConverter(this.apiConverter).apiService(this.apiService).executionContext(executionContext).build();
        if (DynamicPropertyProvider.HTTP == dynamicPropertyService.getProvider()) {
            HttpProvider provider = new HttpProvider(dynamicPropertyService.getConfiguration(), this.httpClientService, this.node);
            log.info("{} Add a scheduled task to poll dynamic properties each {}", (Object)api.getId(), (Object)dynamicPropertyService.getSchedule());
            scheduler.schedule(provider);
            this.schedulers.put(api, scheduler);
        }
    }

    private void stopDynamicProperties(ApiEntity api) {
        DynamicPropertyScheduler scheduler = this.schedulers.remove(api);
        if (scheduler != null) {
            log.info("{} Stopping dynamic properties service for API: {} [{}]", new Object[]{api.getId(), api.getName(), api.getVersion()});
            scheduler.cancel();
        }
    }

    private ApiEntity convert(Api api) {
        if (api.getEnvironmentId() == null) {
            api.setEnvironmentId(GraviteeContext.getDefaultEnvironment());
        }
        return this.apiConverter.toApiEntity(api, null);
    }
}

