/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.io.Serializable;
import java.util.Date;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;

public class CronHandler
implements Handler<Long>,
Serializable {
    private final transient Vertx vertx;
    private final CronTrigger expression;
    private transient Handler<Long> handler;
    private long timerId;

    public CronHandler(Vertx vertx, String cronExpression) {
        this.vertx = vertx;
        this.expression = new CronTrigger(cronExpression);
    }

    public CronHandler schedule(Handler<Long> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler is null.");
        }
        this.handler = handler;
        long delay = this.getDelay(this.expression);
        this.timerId = this.vertx.setTimer(delay, (Handler)this);
        return this;
    }

    private long getDelay(CronTrigger expression) {
        Date next = expression.nextExecutionTime((TriggerContext)new SimpleTriggerContext());
        return next.getTime() - new Date().getTime();
    }

    public void handle(Long timerId) {
        long delay = this.getDelay(this.expression);
        this.timerId = this.vertx.setTimer(delay, (Handler)this);
        this.handler.handle((Object)timerId);
    }

    public void cancel() {
        this.vertx.cancelTimer(this.timerId);
    }

    public long getTimerId() {
        return this.timerId;
    }
}

