/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProvider;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.node.api.Node;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.event.ApiEvent;
import io.gravitee.rest.api.services.dynamicproperties.CronHandler;
import io.gravitee.rest.api.services.dynamicproperties.DynamicPropertyUpdater;
import io.gravitee.rest.api.services.dynamicproperties.provider.http.HttpProvider;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DynamicPropertiesService
extends AbstractService
implements EventListener<ApiEvent, Api> {
    final Map<ApiEntity, CronHandler> handlers = new HashMap<ApiEntity, CronHandler>();
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicPropertiesService.class);
    @Autowired
    private EventManager eventManager;
    @Autowired
    private ApiService apiService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private Vertx vertx;
    @Autowired
    private Node node;
    @Autowired
    @Qualifier(value="dynamicPropertiesExecutor")
    private Executor executor;

    protected String name() {
        return "Dynamic Properties Service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, ApiEvent.class);
    }

    public void onEvent(Event<ApiEvent, Api> event) {
        Api eventPayload = (Api)event.content();
        if (eventPayload.getDefinitionVersion() != null && eventPayload.getDefinitionVersion() == DefinitionVersion.V4) {
            return;
        }
        ApiEntity apiEntity = this.convert(eventPayload);
        if (apiEntity.getDefinitionVersion() == null || apiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            switch ((ApiEvent)event.type()) {
                case DEPLOY: {
                    this.startDynamicProperties(apiEntity);
                    break;
                }
                case UNDEPLOY: {
                    this.stopDynamicProperties(apiEntity);
                    break;
                }
                case UPDATE: {
                    this.update(apiEntity);
                }
            }
        } else {
            LOGGER.warn("Dynamic properties service is not compatible with API v4");
        }
    }

    private void update(ApiEntity api) {
        ApiEntity currentApi = this.handlers.keySet().stream().filter(entity -> entity.equals((Object)api)).findFirst().orElse(null);
        if (currentApi == null) {
            this.startDynamicProperties(api);
        } else {
            DynamicPropertyService currentDynamicPropertyService = (DynamicPropertyService)currentApi.getServices().get(DynamicPropertyService.class);
            DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
            if (currentDynamicPropertyService != null) {
                if (!dynamicPropertyService.isEnabled()) {
                    this.stopDynamicProperties(api);
                } else if (!Objects.equals(currentDynamicPropertyService, dynamicPropertyService)) {
                    this.stopDynamicProperties(api);
                    this.startDynamicProperties(api);
                }
            } else {
                this.startDynamicProperties(api);
            }
        }
    }

    private void startDynamicProperties(ApiEntity api) {
        if (api.getState() != Lifecycle.State.STARTED) {
            return;
        }
        DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
        if (dynamicPropertyService == null || !dynamicPropertyService.isEnabled()) {
            LOGGER.info("{} Dynamic properties service is disabled for API: {} [{}]", new Object[]{api.getId(), api.getName(), api.getVersion()});
            return;
        }
        EnvironmentEntity environment = this.environmentService.findById(api.getEnvironmentId());
        ExecutionContext executionContext = new ExecutionContext(environment.getOrganizationId(), environment.getId());
        DynamicPropertyUpdater updater = new DynamicPropertyUpdater(api, this.executor, executionContext);
        if (dynamicPropertyService.getProvider() == DynamicPropertyProvider.HTTP) {
            HttpProvider provider = new HttpProvider(dynamicPropertyService);
            provider.setHttpClientService(this.httpClientService);
            provider.setNode(this.node);
            provider.setExecutor(this.executor);
            updater.setProvider(provider);
            updater.setApiService(this.apiService);
            updater.setApiConverter(this.apiConverter);
            LOGGER.info("{} Add a scheduled task to poll dynamic properties each {}", (Object)api.getId(), (Object)dynamicPropertyService.getSchedule());
            updater.handle(null);
            CronHandler cronHandler = new CronHandler(this.vertx, dynamicPropertyService.getSchedule());
            cronHandler.schedule(updater);
            this.handlers.put(api, cronHandler);
        }
    }

    private void stopDynamicProperties(ApiEntity api) {
        CronHandler handler = this.handlers.remove(api);
        if (handler != null) {
            LOGGER.info("{} Stopping dynamic properties service for API: {} [{}]", new Object[]{api.getId(), api.getName(), api.getVersion()});
            handler.cancel();
        }
    }

    private ApiEntity convert(Api api) {
        if (api.getEnvironmentId() == null) {
            api.setEnvironmentId(GraviteeContext.getDefaultEnvironment());
        }
        return this.apiConverter.toApiEntity(api, null);
    }
}

