/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProvider;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.definition.model.services.schedule.Trigger;
import io.gravitee.node.api.Node;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.event.ApiEvent;
import io.gravitee.rest.api.services.dynamicproperties.DynamicPropertyUpdater;
import io.gravitee.rest.api.services.dynamicproperties.provider.http.HttpProvider;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DynamicPropertiesService
extends AbstractService
implements EventListener<ApiEvent, ApiEntity> {
    private final Logger logger = LoggerFactory.getLogger(DynamicPropertiesService.class);
    @Autowired
    private EventManager eventManager;
    @Autowired
    private ApiService apiService;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private Vertx vertx;
    @Autowired
    private Node node;
    final Map<ApiEntity, Long> timers = new HashMap<ApiEntity, Long>();

    protected String name() {
        return "Dynamic Properties Service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, ApiEvent.class);
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void onEvent(Event<ApiEvent, ApiEntity> event) {
        ApiEntity api = (ApiEntity)event.content();
        switch ((ApiEvent)event.type()) {
            case DEPLOY: {
                this.startDynamicProperties(api);
                break;
            }
            case UNDEPLOY: {
                this.stopDynamicProperties(api);
                break;
            }
            case UPDATE: {
                this.update(api);
            }
        }
    }

    private void update(ApiEntity api) {
        ApiEntity currentApi = this.timers.keySet().stream().filter(entity -> entity.equals((Object)api)).findFirst().orElse(null);
        if (currentApi == null) {
            this.startDynamicProperties(api);
        } else {
            DynamicPropertyService currentDynamicPropertyService = (DynamicPropertyService)currentApi.getServices().get(DynamicPropertyService.class);
            DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
            if (currentDynamicPropertyService != null) {
                if (!Objects.equals(currentDynamicPropertyService, dynamicPropertyService)) {
                    this.stopDynamicProperties(api);
                    this.startDynamicProperties(api);
                }
            } else {
                this.startDynamicProperties(api);
            }
        }
    }

    private void startDynamicProperties(ApiEntity api) {
        if (api.getState() == Lifecycle.State.STARTED) {
            DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
            if (dynamicPropertyService != null && dynamicPropertyService.isEnabled()) {
                DynamicPropertyUpdater updater = new DynamicPropertyUpdater(api);
                if (dynamicPropertyService.getProvider() == DynamicPropertyProvider.HTTP) {
                    HttpProvider provider = new HttpProvider(dynamicPropertyService);
                    provider.setHttpClientService(this.httpClientService);
                    provider.setNode(this.node);
                    updater.setProvider(provider);
                    updater.setApiService(this.apiService);
                    this.logger.info("Add a scheduled task to poll dynamic properties each {} {} ", (Object)dynamicPropertyService.getTrigger().getRate(), (Object)dynamicPropertyService.getTrigger().getUnit());
                    updater.handle(null);
                    long periodicTimer = this.vertx.setPeriodic(this.getDelayMillis(dynamicPropertyService.getTrigger()), (Handler)updater);
                    this.timers.put(api, periodicTimer);
                }
            } else {
                this.logger.info("Dynamic properties service is disabled for: {} [{}]", (Object)api.getName(), (Object)api.getVersion());
            }
        }
    }

    private long getDelayMillis(Trigger trigger) {
        switch (trigger.getUnit()) {
            case MILLISECONDS: {
                return trigger.getRate();
            }
            case SECONDS: {
                return trigger.getRate() * 1000L;
            }
            case MINUTES: {
                return trigger.getRate() * 1000L * 60L;
            }
            case HOURS: {
                return trigger.getRate() * 1000L * 60L * 60L;
            }
        }
        return -1L;
    }

    private void stopDynamicProperties(ApiEntity api) {
        Long timer = this.timers.remove(api);
        if (timer != null) {
            this.logger.info("Stop Dynamic properties service for API id[{}] name[{}]", (Object)api.getId(), (Object)api.getName());
            this.vertx.cancelTimer(timer.longValue());
        }
    }
}

