/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties;

import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.UserRoleEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.services.dynamicproperties.model.DynamicProperty;
import io.gravitee.rest.api.services.dynamicproperties.provider.Provider;
import io.vertx.core.Handler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPropertyUpdater
implements Handler<Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicPropertyUpdater.class);
    private final ApiEntity api;
    private final Executor executor;
    private Provider provider;
    private ApiService apiService;
    private ApiConverter apiConverter;

    public DynamicPropertyUpdater(ApiEntity api, Executor executor) {
        this.api = api;
        this.executor = executor;
    }

    private void authenticateAsAdmin() {
        UserRoleEntity adminRole = new UserRoleEntity();
        adminRole.setScope(RoleScope.ENVIRONMENT);
        adminRole.setName(SystemRole.ADMIN.name());
        SecurityContextHelper.authenticateAsSystem((String)"DynamicPropertyUpdater", Set.of(adminRole));
    }

    public void handle(Long event) {
        this.handle();
    }

    protected CompletableFuture<Collection<DynamicProperty>> handle() {
        LOGGER.debug("Running dynamic-properties poller for {}", (Object)this.api);
        return this.provider.get().whenCompleteAsync((dynamicProperties, throwable) -> {
            if (throwable != null) {
                LOGGER.error("[{}] Unexpected error while getting dynamic properties from provider: {}", new Object[]{this.api.getId(), this.provider.name(), throwable});
            } else if (dynamicProperties != null) {
                this.authenticateAsAdmin();
                this.update((Collection<DynamicProperty>)dynamicProperties);
            }
        }, this.executor);
    }

    private void update(Collection<DynamicProperty> dynamicProperties) {
        ApiEntity latestApi = this.apiService.findById(GraviteeContext.getExecutionContext(), this.api.getId());
        List properties = latestApi.getProperties() != null ? latestApi.getProperties().getProperties() : Collections.emptyList();
        List userDefinedProperties = properties.stream().filter(property -> !property.isDynamic()).collect(Collectors.toList());
        Map<String, Property> propertyMap = properties.stream().collect(Collectors.toMap(Property::getKey, property -> property));
        ArrayList<DynamicProperty> updatedProperties = new ArrayList<DynamicProperty>();
        boolean needToBeSaved = false;
        for (DynamicProperty dynamicProperty : dynamicProperties) {
            Property property2 = propertyMap.get(dynamicProperty.getKey());
            if (property2 == null || property2.isDynamic()) {
                updatedProperties.add(dynamicProperty);
            }
            if (property2 != null && (!property2.isDynamic() || property2.getValue().equals(dynamicProperty.getValue()))) continue;
            needToBeSaved = true;
        }
        if (needToBeSaved) {
            updatedProperties.addAll(userDefinedProperties);
            List sortedUpdatedProperties = updatedProperties.stream().sorted(Comparator.comparing(Property::getKey)).collect(Collectors.toList());
            Properties apiProperties = new Properties();
            try {
                apiProperties.setProperties(sortedUpdatedProperties);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            latestApi.setProperties(apiProperties);
            boolean isSync = this.apiService.isSynchronized(GraviteeContext.getExecutionContext(), this.api.getId());
            try {
                LOGGER.debug("Updating API [{}]", (Object)latestApi.getId());
                this.apiService.update(GraviteeContext.getExecutionContext(), latestApi.getId(), this.apiConverter.toUpdateApiEntity(latestApi), false, false);
                LOGGER.debug("API [{}] has been updated", (Object)latestApi.getId());
                if (!(!isSync || updatedProperties.containsAll(properties) && properties.containsAll(updatedProperties))) {
                    LOGGER.debug("Property change detected, API [{}] is about to be deployed", (Object)this.api.getId());
                    ApiDeploymentEntity deployEntity = new ApiDeploymentEntity();
                    deployEntity.setDeploymentLabel("Dynamic properties sync");
                    this.apiService.deploy(GraviteeContext.getExecutionContext(), latestApi.getId(), "dynamic-property-updater", EventType.PUBLISH_API, deployEntity);
                    LOGGER.debug("API [{}] as been deployed", (Object)this.api.getId());
                }
            }
            catch (TechnicalManagementException e) {
                LOGGER.error("An error occurred while updating synchronizing properties, the API has not been deployed", (Throwable)e);
            }
        }
    }

    public void setApiService(ApiService apiService) {
        this.apiService = apiService;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setApiConverter(ApiConverter apiConverter) {
        this.apiConverter = apiConverter;
    }
}

