/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProvider;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.node.api.Node;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.event.ApiEvent;
import io.gravitee.rest.api.services.dynamicproperties.CronHandler;
import io.gravitee.rest.api.services.dynamicproperties.DynamicPropertyUpdater;
import io.gravitee.rest.api.services.dynamicproperties.provider.http.HttpProvider;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DynamicPropertiesService
extends AbstractService
implements EventListener<ApiEvent, GenericApiEntity> {
    final Map<ApiEntity, CronHandler> handlers = new HashMap<ApiEntity, CronHandler>();
    private final Logger logger = LoggerFactory.getLogger(DynamicPropertiesService.class);
    @Autowired
    private EventManager eventManager;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private Vertx vertx;
    @Autowired
    private Node node;
    @Autowired
    @Qualifier(value="dynamicPropertiesExecutor")
    private Executor executor;

    protected String name() {
        return "Dynamic Properties Service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, ApiEvent.class);
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void onEvent(Event<ApiEvent, GenericApiEntity> event) {
        GenericApiEntity genericApiEntity = (GenericApiEntity)event.content();
        if (genericApiEntity.getDefinitionVersion() == null || genericApiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            ApiEntity api = (ApiEntity)genericApiEntity;
            switch ((ApiEvent)event.type()) {
                case DEPLOY: {
                    this.startDynamicProperties(api);
                    break;
                }
                case UNDEPLOY: {
                    this.stopDynamicProperties(api);
                    break;
                }
                case UPDATE: {
                    this.update(api);
                }
            }
        } else {
            this.logger.warn("Dynamic properties service is not compatible with api V4");
        }
    }

    private void update(ApiEntity api) {
        ApiEntity currentApi = this.handlers.keySet().stream().filter(entity -> entity.equals((Object)api)).findFirst().orElse(null);
        if (currentApi == null) {
            this.startDynamicProperties(api);
        } else {
            DynamicPropertyService currentDynamicPropertyService = (DynamicPropertyService)currentApi.getServices().get(DynamicPropertyService.class);
            DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
            if (currentDynamicPropertyService != null) {
                if (!dynamicPropertyService.isEnabled()) {
                    this.stopDynamicProperties(api);
                } else if (!Objects.equals(currentDynamicPropertyService, dynamicPropertyService)) {
                    this.stopDynamicProperties(api);
                    this.startDynamicProperties(api);
                }
            } else {
                this.startDynamicProperties(api);
            }
        }
    }

    private void startDynamicProperties(ApiEntity api) {
        if (api.getState() == Lifecycle.State.STARTED) {
            DynamicPropertyService dynamicPropertyService = (DynamicPropertyService)api.getServices().get(DynamicPropertyService.class);
            if (dynamicPropertyService != null && dynamicPropertyService.isEnabled()) {
                DynamicPropertyUpdater updater = new DynamicPropertyUpdater(api, this.executor);
                if (dynamicPropertyService.getProvider() == DynamicPropertyProvider.HTTP) {
                    HttpProvider provider = new HttpProvider(dynamicPropertyService);
                    provider.setHttpClientService(this.httpClientService);
                    provider.setNode(this.node);
                    updater.setProvider(provider);
                    updater.setApiService(this.apiService);
                    updater.setApiConverter(this.apiConverter);
                    this.logger.info("Add a scheduled task to poll dynamic properties each {}", (Object)dynamicPropertyService.getSchedule());
                    updater.handle(null);
                    CronHandler cronHandler = new CronHandler(this.vertx, dynamicPropertyService.getSchedule());
                    cronHandler.schedule(updater);
                    this.handlers.put(api, cronHandler);
                }
            } else {
                this.logger.info("Dynamic properties service is disabled for: {} [{}]", (Object)api.getName(), (Object)api.getVersion());
            }
        }
    }

    private void stopDynamicProperties(ApiEntity api) {
        CronHandler handler = this.handlers.remove(api);
        if (handler != null) {
            this.logger.info("Stop Dynamic properties service for API id[{}] name[{}]", (Object)api.getId(), (Object)api.getName());
            handler.cancel();
        }
    }
}

