/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties.spring;

import io.reactivex.annotations.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DynamicPropertiesConfiguration {
    @Bean(name={"dynamicPropertiesExecutor"})
    public Executor dynamicPropertiesExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 2, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private int counter = 0;

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "gio.dynamic-properties-" + this.counter++);
            }
        });
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }
}

