/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dynamicproperties.provider.http;

import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.definition.model.services.dynamicproperty.http.HttpDynamicPropertyProviderConfiguration;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.utils.NodeUtils;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.services.dynamicproperties.model.DynamicProperty;
import io.gravitee.rest.api.services.dynamicproperties.provider.Provider;
import io.gravitee.rest.api.services.dynamicproperties.provider.http.mapper.JoltMapper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.springframework.util.StringUtils;

public class HttpProvider
implements Provider {
    private static final String HTTPS_SCHEME = "https";
    private final HttpDynamicPropertyProviderConfiguration dpConfiguration;
    private JoltMapper mapper;
    private Vertx vertx;
    private Node node;

    public HttpProvider(DynamicPropertyService dpService) {
        Objects.requireNonNull(dpService, "Service must not be null");
        this.dpConfiguration = (HttpDynamicPropertyProviderConfiguration)dpService.getConfiguration();
        this.mapper = new JoltMapper(this.dpConfiguration.getSpecification());
    }

    @Override
    public CompletableFuture<Collection<DynamicProperty>> get() {
        final Promise promise = Promise.promise();
        URI requestUri = URI.create(this.dpConfiguration.getUrl());
        boolean ssl = HTTPS_SCHEME.equalsIgnoreCase(requestUri.getScheme());
        HttpClientOptions clientOptions = new HttpClientOptions().setSsl(ssl).setTrustAll(true).setMaxPoolSize(1).setKeepAlive(false).setTcpKeepAlive(false).setConnectTimeout(2000);
        final HttpClient httpClient = this.vertx.createHttpClient(clientOptions);
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : (HTTPS_SCHEME.equals(requestUri.getScheme()) ? 443 : 80);
        String relativeUri = requestUri.getRawQuery() == null ? requestUri.getRawPath() : requestUri.getRawPath() + "?" + requestUri.getRawQuery();
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.valueOf((String)this.dpConfiguration.getMethod().name())).setHost(requestUri.getHost()).setPort(Integer.valueOf(port)).setURI(relativeUri);
        options.putHeader("User-Agent", NodeUtils.userAgent((Node)this.node));
        options.putHeader("X-Gravitee-Request-Id", UuidString.generateRandom());
        if (this.dpConfiguration.getHeaders() != null) {
            this.dpConfiguration.getHeaders().forEach(httpHeader -> options.putHeader(httpHeader.getName(), httpHeader.getValue()));
        }
        httpClient.request(options).onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                promise.fail(event);
                httpClient.close();
            }
        }).onSuccess((Handler)new Handler<HttpClientRequest>(){

            public void handle(HttpClientRequest request) {
                request.response((Handler)new Handler<AsyncResult<HttpClientResponse>>(){

                    public void handle(AsyncResult<HttpClientResponse> asyncResponse) {
                        if (asyncResponse.failed()) {
                            promise.fail(asyncResponse.cause());
                            httpClient.close();
                        } else {
                            HttpClientResponse response = (HttpClientResponse)asyncResponse.result();
                            if (response.statusCode() == 200) {
                                response.bodyHandler(buffer -> {
                                    promise.complete(buffer);
                                    httpClient.close();
                                });
                            } else {
                                promise.complete(null);
                                httpClient.close();
                            }
                        }
                    }
                }).exceptionHandler((Handler)new Handler<Throwable>(){

                    public void handle(Throwable throwable) {
                        promise.fail(throwable);
                        httpClient.close();
                    }
                });
                if (!StringUtils.isEmpty((Object)HttpProvider.this.dpConfiguration.getBody())) {
                    request.end(HttpProvider.this.dpConfiguration.getBody());
                } else {
                    request.end();
                }
            }
        });
        return promise.future().map((Function)new Function<Buffer, Collection<DynamicProperty>>(){

            @Override
            public Collection<DynamicProperty> apply(Buffer buffer) {
                if (buffer == null) {
                    return null;
                }
                return HttpProvider.this.mapper.map(buffer.toString());
            }
        }).toCompletionStage().toCompletableFuture();
    }

    @Override
    public String name() {
        return "custom";
    }

    public void setMapper(JoltMapper mapper) {
        this.mapper = mapper;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setNode(Node node) {
        this.node = node;
    }
}

