/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.dictionary;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryProviderEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryTriggerEntity;
import io.gravitee.rest.api.service.event.DictionaryEvent;
import io.gravitee.rest.api.services.dictionary.DictionaryRefresher;
import io.gravitee.rest.api.services.dictionary.provider.http.HttpProvider;
import io.gravitee.rest.api.services.dictionary.provider.http.configuration.HttpProviderConfiguration;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DictionaryService
extends AbstractService
implements EventListener<DictionaryEvent, DictionaryEntity> {
    private final Logger logger = LoggerFactory.getLogger(DictionaryService.class);
    private static final String DICTIONARY_HTTP_PROVIDER = "HTTP";
    @Autowired
    private EventManager eventManager;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private io.gravitee.rest.api.service.configuration.dictionary.DictionaryService dictionaryService;
    @Autowired
    private Vertx vertx;
    @Autowired
    private Node node;
    private final Map<String, Long> timers = new HashMap<String, Long>();

    protected String name() {
        return "Dictionary Service";
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, DictionaryEvent.class);
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void onEvent(Event<DictionaryEvent, DictionaryEntity> event) {
        DictionaryEntity dictionary = (DictionaryEntity)event.content();
        switch ((DictionaryEvent)event.type()) {
            case START: {
                this.startDynamicDictionary(dictionary);
                break;
            }
            case STOP: {
                this.stopDynamicDictionary(dictionary);
                break;
            }
            case RESTART: {
                this.stopDynamicDictionary(dictionary);
                this.startDynamicDictionary(dictionary);
            }
        }
    }

    private void startDynamicDictionary(DictionaryEntity dictionary) {
        DictionaryProviderEntity providerConf;
        if (!this.timers.containsKey(dictionary.getId()) && DICTIONARY_HTTP_PROVIDER.equals((providerConf = dictionary.getProvider()).getType())) {
            try {
                HttpProviderConfiguration configuration = (HttpProviderConfiguration)this.objectMapper.treeToValue((TreeNode)providerConf.getConfiguration(), HttpProviderConfiguration.class);
                DictionaryRefresher refresher = new DictionaryRefresher(dictionary);
                HttpProvider provider = new HttpProvider(configuration);
                provider.setVertx(this.vertx);
                provider.setNode(this.node);
                refresher.setProvider(provider);
                refresher.setDictionaryService(this.dictionaryService);
                this.logger.info("Add a scheduled task to poll dictionary provider for dictionary [{}] each {} {} ", new Object[]{dictionary.getId(), dictionary.getTrigger().getRate(), dictionary.getTrigger().getUnit()});
                refresher.handle(null);
                long periodicTimer = this.vertx.setPeriodic(this.getDelayMillis(dictionary.getTrigger()), (Handler)refresher);
                this.timers.put(dictionary.getId(), periodicTimer);
            }
            catch (JsonProcessingException jpe) {
                this.logger.error("Dictionary provider configuration for dictionary [{}] is invalid", (Object)dictionary.getId(), (Object)jpe);
            }
        }
    }

    private long getDelayMillis(DictionaryTriggerEntity trigger) {
        switch (trigger.getUnit()) {
            case MILLISECONDS: {
                return trigger.getRate();
            }
            case SECONDS: {
                return trigger.getRate() * 1000L;
            }
            case MINUTES: {
                return trigger.getRate() * 1000L * 60L;
            }
            case HOURS: {
                return trigger.getRate() * 1000L * 60L * 60L;
            }
        }
        return -1L;
    }

    private void stopDynamicDictionary(DictionaryEntity dictionary) {
        Long timer = this.timers.remove(dictionary.getId());
        if (timer != null) {
            this.logger.info("Stop dictionary refresher task for dictionary [{}]", (Object)dictionary.getId());
            this.vertx.cancelTimer(timer.longValue());
        }
    }
}

