/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.fetcher;

import io.gravitee.common.service.AbstractService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.services.fetcher.spring.AutoFetchConfiguration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ScheduledAutoFetchService
extends AbstractService
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledAutoFetchService.class);
    @Autowired
    private TaskScheduler scheduler;
    @Autowired
    private AutoFetchConfiguration configuration;
    @Autowired
    private PageService pageService;
    private final AtomicLong counter = new AtomicLong(0L);

    protected String name() {
        return "Auto Fetch Service";
    }

    protected void doStart() throws Exception {
        if (this.configuration.isEnabled()) {
            super.doStart();
            LOGGER.info("Auto Fetch service has been initialized with cron [{}]", (Object)this.configuration.getCronTrigger());
            this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.configuration.getCronTrigger()));
        } else {
            LOGGER.warn("Auto Fetch service has been disabled");
        }
    }

    @Override
    public void run() {
        LOGGER.debug("Auto Fetch #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now());
        this.pageService.execAutoFetch();
        LOGGER.debug("Auto Fetch #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now());
    }
}

