/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.security.config;

import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.management.security.config.GraviteeCorsConfiguration;
import io.gravitee.rest.api.service.ParameterService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public class GraviteeUrlBasedCorsConfigurationSource
extends UrlBasedCorsConfigurationSource {
    private Map<String, GraviteeCorsConfiguration> corsConfigurationByOrganization = new HashMap<String, GraviteeCorsConfiguration>();
    private ParameterService parameterService;
    private EventManager eventManager;

    public GraviteeUrlBasedCorsConfigurationSource(ParameterService parameterService, EventManager eventManager) {
        this.parameterService = parameterService;
        this.eventManager = eventManager;
    }

    private String computeOrganizationId(HttpServletRequest request) {
        String path = request.getPathInfo();
        String organizationsResourcePath = "/organizations/";
        int organizationPathIndex = path.indexOf("/organizations/");
        if (organizationPathIndex > -1) {
            int orgIdStartIndex = organizationPathIndex + "/organizations/".length();
            return path.substring(orgIdStartIndex, path.indexOf(47, orgIdStartIndex));
        }
        return null;
    }

    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        String organizationId = this.computeOrganizationId(request);
        if (organizationId != null) {
            GraviteeCorsConfiguration corsConfiguration = this.corsConfigurationByOrganization.get(organizationId);
            if (corsConfiguration == null) {
                corsConfiguration = new GraviteeCorsConfiguration(this.parameterService, this.eventManager, organizationId);
                this.corsConfigurationByOrganization.put(organizationId, corsConfiguration);
            }
            return corsConfiguration;
        }
        return super.getCorsConfiguration(request);
    }
}

