/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl.binding;

import io.gravitee.rest.api.spec.converter.wsdl.WSDLUtils;
import io.gravitee.rest.api.spec.converter.wsdl.binding.AbstractBinding;
import io.gravitee.rest.api.spec.converter.wsdl.binding.BobyParts;
import io.gravitee.rest.api.spec.converter.wsdl.binding.HeaderDef;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.xml.namespace.QName;

public class Soap12Binding
extends AbstractBinding {
    public static final String SOAP12_ENVELOPE_NS = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP12_ENVELOPE_PREFIX = "soapenv";

    public Soap12Binding(boolean rpc) {
        super(SOAP12_ENVELOPE_NS, SOAP12_ENVELOPE_PREFIX, rpc);
    }

    @Override
    public boolean hasBodyElement(List<Object> elements) {
        Optional<SOAP12Body> optBody12 = WSDLUtils.extractFirstElement(elements, SOAP12Body.class);
        return optBody12.isPresent();
    }

    @Override
    public BobyParts extractBodyParts(List<Object> elements) {
        Optional<SOAP12Body> optBody12 = WSDLUtils.extractFirstElement(elements, SOAP12Body.class);
        Optional<BobyParts> optionalBobyParts = optBody12.map(body -> new BobyParts(body.getParts() == null ? Collections.emptyList() : body.getParts(), body.getUse()));
        return optionalBobyParts.orElse(null);
    }

    @Override
    public boolean hasHeadersElement(List<Object> elements) {
        Optional<SOAP12Header> optHeader12 = WSDLUtils.extractFirstElement(elements, SOAP12Header.class);
        return optHeader12.isPresent();
    }

    @Override
    public List<HeaderDef> extractHeaderParts(List<Object> elements) {
        return WSDLUtils.extractAllElements(elements, SOAP12Header.class).map(header -> new HeaderDef(header.getMessage(), header.getUse(), header.getPart(), header.getRequired())).collect(Collectors.toList());
    }

    @Override
    public String getRpcNamespace(BindingOperation bindingOperation) {
        Optional<SOAP12Body> optional = WSDLUtils.extractFirstElement(bindingOperation.getBindingInput().getExtensibilityElements(), SOAP12Body.class);
        return optional.get().getNamespaceURI();
    }

    @Override
    public QName buildAttribute(String localPart) {
        return new QName(SOAP12_ENVELOPE_NS, localPart, SOAP12_ENVELOPE_PREFIX);
    }
}

