/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.QualityRuleRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiQualityRule;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.QualityRule;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class QualityRulesScopingUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QualityRulesScopingUpgrader.class);
    private final QualityRuleRepository qualityRuleRepository;
    private final ApiQualityRuleRepository apiQualityRuleRepository;
    private final EnvironmentRepository environmentRepository;
    private final ApiRepository apiRepository;

    @Autowired
    public QualityRulesScopingUpgrader(@Lazy QualityRuleRepository qualityRuleRepository, @Lazy ApiQualityRuleRepository apiQualityRuleRepository, @Lazy EnvironmentRepository environmentRepository, @Lazy ApiRepository apiRepository) {
        this.qualityRuleRepository = qualityRuleRepository;
        this.apiQualityRuleRepository = apiQualityRuleRepository;
        this.environmentRepository = environmentRepository;
        this.apiRepository = apiRepository;
    }

    public int getOrder() {
        return 700;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(() -> {
            this.scopeExistingQualityRulesToEnvironments();
            return this.isUpgradeSuccessful();
        });
    }

    private boolean isUpgradeSuccessful() throws TechnicalException {
        List<QualityRule> qualityRulesWithNoReference = this.qualityRuleRepository.findAll().stream().filter(qr -> qr.getReferenceType() == null).toList();
        if (!qualityRulesWithNoReference.isEmpty()) {
            log.error("Upgrade failed!");
            log.error("The following quality rules have not been scoped at the environment level: {}", qualityRulesWithNoReference.stream().map(QualityRule::getId).toList());
            log.error("You can try to manually set the reference_type and reference_id to your default environment for these quality rules.");
            log.error("Then you can run the upgrader again.");
            return false;
        }
        return true;
    }

    private void scopeExistingQualityRulesToEnvironments() throws TechnicalException {
        log.info("Start scoping existing quality rules at the environment level");
        List<QualityRule> qualityRules = this.qualityRuleRepository.findAll().stream().filter(qr -> qr.getReferenceType() == null).toList();
        log.info("Found {} quality rules with no reference", (Object)qualityRules.size());
        List environments = this.environmentRepository.findAll().stream().toList();
        if (environments.isEmpty()) {
            log.error("No environment found, skipping scoping of quality rules");
            return;
        }
        Environment defaultEnv = environments.stream().filter(env -> env.getId().equals(GraviteeContext.getDefaultEnvironment())).findFirst().orElse((Environment)environments.get(0));
        log.info("Default environment is [{}]", (Object)defaultEnv.getId());
        List<Environment> otherEnvs = environments.stream().filter(env -> !env.getId().equals(defaultEnv.getId())).toList();
        log.info("Other environments are {}", otherEnvs.stream().map(Environment::getId).toList());
        for (QualityRule qualityRule : qualityRules) {
            try {
                this.scopeQualityRuleToEnvironments(qualityRule, defaultEnv, otherEnvs);
            }
            catch (TechnicalException e) {
                throw new TechnicalException("Error while scoping quality rule " + qualityRule.getId() + " to environments", (Throwable)e);
            }
        }
    }

    private void scopeQualityRuleToEnvironments(QualityRule qualityRule, Environment defaultEnv, List<Environment> otherEnvs) throws TechnicalException {
        log.info("Scoping quality rule [{}] to environments", (Object)qualityRule.getId());
        qualityRule.setReferenceType(QualityRule.ReferenceType.ENVIRONMENT);
        qualityRule.setReferenceId(defaultEnv.getId());
        this.qualityRuleRepository.update((Object)qualityRule);
        for (Environment otherEnv : otherEnvs) {
            QualityRule qualityRuleForOtherEnv = this.duplicateForEnv(qualityRule, otherEnv);
            this.qualityRuleRepository.create((Object)qualityRuleForOtherEnv);
            this.updateApiQualityRules(qualityRule, qualityRuleForOtherEnv, otherEnv);
        }
    }

    private void updateApiQualityRules(QualityRule qualityRuleForDefaultEnv, QualityRule qualityRuleForOtherEnv, Environment otherEnv) throws TechnicalException {
        List apiQualityRules = this.apiQualityRuleRepository.findByQualityRule(qualityRuleForDefaultEnv.getId());
        for (ApiQualityRule apiQualityRule : apiQualityRules) {
            log.debug("Updating api quality rule API [{}] - Quality rule [{}] for Environment [{}]", new Object[]{apiQualityRule.getApi(), apiQualityRule.getQualityRule(), otherEnv.getId()});
            Optional apiOptional = this.apiRepository.findById((Object)apiQualityRule.getApi());
            if (!apiOptional.isPresent() || !((Api)apiOptional.get()).getEnvironmentId().equals(otherEnv.getId())) continue;
            apiQualityRule.setQualityRule(qualityRuleForOtherEnv.getId());
            this.apiQualityRuleRepository.update(apiQualityRule);
        }
    }

    private QualityRule duplicateForEnv(QualityRule source, Environment environment) {
        return new QualityRule(UuidString.generateRandom(), QualityRule.ReferenceType.ENVIRONMENT, environment.getId(), source.getName(), source.getDescription(), source.getWeight(), source.getCreatedAt(), source.getUpdatedAt());
    }
}

