/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.application.registration.client;

import io.gravitee.rest.api.model.configuration.application.registration.KeyStoreEntity;
import io.gravitee.rest.api.model.configuration.application.registration.TrustStoreEntity;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.DynamicClientRegistrationException;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.DynamicClientRegistrationProviderClient;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.common.SecureHttpClientUtils;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.discovery.DiscoveryResponse;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.token.InitialAccessTokenProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class DiscoveryBasedDynamicClientRegistrationProviderClient
extends DynamicClientRegistrationProviderClient {
    private final String discoveryEndpoint;
    private final InitialAccessTokenProvider initialAccessTokenProvider;
    private final TrustStoreEntity trustStore;
    private final KeyStoreEntity keyStore;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public DiscoveryBasedDynamicClientRegistrationProviderClient(String discoveryEndpoint, InitialAccessTokenProvider initialAccessTokenProvider, TrustStoreEntity trustStore, KeyStoreEntity keyStore) {
        this.discoveryEndpoint = discoveryEndpoint;
        this.initialAccessTokenProvider = initialAccessTokenProvider;
        this.trustStore = trustStore;
        this.keyStore = keyStore;
        this.initialize();
    }

    private void initialize() {
        try {
            this.httpClient = SecureHttpClientUtils.createHttpClient(this.trustStore, this.keyStore);
            DiscoveryResponse discovery = (DiscoveryResponse)this.httpClient.execute((HttpUriRequest)new HttpGet(this.discoveryEndpoint), response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return (DiscoveryResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), DiscoveryResponse.class);
                    }
                    throw new DynamicClientRegistrationException("OIDC Discovery response is not well-formed");
                }
                this.logger.error("Unexpected response status from OIDC Discovery endpoint: status[{}] message[{}]", (Object)status, (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
                throw new DynamicClientRegistrationException("Unexpected response status from OIDC Discovery endpoint");
            });
            this.registrationEndpoint = discovery.getRegistrationEndpoint();
            this.attributes.put("token_endpoint", discovery.getTokenEndpoint());
            this.metadata.put("registration_endpoint", discovery.getRegistrationEndpoint());
            this.metadata.put("token_endpoint", discovery.getTokenEndpoint());
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while getting OIDC metadata from Discovery endpoint: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while getting OIDC metadata from Discovery endpoint: " + ex.getMessage(), ex);
        }
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getInitialAccessToken() {
        return this.initialAccessTokenProvider.get(this.attributes, this.trustStore, this.keyStore);
    }
}

